/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.dialog;

import com.genuitec.eclipse.core.util.UIUtil;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class XmlFileFilter
extends ViewerFilter {
    private static final String[] fgArchiveExtensions = new String[]{"xml"};
    private List fExcludes;

    public XmlFileFilter(IFile[] excludedFiles) {
        this.fExcludes = excludedFiles != null ? Arrays.asList(excludedFiles) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (this.fExcludes == null) return XmlFileFilter.isArchivePath(((IFile)element).getFullPath());
            if (!this.fExcludes.contains(element)) return XmlFileFilter.isArchivePath(((IFile)element).getFullPath());
            return false;
        }
        if (!(element instanceof IContainer)) return false;
        try {
            IResource[] resources = ((IContainer)element).members();
            int i = 0;
            while (true) {
                if (i >= resources.length) {
                    return false;
                }
                if (this.select(viewer, parent, resources[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((IStatus)e.getStatus());
        }
        return false;
    }

    public static boolean isArchivePath(IPath path) {
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            int i = 0;
            while (i < fgArchiveExtensions.length) {
                if (ext.equalsIgnoreCase(fgArchiveExtensions[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String openXmlFileDialog(IProject project, String webapp, String title, String message) {
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        XmlFileFilter filter = new XmlFileFilter(null);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(UIUtil.getActiveShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        String webappDir = webapp.substring(project.getName().length() + 1);
        if ("".equals(webappDir)) {
            dialog.setInput((Object)project);
        } else {
            dialog.setInput((Object)project.getFolder(webappDir));
        }
        dialog.setInitialSelection((Object)project);
        if (dialog.open() == 0) {
            String str = null;
            if (dialog.getResult()[0] instanceof IResource) {
                str = ((IResource)dialog.getResult()[0]).getFullPath().toString().substring(webapp.length() + 1);
            }
            if (!str.startsWith("/")) {
                str = "/" + str;
            }
            return str;
        }
        return null;
    }
}

