/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.gsdc;

import com.genuitec.eclipse.core.ViperCore;
import com.genuitec.eclipse.core.activation.ActivationCode;
import com.genuitec.eclipse.core.activation.InvalidSystemDataException;
import com.genuitec.eclipse.core.gsdc.SecureActivationReader;
import com.genuitec.eclipse.core.util.PlatformUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public final class GSDCController {
    private static final String I = "com.genuitec.myeclipse";
    private static final String L = "myeclipse.secure.activation";
    private static final String E = "myeclipse.secure.activation.properties";
    private static final String J = "ACTIVATION_SERVER";
    private static final String F = "MANUAL_ACTIVATION_URL";
    private static final String K = "ACTIVATION_PUBLIC_KEY";
    private static final String A = "ACTIVATION_TIME";
    private static final String G = "EXPIRY_WARN_DAYS";
    private static GSDCController M;
    private File D;
    private Properties B;
    private Properties C;
    private ActivationCode H;

    public static synchronized GSDCController getInstance() {
        GSDCController.B();
        return M;
    }

    public boolean isActive() {
        return this.B != null;
    }

    public boolean isManualActivationAllowed() {
        return this.isActive() && this.getActivationServerManualURL() != null;
    }

    public String getLicensee() {
        if (this.isActive()) {
            return this.B.getProperty("LICENSEE");
        }
        return null;
    }

    public synchronized String getLicenseKey() {
        String string = null;
        if (this.isActive()) {
            string = this.needsActivation() ? this.B.getProperty("LICENSE_KEY") : this.A().getLicenseCode();
        }
        return string;
    }

    private synchronized ActivationCode A() {
        try {
            if (this.H == null && !this.needsActivation()) {
                this.H = ActivationCode.fromCode(this.getActivationServerResponse());
            }
        }
        catch (InvalidSystemDataException invalidSystemDataException) {
            ViperCore.getDefault().log("GSDC: Unable to create ActivationCode. Cause: ", invalidSystemDataException);
        }
        return this.H;
    }

    public String getActivationServerURL() {
        if (this.isActive()) {
            return this.B.getProperty(J);
        }
        return null;
    }

    public String getActivationServerManualURL() {
        if (this.isActive()) {
            return this.B.getProperty(F);
        }
        return null;
    }

    public int getExpiryWarnDays() {
        String string;
        if (this.isActive() && !PlatformUtil.isNullOrEmpty((String)(string = this.B.getProperty(G)))) {
            int n = 15;
            try {
                n = Integer.parseInt(string);
                ViperCore.getDefault().log("GSDC: Number of days warning prior to product expiry was set to " + n + " days.", 1);
            }
            catch (NumberFormatException numberFormatException) {
                ViperCore.getDefault().log("GSDC: Expiry warning days in configuration file was not a valid integer number of days. The setting was ignored and the default of 30 days will be used. Cause: ", numberFormatException);
            }
            return n;
        }
        return 15;
    }

    public String getActivationServerPublicKey() {
        if (this.isActive()) {
            return this.B.getProperty(K);
        }
        return null;
    }

    public String getActivationServerResponse() {
        if (this.isActive()) {
            return this.C.getProperty("ACTIVATION_KEY");
        }
        return null;
    }

    public long getActivationServerResponseTime() {
        String string;
        if (this.isActive() && !PlatformUtil.isNullOrEmpty((String)(string = this.C.getProperty(A)))) {
            long l = 0L;
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                ViperCore.getDefault().log("GSDC: Activation time was not a valid time in millis. Ignored. Cause: ", numberFormatException);
            }
            return l;
        }
        return 0L;
    }

    public synchronized boolean needsActivation() {
        if (!this.isActive()) {
            return false;
        }
        String string = this.getActivationServerResponse();
        if (string == null) {
            return true;
        }
        try {
            boolean bl;
            ActivationCode activationCode = ActivationCode.fromCode(string);
            long l = System.currentTimeMillis();
            long l2 = 2592000000L;
            long l3 = l + l2;
            long l4 = l - 720000L;
            long l5 = l - 180000L;
            long l6 = activationCode.getExpirationDate().getTime();
            long l7 = this.getActivationServerResponseTime();
            boolean bl2 = l3 > l6;
            boolean bl3 = bl = l > l6;
            return bl && l7 < l5 || bl2 && l7 < l4;
        }
        catch (InvalidSystemDataException invalidSystemDataException) {
            ViperCore.getDefault().log("GSDC: Unable to create ActivationCode. Cause: ", invalidSystemDataException);
            return true;
        }
    }

    public synchronized void saveActivationResults(ActivationCode activationCode) {
        block13: {
            if (this.isActive()) {
                String string = activationCode.getActivationServerResponse();
                this.C.setProperty("ACTIVATION_KEY", string);
                this.C.setProperty(A, String.valueOf(System.currentTimeMillis()));
                this.H = activationCode;
                File file = new File(this.D, E);
                OutputStream outputStream = null;
                try {
                    try {
                        String string2 = activationCode.getLicenseCode();
                        outputStream = new FileOutputStream(file);
                        this.C.store(outputStream, "Activation results from GSDC. Subscription key in use is: " + string2);
                        ViperCore.getDefault().log("GSDC: Activation results stored successfully.  Activated key is: " + string2, 1);
                    }
                    catch (Exception exception) {
                        ViperCore.getDefault().log("GSDC: Unable to store activation results returned from secure server. Reason: ", exception);
                        if (outputStream == null) break block13;
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            ViperCore.getDefault().log("GSDC: Unable to close activation results file. Reason: ", iOException);
                        }
                    }
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            ViperCore.getDefault().log("GSDC: Unable to close activation results file. Reason: ", iOException);
                        }
                    }
                }
            }
        }
    }

    private static synchronized void B() {
        if (M == null) {
            try {
                try {
                    Location location = Platform.getConfigurationLocation();
                    URL uRL = location.getDataArea(I);
                    URI uRI = new URI(PlatformUtil.urlEncodeForSpaces((String)uRL.toExternalForm()));
                    File file = new File(uRI);
                    if (!file.exists()) {
                        location = Platform.getInstallLocation();
                        uRL = location.getDataArea("configuration/com.genuitec.myeclipse");
                        uRI = new URI(PlatformUtil.urlEncodeForSpaces((String)uRL.toExternalForm()));
                        file = new File(uRI);
                    }
                    if (file.exists()) {
                        ViperCore.getDefault().log("GSDC: Configuration directory exists at " + file.getAbsolutePath(), 1);
                        File file2 = new File(file, L);
                        if (file2.exists()) {
                            ViperCore.getDefault().log("GSDC: Secure configuration file exists at " + file2.getAbsolutePath(), 1);
                            Properties properties = SecureActivationReader.readSecurely(file2);
                            File file3 = new File(file, E);
                            Properties properties2 = new Properties();
                            if (file3.exists()) {
                                properties2.load(new FileInputStream(file3));
                            }
                            M = new GSDCController(file, properties, properties2);
                            ViperCore.getDefault().log("GSDC: Secure mode is active.", 1);
                        }
                    }
                }
                catch (Exception exception) {
                    ViperCore.getDefault().log("GSDC: Error while attempting to configure Genuitec secure activation server:\n", exception);
                    if (M == null) {
                        M = new GSDCController(null, null, null);
                    }
                }
            }
            finally {
                if (M == null) {
                    M = new GSDCController(null, null, null);
                }
            }
        }
    }

    private GSDCController(File file, Properties properties, Properties properties2) {
        this.D = file;
        this.B = properties;
        this.C = properties2;
    }
}

