/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core;

import com.genuitec.eclipse.core.E;
import com.genuitec.eclipse.core.GenuitecCoreLicenseDialog;
import com.genuitec.eclipse.core.GenuitecProductExpirationDialog2;
import com.genuitec.eclipse.core.LicenseUtil;
import com.genuitec.eclipse.core.URLMessageDialog;
import com.genuitec.eclipse.core.ViperCore;
import com.genuitec.eclipse.core.gsdc.GSDCController;
import com.genuitec.eclipse.core.ui.action.UpdateLicenseActionDelegate;
import com.genuitec.eclipse.core.ui.wizard.UpdateLicenseDialog;
import com.genuitec.eclipse.core.util.GenuitecProduct;
import com.genuitec.eclipse.core.util.PlatformUIUtil;
import java.text.MessageFormat;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class GenuitecPointsDialog
extends GenuitecProductExpirationDialog2 {
    public static final int BUYNOW_IDX = 10;
    public static final int EXTEND_IDX = 12;
    private boolean i = GSDCController.getInstance().isActive();
    private boolean g = false;

    public GenuitecPointsDialog(Shell shell, GenuitecCoreLicenseDialog.LicenseDialogMode licenseDialogMode) {
        super(shell, licenseDialogMode);
        boolean bl = ConfigurationScope.INSTANCE.getNode("com.genuitec.eclipse.core").getBoolean("had.license", false);
        this.g = !bl && !LicenseUtil.hasLicense();
    }

    @Override
    protected void createLinks(Composite composite) {
        int n = 0;
        if (!this.i) {
            if (this.mode == GenuitecCoreLicenseDialog.LicenseDialogMode.DAYS_LIMIT_EXCEEDED) {
                this.B(composite);
                ++n;
            }
            this.createSpacer(composite);
            ++n;
            this.createHyperlink(composite, "Help", GenuitecPointsDialog.getLearnMoreURL());
            ++n;
            this.createUpdateLicenseLink(composite);
            ++n;
            if (this.g && this.mode == GenuitecCoreLicenseDialog.LicenseDialogMode.DAYS_LIMIT_EXCEEDED) {
                this.C(composite);
                ++n;
            }
        }
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = n + 1;
    }

    @Override
    protected Object[] getPrimaryButtonDetails() {
        if (!this.i) {
            if (this.mode == GenuitecCoreLicenseDialog.LicenseDialogMode.PRO_CODER_ACHIEVED) {
                return new Object[]{"Continue", 16};
            }
            if (this.g) {
                return new Object[]{"Extend Trial", 12};
            }
            return new Object[]{"Buy Pro", 10};
        }
        return new Object[]{"Continue", 16};
    }

    @Override
    protected void setShellTitleMessage() {
        switch (this.mode) {
            case DAYS_LIMIT_EXCEEDED: {
                this.title = "Looks like you are a Pro!";
                this.Z = this.getProductMessage("You''ve been working under the Free plan for {0} which allows 8 days in a month.");
                this.Y = "You are now starting on your 9th day this month. Are you ready to jump to pro?";
                break;
            }
            case PRO_CODER_ACHIEVED: {
                this.title = "Pro Coder Achievement!";
                this.Z = MessageFormat.format("Congratulations!!! You have officially earned your lifetime Pro Coder badge by earning {0} lifetime pro points!  Keep up the good work!", 1000);
                this.Y = MessageFormat.format("As part of your free usage, each month you can use for free, {0} days of professional features. If you need more than {1} days per month, or you want extra benefits like additional support options, jump to a paid license now! This month you have used {2} days of Pro features.", 8, 8, E.S().W());
                this.X = this.getProductMessage("Thanks for continuing to use {0}, we appreciate your loyalty!");
                break;
            }
        }
    }

    @Override
    protected void createDetailsArea(Composite composite) {
        Label label = this.createWrappedLabel(composite);
        label.setText(this.Z);
        Label label2 = this.createWrappedLabel(composite);
        label2.setText(this.Y);
        if (this.X != null) {
            Label label3 = this.createWrappedLabel(composite);
            label3.setText(this.X);
        }
    }

    @Override
    protected void buttonPressed(int n) {
        this.setReturnCode(n);
        switch (n) {
            case 10: {
                this.A(true);
                break;
            }
            case 12: {
                this.A(false);
                break;
            }
            case 16: {
                this.close();
                break;
            }
            default: {
                this.close();
            }
        }
    }

    private void A(boolean bl) {
        this.close();
        if (bl) {
            if (!PlatformUIUtil.openLink((String)GenuitecPointsDialog.getProductPurchaseLink())) {
                new URLMessageDialog(this.getParentShell(), ViperCore.getDefault().getResourceString("LicenseValidator_dialog_buynowlink_title"), ViperCore.getDefault().getResourceString("LicenseValidator_dialog_subscriptionlink_message"), 4, GenuitecPointsDialog.getProductPurchaseLink()).open();
            }
        } else {
            boolean bl2 = GenuitecProduct.getCurrentProduct() == GenuitecProduct.ANGULAR_IDE;
            LicenseUtil.requestTrial(this.getParentShell(), bl2 ? "https://www.genuitec.com/products/angular-ide/trial/" : "https://www.genuitec.com/products/webclipse/trial/");
        }
        UpdateLicenseDialog updateLicenseDialog = new UpdateLicenseDialog(this.getParentShell(), bl ? UpdateLicenseDialog.UpdateLicenseDialogMode.PURCHASE_FLOW : UpdateLicenseDialog.UpdateLicenseDialogMode.EXTEND_TRIAL_FLOW);
        updateLicenseDialog.open();
    }

    protected void C(Composite composite) {
        Hyperlink hyperlink = this.createHyperlink(composite, "Buy Pro");
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                GenuitecPointsDialog.this.A(true);
            }
        });
    }

    @Override
    protected void createUpdateLicenseLink(Composite composite) {
        Hyperlink hyperlink = this.createHyperlink(composite, "Enter License");
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                GenuitecPointsDialog.this.close();
                UpdateLicenseActionDelegate.openLicenseDialog(GenuitecPointsDialog.this.getParentShell());
            }
        });
    }

    protected void B(Composite composite) {
        Hyperlink hyperlink = this.createHyperlink(composite, "Not Now", 16);
        GridData gridData = new GridData(32);
        hyperlink.setLayoutData((Object)gridData);
    }
}

