/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active;

import java.io.IOException;

public final class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static Appendable append(Appendable a, short in) {
        return Hex.append(a, (long)in, 4);
    }

    public static Appendable append(Appendable a, short in, int length) {
        return Hex.append(a, (long)in, length);
    }

    public static Appendable append(Appendable a, int in) {
        return Hex.append(a, (long)in, 8);
    }

    public static Appendable append(Appendable a, int in, int length) {
        return Hex.append(a, (long)in, length);
    }

    public static Appendable append(Appendable a, long in) {
        return Hex.append(a, in, 16);
    }

    public static Appendable append(Appendable a, long in, int length) {
        try {
            int lim = (length << 2) - 4;
            while (lim >= 0) {
                a.append(DIGITS[(byte)(in >> lim) & 0xF]);
                lim -= 4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return a;
    }

    public static Appendable append(Appendable a, byte[] bytes) {
        try {
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                a.append(DIGITS[(byte)((b & 0xF0) >> 4)]);
                a.append(DIGITS[(byte)(b & 0xF)]);
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return a;
    }

    public static long parseLong(CharSequence s) {
        long out = 0L;
        int shifts = 0;
        int i = 0;
        while (i < s.length() && shifts < 16) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 48);
            } else if (c > '@' && c < 'G') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 55);
            } else if (c > '`' && c < 'g') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 87);
            }
            ++i;
        }
        return out;
    }

    public static short parseShort(String s) {
        short out = 0;
        int shifts = 0;
        int i = 0;
        while (i < s.length() && shifts < 4) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c - 48);
            } else if (c > '@' && c < 'G') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c - 55);
            } else if (c > '`' && c < 'g') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c - 87);
            }
            ++i;
        }
        return out;
    }

    public static byte[] decodeHex(char[] data) throws Exception {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new Exception("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) throws Exception {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new Exception("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
            ++i;
        }
        return out;
    }

    public byte[] decode(byte[] array) throws Exception {
        return Hex.decodeHex(new String(array).toCharArray());
    }

    public Object decode(Object object) throws Exception {
        try {
            char[] charArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return Hex.decodeHex(charArray);
        }
        catch (ClassCastException e) {
            throw new Exception(e.getMessage());
        }
    }

    public byte[] encode(byte[] array) {
        return new String(Hex.encodeHex(array)).getBytes();
    }

    public Object encode(Object object) throws Exception {
        try {
            byte[] byteArray = object instanceof String ? ((String)object).getBytes() : (byte[])object;
            return Hex.encodeHex(byteArray);
        }
        catch (ClassCastException e) {
            throw new Exception(e.getMessage());
        }
    }
}

