/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.jsp.debug;

import com.genuitec.eclipse.core.util.UIDelegationUtils;
import com.genuitec.eclipse.j2eedt.core.IWebProject;
import com.genuitec.eclipse.j2eedt.core.JEEProjectManager;
import com.genuitec.eclipse.server.core.jsp.debug.ICompiledJspProducer;
import com.genuitec.eclipse.server.core.jsp.debug.Messages;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.launching.sourcelookup.JavaSourceLocator;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class JSPSourceLocator
extends JavaSourceLocator {
    public static boolean warningMessagePosted = false;
    public static final String ID_JSP_SOURCE_LOCATOR = "com.genuitec.eclipse.core.JSPSourceLocator";
    private IJavaProject[] fSourceProjects = JSPSourceLocator.getAllJavaProjects();

    public JSPSourceLocator() throws CoreException {
        super(JSPSourceLocator.getAllJavaProjects(), true);
    }

    public Object[] getSourceElements(IStackFrame stackFrame) {
        if (stackFrame instanceof IJavaStackFrame) {
            IJavaStackFrame frame = (IJavaStackFrame)stackFrame;
            String className = null;
            IServer server = null;
            String sourceName = null;
            JDIStackFrame jdiFrame = null;
            String locationSourceName = null;
            if (stackFrame instanceof JDIStackFrame) {
                jdiFrame = (JDIStackFrame)stackFrame;
                locationSourceName = null;
                try {
                    locationSourceName = jdiFrame.getSourcePath();
                }
                catch (Exception exception) {}
            }
            try {
                className = frame.getDeclaringTypeName();
                sourceName = locationSourceName != null ? locationSourceName : frame.getSourceName();
                server = ServerUtil.getServer((ILaunchConfiguration)frame.getLaunch().getLaunchConfiguration());
                if (className == null || sourceName == null) {
                    return null;
                }
            }
            catch (CoreException e) {
                e.getStatus().getCode();
                return null;
            }
            if (sourceName != null && !sourceName.endsWith(".java") && className != null && className.indexOf("jsp") >= 0) {
                ArrayList<IFile> list = new ArrayList<IFile>();
                IJavaProject[] projects = this.getSourceProjects();
                int i = 0;
                while (i < projects.length) {
                    IFile sourceElement = this.findJSPFileInProject(projects[i], sourceName, server);
                    if (sourceElement != null) {
                        list.add(sourceElement);
                    } else {
                        sourceElement = this.findJSPFileInProject(projects[i], className, server);
                        if (sourceElement != null) {
                            list.add(sourceElement);
                        }
                    }
                    ++i;
                }
                return list.size() > 0 ? list.toArray() : super.getSourceElements(stackFrame);
            }
            return super.getSourceElements(stackFrame);
        }
        return null;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object[] sourceElements = this.getSourceElements(stackFrame);
        if (sourceElements == null || sourceElements.length == 0) {
            return null;
        }
        Object chosenElement = sourceElements[0];
        if (sourceElements.length > 1) {
            int uniqueMatches = 0;
            IPath lastMatchPath = null;
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
            int i = 0;
            while (i < sourceElements.length) {
                if (sourceElements[i] instanceof IResource || sourceElements[i] instanceof ICompilationUnit) {
                    IResource curSource = null;
                    if (sourceElements[i] instanceof IResource) {
                        curSource = (IResource)sourceElements[i];
                    } else if (sourceElements[i] instanceof ICompilationUnit) {
                        curSource = ((ICompilationUnit)sourceElements[i]).getResource();
                    }
                    int j = 0;
                    while (j < breakpoints.length) {
                        IBreakpoint bp = breakpoints[j];
                        IMarker marker = bp.getMarker();
                        IResource markerResource = marker.getResource();
                        IPath markerPath = markerResource.getFullPath();
                        if (curSource.equals((Object)markerResource)) {
                            chosenElement = curSource;
                            if (!markerPath.equals(lastMatchPath)) {
                                ++uniqueMatches;
                                lastMatchPath = markerPath;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (uniqueMatches > 1) {
                try {
                    IProject prj;
                    String extension;
                    Object[] elements2;
                    IStackFrame[] frames = stackFrame.getThread().getStackFrames();
                    if (frames != null && frames.length > 1 && stackFrame.equals(frames[0]) && frames[1] instanceof JDIStackFrame && (elements2 = this.getSourceElements(frames[1])) != null && elements2.length == 1 && elements2[0] instanceof IFile && ("jsp".equals(extension = ((IFile)elements2[0]).getFileExtension()) || "jspx".equals(extension)) && (prj = ((IFile)elements2[0]).getProject()) != null) {
                        Object toReturn = null;
                        int objsFoundInProject = 0;
                        int i2 = 0;
                        while (i2 < sourceElements.length) {
                            if (sourceElements[i2] instanceof IResource || sourceElements[i2] instanceof ICompilationUnit) {
                                IResource curSource = null;
                                if (sourceElements[i2] instanceof IResource) {
                                    curSource = (IResource)sourceElements[i2];
                                } else if (sourceElements[i2] instanceof ICompilationUnit) {
                                    curSource = ((ICompilationUnit)sourceElements[i2]).getResource();
                                }
                                if (prj.equals((Object)curSource.getProject())) {
                                    toReturn = sourceElements[i2];
                                    ++objsFoundInProject;
                                }
                            }
                            ++i2;
                        }
                        if (objsFoundInProject == 1) {
                            return toReturn;
                        }
                    }
                }
                catch (DebugException debugException) {}
                if (!warningMessagePosted) {
                    warningMessagePosted = true;
                    new Job("notify the user"){
                        {
                            this.setSystem(true);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            UIDelegationUtils.openWarning((boolean)true, (String)Messages.JSPSourceLocator_dialog_ambigousfiles_title, (String)Messages.JSPSourceLocator_dialog_ambigousfiles_message);
                            warningMessagePosted = false;
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }
        return chosenElement;
    }

    public IJavaProject[] getSourceProjects() {
        return this.fSourceProjects;
    }

    private IFile findJSPFileInProject(IJavaProject javaProject, String className, IServer server) {
        ICompiledJspProducer cjp;
        IWebProject webProject = JEEProjectManager.createWebProject((IProject)javaProject.getProject());
        if (webProject == null) {
            return null;
        }
        ICompiledJspProducer iCompiledJspProducer = cjp = server != null ? (ICompiledJspProducer)server.loadAdapter(ICompiledJspProducer.class, null) : null;
        if (cjp == null) {
            return null;
        }
        String jspFileName = cjp.jspPathForJavaClassname(className);
        if (jspFileName == null) {
            return null;
        }
        IFile file = webProject.getRootFolder().getFile(jspFileName).getUnderlyingFile();
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static IJavaProject[] getAllJavaProjects() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] allProjects = root.getProjects();
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        int i = 0;
        int max = allProjects.length;
        while (i < max) {
            if (allProjects[i].isOpen() && allProjects[i].hasNature("org.eclipse.jdt.core.javanature")) {
                javaProjects.add((IJavaProject)allProjects[i].getNature("org.eclipse.jdt.core.javanature"));
            }
            ++i;
        }
        return javaProjects.toArray(new IJavaProject[javaProjects.size()]);
    }
}

