/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.internal;

import com.genuitec.eclipse.server.core.internal.ArgumentMerger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProgramArgumentMerger
extends ArgumentMerger {
    private final String[] source;
    private List<Change> changes = new ArrayList<Change>();
    private Change change;
    private String[] target;

    public ProgramArgumentMerger(String savedArgs, String curArgs, String newArgs) {
        super(savedArgs, curArgs, newArgs);
        this.source = this.savedArgs;
    }

    @Override
    protected List<String> internalMerge() {
        Change[] userChanges = this.compareChanges(this.curArgs);
        Change[] serverChanges = this.compareChanges(this.newArgs);
        ArrayList<String> result = new ArrayList<String>();
        int serverInd = 0;
        int userInd = 0;
        boolean pickUpMode = serverChanges.length == 0 || serverChanges[0].type == ChangeType.NO_CHANGE;
        while (serverInd < serverChanges.length) {
            int stopInd = serverChanges[serverInd].endSource;
            if (pickUpMode) {
                while (userInd < userChanges.length && userChanges[userInd].endSource <= stopInd) {
                    result.addAll(Arrays.asList(userChanges[userInd].getTarget()));
                    ++userInd;
                }
            } else {
                int endSource = serverChanges[serverInd].startSource;
                int startSource = userInd < userChanges.length ? userChanges[userInd].startSource : endSource;
                result.addAll(Arrays.asList(Arrays.copyOfRange(this.source, startSource, endSource)));
                result.addAll(Arrays.asList(serverChanges[serverInd].getTarget()));
                while (userInd < userChanges.length && userChanges[userInd].startSource < stopInd) {
                    ++userInd;
                }
                startSource = serverChanges[serverInd].endSource;
                endSource = userInd < userChanges.length ? userChanges[userInd].startSource : this.source.length;
                result.addAll(Arrays.asList(Arrays.copyOfRange(this.source, startSource, endSource)));
            }
            pickUpMode = !pickUpMode;
            ++serverInd;
        }
        return result;
    }

    private Change[] compareChanges(String[] target_) {
        this.changes.clear();
        this.target = target_;
        this.change = new Change();
        while (this.source.length > this.change.endSource && this.target.length > this.change.endTarget) {
            if (this.change.type == ChangeType.NO_CHANGE) {
                if (this.source[this.change.endSource].equals(this.target[this.change.endTarget])) {
                    ++this.change.endSource;
                    ++this.change.endTarget;
                    continue;
                }
                this.endNoChangeBlock();
                continue;
            }
            Match bestMatch = null;
            int sourceOffset = 0;
            while (this.change.startSource + sourceOffset < this.source.length && (bestMatch == null || bestMatch.getMaxOffset() >= sourceOffset)) {
                Match m;
                if ((m = this.findMatch(sourceOffset++)) == null || bestMatch != null && m.compareTo(bestMatch) <= 0) continue;
                bestMatch = m;
            }
            if (bestMatch == null) break;
            this.change.endTarget = this.change.startTarget + bestMatch.targetOffset;
            this.change.endSource = this.change.startSource + bestMatch.sourceOffset;
            this.changes.add(this.change);
            this.change = new Change(this.change);
            this.change.endSource = this.change.startSource + bestMatch.lenght;
            this.change.endTarget = this.change.startTarget + bestMatch.lenght;
            this.endNoChangeBlock();
        }
        if (this.change.type == ChangeType.NO_CHANGE) {
            this.endNoChangeBlock();
        }
        this.change.endSource = this.source.length;
        this.change.endTarget = this.target.length;
        if (this.change.endSource != this.change.startSource || this.change.endTarget != this.change.startTarget) {
            this.changes.add(this.change);
        }
        return this.changes.toArray(new Change[this.changes.size()]);
    }

    private void endNoChangeBlock() {
        if (this.change.startSource != this.change.endSource) {
            this.changes.add(this.change);
            this.change = new Change(this.change);
        }
        this.change.type = ChangeType.CHANGE;
    }

    private Match findMatch(int srcOffset) {
        int startTarget;
        int startSource = this.change.startSource + srcOffset;
        int targetPos = startTarget = this.change.startTarget;
        while (targetPos < this.target.length) {
            int l = 0;
            while (startSource + l < this.source.length && targetPos + l < this.target.length && this.source[startSource + l].equals(this.target[targetPos + l])) {
                ++l;
            }
            if (l > 0) {
                int targetOffset = targetPos - startTarget;
                return new Match(l, srcOffset, targetOffset);
            }
            ++targetPos;
        }
        return null;
    }

    private class Change {
        private String[] target_;
        public int startSource;
        public int endSource;
        public int startTarget;
        public int endTarget;
        public ChangeType type = ChangeType.NO_CHANGE;

        public Change() {
            this.startSource = 0;
            this.endSource = 0;
            this.startTarget = 0;
            this.endTarget = 0;
            this.init();
        }

        public Change(Change prev) {
            this.startSource = this.endSource = prev.endSource;
            this.startTarget = this.endTarget = prev.endTarget;
            this.init();
        }

        private void init() {
            this.target_ = ProgramArgumentMerger.this.target;
        }

        public String[] getTarget() {
            return Arrays.copyOfRange(this.target_, this.startTarget, this.endTarget);
        }

        public String[] getSource() {
            return Arrays.copyOfRange(ProgramArgumentMerger.this.source, this.startSource, this.endSource);
        }

        public String toString() {
            if (this.type == ChangeType.NO_CHANGE) {
                return Arrays.toString(this.getSource());
            }
            return String.valueOf(Arrays.toString(this.getSource())) + " => " + Arrays.toString(this.getTarget());
        }
    }

    private static enum ChangeType {
        NO_CHANGE,
        CHANGE;

    }

    private class Match
    implements Comparable<Match> {
        public final int lenght;
        public final int sourceOffset;
        public final int targetOffset;

        public Match(int lenght, int sourceOffset, int targetOffset) {
            this.lenght = lenght;
            this.sourceOffset = sourceOffset;
            this.targetOffset = targetOffset;
        }

        public int getMaxOffset() {
            return Math.max(this.targetOffset, this.sourceOffset);
        }

        @Override
        public int compareTo(Match o) {
            int res = o.getMaxOffset() - this.getMaxOffset();
            if (res != 0) {
                return res;
            }
            return this.lenght - o.lenght;
        }
    }
}

