/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.deployment;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.j2eedt.core.IEARProject;
import com.genuitec.eclipse.j2eedt.core.IJEEProject;
import com.genuitec.eclipse.j2eedt.core.IJEEProjectModule;
import com.genuitec.eclipse.j2eedt.core.IWebProject;
import com.genuitec.eclipse.j2eedt.core.JEEProjectManager;
import com.genuitec.eclipse.j2eedt.core.version.JEEProjectType;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.deployment.AbstractDeploymentProcessor;
import com.genuitec.eclipse.server.core.deployment.DeploymentUtils;
import com.genuitec.eclipse.server.core.deployment.IDeploymentProcessorFactory;
import com.genuitec.eclipse.server.core.deployment.ModuleFilesDeployer;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IPublishedModuleDeployment;
import org.eclipse.wst.server.core.model.ModuleDeltaKind;
import org.eclipse.wst.server.core.model.PublishDeltaKind;

public class ModuleDeployer
extends AbstractDeploymentProcessor {
    private static final String ATTR_MERGED_DEPLOYMENT = "merged-deployment";
    private static final String ATTR_TIMESTAMP = "file-timestamp";
    protected final PublishDeltaKind publishDelta;
    protected final File targetDirectory;
    protected final boolean isEAR;
    protected final List<IPath> dplEntries = new ArrayList<IPath>();
    protected final ModuleFilesDeployer filesDeployer;

    public ModuleDeployer(IDeploymentProcessorFactory factory, PublishDeltaKind publishDelta, IPublishedModuleDeployment deployment, MultiStatus status) throws GenuitecCoreException {
        super(factory, deployment, status);
        this.publishDelta = publishDelta;
        this.isEAR = this.project instanceof IEARProject;
        this.targetDirectory = this.getTargetDirectory();
        this.filesDeployer = this.createModuleFilesDeployer(this.dplEntries, this.targetDirectory, status);
        this.updateLocationForBrowse();
    }

    protected ModuleFilesDeployer createModuleFilesDeployer(List<IPath> dplEntries, File targetDirectory, MultiStatus status) {
        return new ModuleFilesDeployer(dplEntries, targetDirectory, status);
    }

    protected File getTargetDirectory() {
        return DeploymentUtils.getModuleDeploymentPhysicalLocation(this.deployment);
    }

    @Override
    protected void internalProcess(SubMonitor monitor) throws Exception {
        monitor.beginTask("", 1000000);
        try {
            if (this.publishDelta != PublishDeltaKind.PUBLISH_CLEAN) {
                monitor.subTask(MessageFormat.format("Hot syncing {0}", this.project.getName()));
                this.filesDeployer.removeResources(this.deployment.getPublishedResourceDelta(), monitor.newChild(200000));
            }
            this.saveChildModules(this.deployment.getChildDeployments(), monitor.newChild(400000));
            if (this.publishDelta == PublishDeltaKind.PUBLISH_AUTO || this.publishDelta == PublishDeltaKind.PUBLISH_INCREMENTAL) {
                if (this.deployment.getModuleDeltaKind() != ModuleDeltaKind.NO_CHANGE) {
                    monitor.subTask(MessageFormat.format("Hot syncing {0}", this.project.getName()));
                    this.filesDeployer.saveResources(this.deployment.getPublishedResourceDelta(), monitor.newChild(400000));
                }
            } else {
                monitor.subTask(MessageFormat.format("Deploying {0}", this.project.getName()));
                this.filesDeployer.saveResources(this.deployment.getResources(), monitor.newChild(400000));
            }
        }
        catch (GenuitecCoreException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)e);
        }
    }

    protected String getChildDeploymentLocation(IPublishedModuleDeployment childDeployment, IJEEProject childProject, boolean isMergedUtilityModule) {
        if (isMergedUtilityModule) {
            return "WEB-INF/classes";
        }
        return this.deployable.getURI(childDeployment.getModule());
    }

    protected boolean deployExploded(IPublishedModuleDeployment childDeployment, IJEEProject childProject, boolean isMergedUtilityModule, IPath moduleEntryPath) {
        JEEProjectType childType;
        JEEProjectType jEEProjectType = childType = childProject != null ? childProject.getType() : null;
        return isMergedUtilityModule || this.isEAR && (childType == JEEProjectType.EJB || childType == JEEProjectType.WEB || childType == JEEProjectType.JCA || childType == JEEProjectType.APP_CLIENT || childType == JEEProjectType.UTILITY && moduleEntryPath.segmentCount() == 1);
    }

    protected boolean supportsMergedDeployment() {
        return true;
    }

    protected void saveChildModules(List<IPublishedModuleDeployment> list, SubMonitor monitor) throws CoreException {
        this.componentsArchived.add(this.component);
        monitor.beginTask("", list.size() * 100200);
        boolean hasMergeUtilityModules = this.supportsMergedDeployment() && this.project instanceof IWebProject && ((IWebProject)this.project).isMergeUtilityModules();
        for (IPublishedModuleDeployment childDeployment : list) {
            IVirtualComponent moduleComponent;
            IJEEProjectModule module;
            if (!this.acceptChild(childDeployment, monitor.newChild(200))) continue;
            PublishDeltaKind publishDelta = this.publishDelta;
            IJEEProject child = JEEProjectManager.create((IProject)childDeployment.getModule().getProject());
            boolean isMergedUtilityModule = hasMergeUtilityModules && (module = this.project.getProjectModule(child)) != null && module.deployMerged();
            this.deployment.setAttribute(ATTR_MERGED_DEPLOYMENT, Boolean.toString(isMergedUtilityModule));
            String loc = this.getChildDeploymentLocation(childDeployment, child, isMergedUtilityModule);
            if (loc == null && childDeployment.getModuleDeltaKind() != ModuleDeltaKind.REMOVED) {
                this.status.add(ServerCorePlugin.createErrorStatus("Cannot determine location of module {0}", childDeployment));
                continue;
            }
            publishDelta = DeploymentUtils.processChildDeployment(this.publishDelta, childDeployment, loc, monitor.newChild(1000), this.status);
            if (publishDelta == null) continue;
            Path entryPath = new Path(childDeployment.getLocation());
            if (!isMergedUtilityModule) {
                this.dplEntries.add((IPath)entryPath);
            }
            if ((moduleComponent = this.getComponent(childDeployment)) == null) {
                this.status.add(ServerCorePlugin.createErrorStatus("Cannnot acquire IVirtualComponent for module {0}", childDeployment));
                continue;
            }
            if (this.componentsArchived.contains(moduleComponent)) continue;
            if (this.deployExploded(childDeployment, child, isMergedUtilityModule, (IPath)entryPath)) {
                this.saveExploded(publishDelta, childDeployment, monitor.newChild(99000));
                continue;
            }
            DeploymentUtils.publishZip(this.factory, publishDelta, childDeployment, new File(this.getTargetDirectory(), entryPath.toOSString()), this.componentsArchived, monitor.newChild(99000), this.status);
        }
    }

    protected void saveExploded(PublishDeltaKind publishDelta2, IPublishedModuleDeployment childDeployment, SubMonitor monitor) throws CoreException {
        ModuleDeployer saver = this.factory.createModuleDeployer(publishDelta2, childDeployment, this.status);
        saver.setArchivedComponents(this.componentsArchived);
        saver.processDeployment(monitor);
    }

    @Override
    protected void handleJarModule(IPublishedModuleDeployment childDeployment, IModuleFile file, SubMonitor monitor) throws GenuitecCoreException {
        long curTimestamp = file.getModificationStamp();
        String storedTimestamp = childDeployment.getAttribute(ATTR_TIMESTAMP);
        try {
            if ((this.publishDelta == PublishDeltaKind.PUBLISH_INCREMENTAL || this.publishDelta == PublishDeltaKind.PUBLISH_AUTO) && storedTimestamp != null && Long.parseLong(storedTimestamp) == curTimestamp) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.filesDeployer.copyFile((IModuleResource)file, file.getModuleRelativePath().append(file.getName()), false);
        childDeployment.setAttribute(ATTR_TIMESTAMP, Long.toString(curTimestamp));
    }
}

