/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.server.core.CustomConsoleDelegation;
import com.genuitec.eclipse.server.core.GenuitecServerBehaviour;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfig;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.ServerUtils;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerType;

public class GenuitecServerLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            ServerCorePlugin.getDefault().log("Launch configuration could not find server");
            return;
        }
        if (server.shouldPublish() && ServerCore.isAutoPublishing() && !((ServerType)server.getServerType()).startBeforePublish()) {
            server.publish(1, monitor);
        }
        GenuitecServerBehaviour genuitecServer = (GenuitecServerBehaviour)server.loadAdapter(GenuitecServerBehaviour.class, null);
        IGenuitecServerLaunchConfig config = genuitecServer.getServerLaunchConfig(configuration);
        String mainTypeName = config.getLaunchMainClass();
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(genuitecServer.getModeForVMRunner(mode));
        if (runner == null) {
            runner = vm.getVMRunner("run");
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        String[] envp = this.getEnvironment(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath = this.getClasspath(configuration);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(envp);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null && bootpath.length > 0) {
            runConfig.setBootClassPath(bootpath);
        }
        this.setDefaultSourceLocator(launch, configuration);
        if ("profile".equals(mode)) {
            throw new UnsupportedOperationException("Profiling not yet implemented");
        }
        genuitecServer.setupLaunch(launch, mode, monitor);
        try {
            genuitecServer.launchAboutToRun(launch, mode, monitor);
            runner.run(runConfig, launch, monitor);
            genuitecServer.setServerProcess(launch.getProcesses()[0], launch.getLaunchConfiguration());
        }
        catch (Exception exception) {
            if (launch.getLaunchConfiguration().getAttribute("IGenuitecServerLaunchConfigProvider.ATTR_SERVER_SHUTDOWN", false)) {
                genuitecServer.shutdownLaunchFinished();
            }
            genuitecServer.startupLaunchFinished();
        }
    }

    protected File getDefaultWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IGenuitecServerLaunchConfig config = ServerUtils.getLaunchConfig(configuration);
        return config != null && config.getLaunchWorkingDirectory() != null ? new File(config.getLaunchWorkingDirectory()) : super.getDefaultWorkingDirectory(configuration);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return CustomConsoleDelegation.createLaunch(configuration, mode);
    }
}

