/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active.ui.core;

import com.crack.me.active.ui.Loggable;
import com.crack.me.active.ui.core.JarReplacer;
import com.crack.me.active.ui.core.PublicKeyBytesReplacer;
import com.crack.me.active.ui.core.SignatureVerifierReplacer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeReplacer {
    private Loggable log = null;
    private List<JarReplacer> replacers = null;

    public MeReplacer(Loggable log) {
        this.log = log;
        this.initReplacers();
    }

    public void initReplacers() {
        this.replacers = new ArrayList<JarReplacer>(5);
        this.replacers.add(new SignatureVerifierReplacer(this.log));
        this.replacers.add(new PublicKeyBytesReplacer(this.log));
    }

    public void addReplacer(JarReplacer replacer) {
        if (replacer != null) {
            this.replacers.add(replacer);
        }
    }

    public boolean replace(File fileFolder) {
        List<File> allFiles = this.findFiles(fileFolder);
        return this.replace(allFiles);
    }

    private boolean replace(List<File> allFiles) {
        if (this.replacers == null || allFiles == null) {
            return false;
        }
        boolean success = true;
        for (JarReplacer rp : this.replacers) {
            this.log.log(rp.getProcessInfo());
            success &= rp.replace(allFiles);
        }
        return success;
    }

    private List<File> findFiles(File file) {
        this.log.log("finding files in [" + file.getAbsolutePath() + "]");
        return this.findFiles(file, JarReplacer.getFileFilter());
    }

    private List<File> findFiles(File file, FileFilter fileFliter) {
        if (!file.exists()) {
            return null;
        }
        if (file.isFile()) {
            ArrayList<File> tmpFiles = new ArrayList<File>(1);
            tmpFiles.add(file);
            return tmpFiles;
        }
        File[] files = file.listFiles(fileFliter);
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<File> fff = new ArrayList<File>(100);
        File[] fileArray = files;
        int n2 = files.length;
        int n3 = 0;
        while (n3 < n2) {
            File f2 = fileArray[n3];
            List<File> tmpFile = this.findFiles(f2, fileFliter);
            if (tmpFile != null) {
                fff.addAll(tmpFile);
            }
            ++n3;
        }
        return fff;
    }
}

