/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active.ui.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JarReplacer {
    public static final FileFilter jarFileFilter = new FileFilter(){

        public boolean accept(File paramFile) {
            return paramFile.isDirectory() || paramFile.getName().endsWith(".jar");
        }
    };
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");

    public boolean replace(List<File> fs) {
        if (fs == null) {
            return false;
        }
        boolean success = true;
        for (File file : fs) {
            if (!this.isFileLegal(file)) continue;
            success &= this.replace(file);
        }
        return success;
    }

    public abstract boolean replace(File var1);

    public abstract boolean isFileLegal(File var1);

    public abstract String getProcessInfo();

    public static FileFilter getFileFilter() {
        return jarFileFilter;
    }

    public List<File> findLegalFiles(List<File> files) {
        if (files == null) {
            return null;
        }
        ArrayList<File> needFiles = new ArrayList<File>();
        for (File file : files) {
            if (!this.isFileLegal(file)) continue;
            needFiles.add(file);
        }
        return needFiles;
    }

    public File createBakFile(File file) {
        String lastName = ".bak" + this.sdf.format(new Date());
        String bakFileName = file.getAbsoluteFile() + lastName;
        File newFile = new File(bakFileName);
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(file);
                out = new FileOutputStream(newFile);
                this.writeStream(in, out);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return null;
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
        return newFile;
    }

    public void writeStream(InputStream in, OutputStream out) throws IOException {
        byte[] data = new byte[1024];
        int len = -1;
        while ((len = in.read(data)) != -1) {
            out.write(data, 0, len);
        }
        out.flush();
    }

    public void writeJarEntry(InputStream in, JarOutputStream out) throws IOException {
        this.writeStream(in, out);
        in.close();
        out.flush();
        out.closeEntry();
    }

    public void addJarFile(String entryName, InputStream in, JarOutputStream out) throws IOException {
        JarEntry je = new JarEntry(entryName);
        out.putNextEntry(je);
        this.writeJarEntry(in, out);
    }

    public void addJarFile(String className, JarOutputStream out) throws IOException {
        this.addJarFile(className, ClassLoader.getSystemResourceAsStream(className), out);
    }
}

