--@name pkc_rpchandler
--@description RPC调用处理
--@auther redpig
--@date 2016-10-23

local TheNet = GLOBAL.TheNet
local IsServer = TheNet:GetIsServer()
local require = GLOBAL.require

---------Go back to home-----
--检查是否能传送
local function canTeleportFn(inst)
	if inst then
		local canTeleport = true
		if inst.components.sanity and inst.components.sanity.current >= 30 then
			inst.components.sanity:DoDelta(-10)
		else
			if inst.components.talker then
				inst.components.talker:Say("精神值太低，无法进行传送！")
			end
			canTeleport = false
		end
		if inst.components.hunger and inst.components.hunger.current >= 20 then
			inst.components.hunger:DoDelta(-10)
		else
			if inst.components.talker then
				inst.components.talker:Say("饥饿值太低，无法进行传送！")
			end
			canTeleport = false
		end
		return canTeleport
	end
	return false
end

--回城任务
local function goHomeTask(inst)
	inst:DoTaskInTime(1, function()
		if inst then
			--遇到以下情况回城中断
			if (inst.components.locomotor and inst.components.locomotor:WantsToMoveForward()) 
			or (inst.components.burnable and inst.components.burnable:IsBurning())
			or (inst.components.sleeper and inst.components.sleeper:IsAsleep())
			or (inst.components.health and inst.components.health:IsDead())
			then
				if inst:HasTag("pkc_gohome") then
					inst:RemoveTag("pkc_gohome")
				end
			end
			--回城计时
			if inst:HasTag("pkc_gohome") then
				if inst.goHomeCooldown ~= nil and inst.goHomeCooldown > 1 then
					inst.goHomeCooldown = inst.goHomeCooldown - 1
					--inst.AnimState:SetMultColour(0, 0, 0, (inst.goHomeCooldown/2)))
					goHomeTask(inst)
				else
					inst:DoTaskInTime(.2, function()
						if inst then
                            local found = nil
                            local founddistsq = nil
                            local a,b,c = inst.Transform:GetWorldPosition()
                            local ents = TheSim:FindEntities(a,b,c, 9001)
                            for k,v in pairs(ents) do
                                if v ~= inst and v.prefab == "homesign" then
                                    if not founddistsq or inst:GetDistanceSqToInst(v) < founddistsq then 
                                        found = v
                                        founddistsq = inst:GetDistanceSqToInst(v)
                                    end
							    end
                            end
      						if found then	
							    local ttt = found.components.writeable:GetText()									
								--传送回基地
								if ttt and ttt == "基地" then
									if canTeleportFn(inst) then
						            --teleport
										--fx1
						                local fx1 = GLOBAL.SpawnPrefab("small_puff")
						                if fx1 then
							                fx1.Transform:SetScale(1.5, 1.5, 1.5)
							                fx1.Transform:SetPosition(GLOBAL.Vector3(inst.Transform:GetWorldPosition()):Get())
						                end
										if inst.Physics ~= nil then
										    inst.Physics:Teleport(found.Transform:GetWorldPosition())
									    else
										    inst.Transform:SetPosition(found.Transform:GetWorldPosition())
									    end
									--fx2
									    local fx2 = GLOBAL.SpawnPrefab("small_puff")
									    if fx2 then
										    fx2.Transform:SetScale(1.5, 1.5, 1.5)
										    fx2.Transform:SetPosition(found.Transform:GetWorldPosition())
									    end
									end
								else
									inst.components.talker:Say("没有发现基地！")
							    end
							else
							    inst.components.talker:Say("没有发现基地！")
							end
						end
					end)
					--over
					--设置颜色
					--inst.AnimState:SetMultColour(1, 1, 1, 1)
					inst.goHomeCooldown = nil
					inst:RemoveTag("pkc_gohome")
				end
			else
				inst:DoTaskInTime(0, function()
					if inst.components.talker then
						inst.components.talker:Say("传送被打断！")
						inst.goHomeCooldown = nil
						--inst.AnimState:SetMultColour(1, 1, 1, 1)
					end
				end)
			end
		end
	end)
end

------回城按键处理-----
--@RedPig 12-23
AddModRPCHandler("pkc_keydown", "goHome", function(inst)
	if inst then
		inst:AddTag("pkc_gohome")
		if inst.goHomeCooldown == nil then
			inst.goHomeCooldown = 3
			inst:DoTaskInTime(0, function()
				if inst.components.talker then
					inst.components.talker:Say("准备传送回基地！")
				end
				--设置颜色
				--inst.AnimState:SetMultColour(0, 0, 0, 1)
			end)
			goHomeTask(inst)
		end
	end
end)

AddModRPCHandler("pkc_keydown", "fuhuo", function(inst)
	if inst and inst:HasTag("playerghost") then
		if inst.components.talker then
		    inst.components.talker:Say("30 秒后复活，请到安全的地方的等待！")
		end
		inst:DoTaskInTime(30, function()
			inst:PushEvent("respawnfromghost")
			inst.rezsource = "V 键复活"
		end)
		inst:DoTaskInTime(20, function()
			inst.components.talker:Say("10 秒后复活，请到安全的地方的等待！")
		end)
	end
end)

