Sub Usage
	WScript.Echo "Microsoft Search Version 2.0"
	WScript.Echo "Enable checkpointing on a search catalog"
	WScript.Echo
	WScript.Echo "Usage: enablecheckpoints.vbs Application Catalog"
	WScript.Echo
End Sub

Sub Main

	if WScript.Arguments.Count = 1 then
		if WScript.Arguments(0) = "/?" or WScript.Arguments(0) = "-?" then
			Usage
			WScript.Quit(1)
		end if
	    end if

	if (WScript.Arguments.Count <> 2) And (WScript.Arguments.Count <> 1) then
		Usage
		WScript.Quit(1)
	end if

	dim applicationName
	dim projectName
	applicationName = WScript.Arguments(0)
        if WScript.Arguments.Count = 2 then
		projectName = WScript.Arguments(1)
	end if

        dim objHost
        dim objBuildServer
        dim objBuildCatalog
	Set objHost = WScript.CreateObject("MSSearch.Admin")
        Set objBuildServer = objHost.Applications(applicationName).BuildServer
	if projectName <> "" then
		Set objBuildCatalog = objBuildServer.BuildCatalogs(projectName)
		objBuildCatalog.SetProperty "gatherer:use-check-points", True
		WScript.Echo "Enabled checkpoints on " & applicationName & "\" & projectName
	else
		objBuildServer.SetProperty "gatherer:use-check-points", True
		WScript.Echo "Enabled checkpoints on " & applicationName
	end if

End Sub

call Main
