﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using System.Data.SqlClient;

namespace DropDownFilter
{
    public class Northwind
    {
        string connStr;

        public Northwind()
        {
            connStr = System.Configuration.ConfigurationManager.ConnectionStrings["NorthwindConnectionString"].ConnectionString;
        }

        /// <summary>
        /// 得到客户数量；
        /// </summary>
        /// <param name="sqlCondition"></param>
        /// <returns></returns>
        public int GetCustomerCount(string sqlCondition)
        {
            string cmdText = "SELECT COUNT(*) FROM Customers " + sqlCondition;
            return (int)SqlHelper.ExecuteScalar(connStr, CommandType.Text, cmdText);
        }

        /// <summary>
        /// 得到客户记录；
        /// </summary>
        /// <param name="currPage"></param>
        /// <param name="pageSize"></param>
        /// <param name="sqlCondition"></param>
        /// <returns></returns>
        public DataTable GetCustomers(int currPage, int pageSize, string sqlCondition)
        {
            string cmdText = "SELECT * FROM Customers " + sqlCondition;

            int startRecord = (currPage - 1) * pageSize;

            return SqlHelper.ExecuteDataset(connStr, CommandType.Text, cmdText, startRecord, pageSize).Tables[0];
        }

        /// <summary>
        /// 得到客户记录；
        /// </summary>
        /// <param name="currPage"></param>
        /// <param name="pageSize"></param>
        /// <param name="sqlCondition"></param>
        /// <returns></returns>
        public DataTable GetCategories(int currPage, int pageSize, string sqlCondition)
        {
            string cmdText = "SELECT * FROM Categories " + sqlCondition;

            int startRecord = (currPage - 1) * pageSize;

            return SqlHelper.ExecuteDataset(connStr, CommandType.Text, cmdText, startRecord, pageSize).Tables[0];
        }
    }
}
