﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="UserEdit_WithEmployee.aspx.cs" Inherits="Chaokers.CN.SysMembership.Web.UserEdit_WithEmployee" %>

<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="System.Data.SqlClient" %>
<%@ Import Namespace="System.Xml" %>

<%@ Register assembly="Chaokers.CN.SysMembership.Components" namespace="Chaokers.CN.SysMembership.Components.Controls" tagprefix="cc1" %>    

<script language="C#" runat="server">
        protected override void OnLoad(EventArgs e)
        {                                                    
            if (!Page.IsPostBack)
            {
                //获取员工数据，以DataTable形式返回；
                DataTable employees = GetEmployees();

                //填充下拉列表；
                this.ddLstEmployee.DataSource = employees;
                this.ddLstEmployee.DataTextField = "EmployeeName";  //员工名称；
                this.ddLstEmployee.DataValueField = "EmployeeNo";   //员工编号；
                this.ddLstEmployee.DataBind();
                
                //如果正在修改账号信息，则自动选中该账号所绑定的员工；
                if (base.flag == 1)
                {
                    try
                    {
                        this.ddLstEmployee.ClearSelection();
                        this.ddLstEmployee.Items.FindByValue(base.userInfo.EmployeeNo).Selected = true;
                    }
                    catch { }
                    
                    this.ddLstEmployee.Enabled = false;
                }
            }
            
            base.OnLoad(e);
        }

        /// <summary>
        /// 权限系统调用者需要重新该方法，以返回一个至少具有下两列的弱类型数据表：        
        /// <para>------TableName（任意）-------------------</para>
        /// <para>-- EmployeeNo     string   --模块ID       </para>
        /// <para>-- EmployeeName   string   --模块名称     </para>
        /// <para>------------------------------------------</para>        
        /// </summary>
        /// <returns></returns>
        DataTable GetEmployees()
        {
            DataTable dtb = new DataTable();
            DataColumn col = null;
            DataRow r = null;

            col = new DataColumn("EmployeeNo");
            col.DataType = typeof(System.String);

            dtb.Columns.Add(col);

            col = new DataColumn("EmployeeName");
            col.DataType = typeof(System.String);

            dtb.Columns.Add(col);

            r = dtb.NewRow();
            r["EmployeeNo"] = "zhangsan";
            r["EmployeeName"] = "张三";
            dtb.Rows.Add(r);

            r = dtb.NewRow();
            r["EmployeeNo"] = "lisi";
            r["EmployeeName"] = "李四";
            dtb.Rows.Add(r);

            r = dtb.NewRow();
            r["EmployeeNo"] = "wangwu";
            r["EmployeeName"] = "王五";
            dtb.Rows.Add(r);

            return dtb;
        }
</script>        

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
<asp:Literal ID="Literal1" runat="server">操作员管理</asp:Literal>    
</head>
<body>
<div id="wrapper">    
<form id="form1" runat="server">

    <cc1:CurrLocation ID="CurrLocation1" runat="server" InnerText="角色与权限" />
    
    <br />
  
    <table cellspacing="0" cellpadding="3" class="editTable" border="1" bordercolor="<% = base.AppTheme.MainBorderColor %>" style="border-collapse:collapse;">
    <thead>
    <td height="20" colspan="4">
        <b><asp:Label ID="lblOperation" runat="server">添加操作员</asp:Label></b>        
    </td>
    </thead>
    <tr>
    <th><span class="mustFillFlag">*</span> 用户名</th>
    <td>
          <asp:TextBox ID="txtUserID" runat="server"
               CssClass="input"
               />       
          <asp:RequiredFieldValidator id="rfvUserID" runat="server" 
               ErrorMessage="用户名不能为空!" 
               ControlToValidate="txtUserID" 
               Display="None" />
    </td>
    <th><span class="mustFillFlag">*</span> 密码</th>
    <td>
          <asp:TextBox ID="txtPassword" runat="server"
               CssClass="input"                 
               />       
          <asp:RequiredFieldValidator id="RequiredFieldValidator1" runat="server" 
               ErrorMessage="密码不能为空!" 
               ControlToValidate="txtPassword" 
               Display="None" />
    </td>
    </tr>
    <tr>
    <th>所属角色</th>
    <td>
           <asp:CheckBoxList ID="cklRoles" runat="server"
             RepeatDirection="Horizontal"
             RepeatLayout="Table" 
             RepeatColumns="5"></asp:CheckBoxList>
    </td>
    <th>所属职工</th>
    <td>
            <asp:DropDownList ID="ddLstEmployee" runat="server">
            </asp:DropDownList>
    </td>
    </tr> 
    <tr>
    <td>&nbsp;</td>
    <td colspan="3">
          <asp:Button ID="btnSubmit" runat="server"
               Text=" 保存 "
               CssClass="btn"
               OnClick="btnSubmit_Click" />
          <asp:Label ID="lblResult" runat="server" />
          
          <asp:Button ID="btnCancel" runat="server"
               Text=" 返回 "
               CssClass="btn" 
               Onclick="btnCancel_Click"
               CausesValidation="false"
               />
          
          <asp:ValidationSummary id="ValidationSummary1"  runat="server" 
               ShowMessageBox="True" 
               ShowSummary="False" />
    </td>
    </tr>
    </table>


</div>
</form>

    

</body>
</html>
