﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ModuleEdit.aspx.cs" Inherits="Chaokers.CN.SysMembership.Web.ModuleEdit" %>
<%@ Import Namespace="System.Data" %>
<%@ Register assembly="Chaokers.CN.SysMembership.Components" namespace="Chaokers.CN.SysMembership.Components.Controls" tagprefix="cc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
<asp:Literal runat="server">模块管理</asp:Literal>    
</head>
<body>
<form id="form1" runat="server">
<div id="wrapper">      

    <cc1:CurrLocation ID="CurrLocation1" runat="server" InnerText="角色与权限/模块管理" />
    
    <div id="mainContainer">    
        
    <div class="note">
    <p>说明：模块（也就是常说的功能模块）是对权限的逻辑划分，一个模块可能包括多条权限数据。</p>
    </div>
    
    <br />
    
    <!--main.主表.begin-->
    <table cellspacing="0" cellpadding="0" class="editTable" border="1" bordercolor="<% = base.AppTheme.MainBorderColor %>" style="border-collapse:collapse;">
	<thead>
	<td height="25"><b>模块管理</b></td>
	</thead>
	<tr>
	<td class="content" valign="top" align="left">
        <!--main.明细表.begin-->           
        <div style="width:100%;height:200px;overflow:scroll;overflow-x:hidden;margin:-1px;">
        
        <asp:DataGrid ID="myDataGrid" Runat="server"
             Width="100%"
		     CellPadding="1"
		     ShowFooter="False"
		     AutoGenerateColumns="False"
		     OnEditCommand="myDataGrid_OnEditCommand"
		     OnCancelCommand="myDataGrid_OnCancelCommand"
		     OnUpdateCommand="myDataGrid_OnUpdateCommand"
		     OnDeleteCommand="myDataGrid_OnDeleteCommand"
		     OnItemCreated="myDataGrid_OnItemCreated"
		     BorderWidth="1px"
		     BorderStyle="Solid"
		     >
	    <HeaderStyle Height="22" Font-Bold="True" HorizontalAlign="Center"></HeaderStyle>
	    <ItemStyle Height="22" HorizontalAlign="Center"></ItemStyle>
	    <Columns>		
    	
	    <asp:BoundColumn HeaderText="ID" DataField="ModuleID" ReadOnly="true" HeaderStyle-Width="25px"></asp:BoundColumn>
    	
        <asp:TemplateColumn HeaderText="模块名" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="left">
        <ItemTemplate>
        &nbsp;<%# ((DataRowView)Container.DataItem)["ModuleName"] %>
        </ItemTemplate>
        <EditItemTemplate>
        <asp:TextBox ID="txtModuleName" runat="server" 
             Width="95%"
             Text='<%# ((DataRowView)Container.DataItem)["ModuleName"] %>'/>
        </EditItemTemplate>
        </asp:TemplateColumn>     

        <asp:TemplateColumn HeaderText="图标文件名" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="left">
        <ItemTemplate>
        &nbsp;<%# ((DataRowView)Container.DataItem)["Icon"]%>
        </ItemTemplate>
        <EditItemTemplate>
        <asp:TextBox ID="txtIcon" runat="server" 
             Width="95%"
             Text='<%# ((DataRowView)Container.DataItem)["Icon"] %>'/>
        </EditItemTemplate>
        </asp:TemplateColumn>     
        
        <asp:TemplateColumn HeaderText="排序值" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" HeaderStyle-Width="60px">
        <ItemTemplate>
        <%# ((DataRowView)Container.DataItem)["SortIndex"] %>
        </ItemTemplate>
        <EditItemTemplate>
        <asp:TextBox ID="txtSortIndex" runat="server" 
             Width="95%"
             Text='<%# ((DataRowView)Container.DataItem)["SortIndex"] %>'/>
        </EditItemTemplate>
        </asp:TemplateColumn>     
      
	    <asp:EditCommandColumn
		     EditText="编辑"
		     CancelText="取消"
		     UpdateText="更新"
		     ButtonType="PushButton"
		     HeaderStyle-Width="110px"
		     HeaderText="操作"/>
	    <asp:ButtonColumn
		     HeaderText="删除"
		     Text="删除"
		     CommandName="Delete"
		     ButtonType=PushButton
		     HeaderStyle-Width="80px"
		     />
        <asp:TemplateColumn HeaderStyle-Width="120px" HeaderText="权限数据管理">
        <ItemTemplate>
            <input type="button" value="权限数据管理" onclick="window.location.href='Privilege/PrivilegeEditList.aspx?ModuleID=<%# Eval("ModuleID")%>';" />
        </ItemTemplate>
        </asp:TemplateColumn>    		     		     
        <asp:TemplateColumn HeaderStyle-Width="10px"></asp:TemplateColumn>    		     
	    </Columns>
	    </asp:DataGrid>
        
        </div>
    </td>
    </tr>
    <tr>
    <td>
        <div style="padding:3px;">
        <table runat="server" cellpadding="0">
        <tr>
        <th>* 模块名称</th>
        <td style="text-align:left;">
	        <asp:TextBox ID="txtModuleName" Runat="server"
		         EnableViewState="False"
		         CssClass="input"
		         Width="150px"
		         ValidationGroup="AddModule"
		         MaxLength="30" />
	        <asp:RequiredFieldValidator id="rfvModuleName" runat="server" 
	             ErrorMessage="模块名称不能为空!" 
	             ControlToValidate="txtModuleName" 
	             ValidationGroup="AddModule"
	             Display="None" />       	        
             
        </td>
        <th>图标文件名</th>
        <td style="text-align:left;">
	        <asp:TextBox ID="txtIcon" Runat="server"
		         EnableViewState="False"
		         CssClass="input"
		         Width="150px"
		         MaxLength="30" />	     
            <asp:Button ID="btnSubmit" Runat="server" 
	             Text=" 保存 " 
	             CssClass="btn" 
	             OnClick="btnSubmit_Click"
	             ValidationGroup="AddModule" />

            <asp:ValidationSummary id="ValidationSummary1"  runat="server" 
                 ShowMessageBox="True" 
                 ShowSummary="False"
                 ValidationGroup="AddModule" />                    
        </td>
        </tr>
        </table>
        </div>
    </td>
    </tr>
    </table>  
    
    </div><!--"mainContainer.END"-->

</div><!--"wrapper.END"-->
</form>    
    
</body>
</html>
