﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Employees.aspx.cs" Inherits="SysMembership.Web.Employee.Employees" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="System.Data.SqlClient" %>
<%@ Import Namespace="System.Xml" %>

    <script language="C#" runat="server">
        protected override void OnLoad(EventArgs e)
        {                                        
            //获取员工数据，以DataTable形式返回；
            DataTable employees = GetEmployees();
            
            //将员工数据以Xml形式输出；
            base.OutputXml(employees);

            base.OnLoad(e);
        }

        /// <summary>
        /// 权限系统调用者需要重新该方法，以返回一个至少具有下两列的弱类型数据表：        
        /// <para>------TableName（任意）-------------------</para>
        /// <para>-- EmployeeNo     string   --模块ID       </para>
        /// <para>-- EmployeeName   string   --模块名称     </para>
        /// <para>------------------------------------------</para>        
        /// </summary>
        /// <returns></returns>
        DataTable GetEmployees()
        {
            DataTable dtb = new DataTable();
            DataColumn col = null;
            DataRow r = null;
            
            col = new DataColumn("EmployeeNo");
            col.DataType = typeof(System.String);

            dtb.Columns.Add(col);

            col = new DataColumn("EmployeeName");
            col.DataType = typeof(System.String);

            dtb.Columns.Add(col);

            r = dtb.NewRow();
            r["EmployeeNo"] = "zhangsan";
            r["EmployeeName"] = "张三";
            dtb.Rows.Add(r);

            r = dtb.NewRow();
            r["EmployeeNo"] = "lisi";
            r["EmployeeName"] = "李四";
            dtb.Rows.Add(r);

            r = dtb.NewRow();
            r["EmployeeNo"] = "wangwu";
            r["EmployeeName"] = "王五";
            dtb.Rows.Add(r);
            
            return dtb;
        }

        
    </script>