﻿function DataValidator()
{
    DataValidator.prototype.reDate = /^(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$/;
    //   /^(\d{2}|\d{4})-(([1-9])|(1[0-2]))-(([1-9])|([12]\d)|(3[01]))$/; //日期format: yyyy-MM-DD, yy-MM-DD
    // /^(\d{1,4})(-|\/|.)(\d{1,2})\2(\d{1,2})$/ 	//日期format: yyyy-M-d, yy-M-d
	DataValidator.prototype.reEmail = /^\w+([-.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;					//信箱
	DataValidator.prototype.reChinese = /^[\u4E00-\u9FA5]+$/;											//中文
	DataValidator.prototype.reZipcode = /^[1-9]\d{5}$/;													//邮编 
	DataValidator.prototype.reTele = /^((^[0-9]{3,4}[0-9]{7,8}$)|(^[0-9]{7,8}$)|(^\([0-9]{3,4}\)[0-9]{3,8}$))/;	//电话
	DataValidator.prototype.reMobile = /^1[3,5,8]{1}[0-9]{1}[0-9]{8}$/;									//手机
	DataValidator.prototype.reCurrency = /^\d+(\.\d{1,4})?$/;											//货币
	DataValidator.prototype.reNumber = /^\d+$/;															//数字
	DataValidator.prototype.reInteger = /^[-\+]?\d+$/;													//整数
	DataValidator.prototype.reFloat = /^[-\+]?\d+(\.\d+)?$/;	                                            //有理数
	DataValidator.prototype.rePlus = /^([1-9]\d*|[0])$/;                                                 //非负整数
	DataValidator.prototype.reIP = /^((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)$/;//IP地址
	//DataValidator.prototype.rePerson = /^(\d{15}$|^\d{18}$|^\d{17}(\d|X|x))$/;   
	DataValidator.prototype.reIDCardNum = /^(\d{15}$)|(^\d{17}([0-9]|x)$)/;                        //身份证号码
	DataValidator.prototype.reStringNum = /^(A-Za-z0-9)/;

	//()与|连用重要(|)
	
	//验证仅数字和字母类型
	DataValidator.prototype.isStrNum = function(StrNum)
	{
		return this.reStringNum.test(StrNum);
	}
	
    //验证邮编类型
	DataValidator.prototype.isZipcode = function(zipcode)
	{
		return this.reZipcode.test(zipcode);
	}
	
    //验证日期类型
	DataValidator.prototype.isDate = function(date)
	{
		return this.reDate.test(date);
	}
    
    //验证电子邮箱；
	DataValidator.prototype.isEmail = function(email)
	{
		return this.reEmail.test(email);
    }
    
    //汉字；
	DataValidator.prototype.isChinese = function(cn)
	{
		return this.reChinese.test(cn);
    }
    
    //数字
	DataValidator.prototype.isNumber = function(number)
	{
		return this.reNumber.test(number);
    }

    //整数；
	DataValidator.prototype.isInteger = function(number)
	{
	    return this.reInteger.test(number);
	}

    //浮点数;
	DataValidator.prototype.isFloat = function(number)
	{
		return this.reFloat.test(number);
    }

    //正整数
	DataValidator.prototype.isPlus = function(number)
	{
	    return this.rePlus.test(number);
	}
	
    //IP
    DataValidator.prototype.isIP = function(number)
	{
	    return this.reIP.test(number);
	}
	
    //手机号；
    DataValidator.prototype.isMobile = function(mobile)
	{
	    return this.reMobile.test(mobile);
	}
	
    //电话；
    DataValidator.prototype.isTel = function(telphone)
	{
	    return this.reTele.test(telphone);  //原为reMobile 改为rePhone PM:7:51 1-5
	}
	
    //身份证号；
	DataValidator.prototype.isIDCardNum = function (IDCardNum)
	{
	    return this.reIDCardNum.test(IDCardNum);
	}
}


