﻿    //作者：陈志豪 2007-11-26 QQ:45971143
    //本页面中的函数适用于IE和firefox

    var defaultProvinceName = "河南省";
    var defaultProvinceID = "";
    var defaultCityName = "郑州市";
    var defaultCityID = "";
    var defaultZoneName = "二七区";
    var defaultZoneID = "";
            
    //---------------------------------------------------//       
    
    //浏览器检测函数
    function chkBrowser()
    {
        if (document.all) { borwserType = 0; } //如果是IE 
        else { borwserType = 1; } //如果是FireFox 
    }    
    
    //浏览器类型标记
    var borwserType = 0; //0 : IE, 1 : Firefox
                      
    
    //检测浏览器
    chkBrowser();

    //设置默认地区；
    function setDefaultPlace(proviceName, cityName, zoneName) {
        defaultProvinceName = proviceName;
        defaultCityName = cityName;
        defaultZoneName = zoneName;
    }
    //设置默认地区；
    function setDefaultPlaceByID(proviceID, cityID, zoneID) {
        defaultProvinceID = proviceID;
        defaultCityID = cityID;
        defaultZoneID = zoneID;
    }

    //填充省份；
    function fillProvincObj(provinceObj, cityObj, zoneObj) {
        if (borwserType == 0) { fillProvinceObjIE(provinceObj, cityObj, zoneObj); }   //如果是IE
        else { fillProvinceObjFX(provinceObj, cityObj, zoneObj); }
    }
    
    //省份变化时
    function provinceChange(provinceObject, cityObj, zoneObj)
    {
        if (borwserType == 0) provinceChangeIE(provinceObject, cityObj, zoneObj); //IE条件下
        else provinceChangeFX(provinceObject, cityObj, zoneObj); //Firefox条件下
    }
    
    //城市变化时
    function cityChange(cityObject,zoneObj)
    {
        if (borwserType == 0) cityChangeIE(cityObject, zoneObj); //IE条件下
        else cityChangeFX(cityObject, zoneObj); //Firefox条件下
    }
    
    
    //-------------------For IE------------------------------------

    //填充省份        
    function fillProvinceObjIE(provinceObj, cityObj, zoneObj)
    {
        //填充省份下拉框第一项
        var firstOption = document.createElement("option");
        provinceObj.options.add(firstOption);
        firstOption.innerText = "省份"; 
        firstOption.value = ""; 
        firstOption.inValue = "";
       
        //填充省份下拉列表对象 
        for(i=0;i<provinceArray.length;i++)
        { 
            var oOption = document.createElement("option");
            provinceObj.options.add(oOption);
            
            var optionText = provinceArray[i].split("|")[1]; //得到text值
            var optionValue = provinceArray[i].split("|")[0]; //得到value值
            var originalOptionValue = optionValue;

            optionValue = optionValue + "|" + optionText; //为了在使用的时候方便取值，所以令optionValue = optionValue + "|" + optionText;
            
            oOption.innerText = optionText;
            oOption.value = optionValue;

            if (defaultProvinceID != "") {

                if (originalOptionValue == defaultProvinceID) {
                    //alert(defaultProvinceID);
                    oOption.setAttribute("selected", "selected");
                    provinceChange(provinceObj, cityObj, zoneObj);
                }
            }
            else {
                if (optionText == defaultProvinceName) {
                    oOption.setAttribute("selected", "selected");
                    provinceChange(provinceObj, cityObj, zoneObj);
                }
            }
        }     
    }

    //选定省份时，获取该省份下的所有城市列表
    function provinceChangeIE(selProvince,cityObj,zoneObj) {
        
        //清除cityObj中的所有options
        while(cityObj.options.length>0)
        {
            cityObj.options.remove(0);
        }
        
        //填充城市下拉框第一项
        var firstOption = document.createElement("option");
        cityObj.options.add(firstOption);
        firstOption.innerText = "地级市";
        firstOption.value = ""; 
        firstOption.inValue = "";          
        
        //---------------------------------------------------//
        
        //清除zoneObj中的所有options
        while(zoneObj.options.length>0)
        {         
            zoneObj.options.remove(0);
        }
        
        //填充区县下拉框第一项
        var firstOption = document.createElement("option");
        zoneObj.options.add(firstOption);
        firstOption.innerText = "区、县级市、县";
        firstOption.value = ""; 
        firstOption.inValue = ""; 
        
        //---------------------------------------------------//
                       
        //得到省份ID                    
        var provinceID = -1; 
        if(selProvince.selectedIndex>=0) 
        {
            provinceID = selProvince.options[selProvince.selectedIndex].value.split("|")[0]; 
        }
        
        //遍历整个城市数组(cityArray)，找到 数组中第一个元素与选定省份对应的 项
        for (var i=0;i<cityArray.length;i++)
        {
            if (cityArray[i][0] == provinceID) //如果找到了对应的省份，则开始获取该省份下的所有区县列表
            {
                var currCityObj = cityArray[i];                                
                
                for (var j=1;j<currCityObj.length;j++)
                {
                    var oOption = document.createElement("option");
                    cityObj.options.add(oOption);
                    
                    var optionText = currCityObj[j].split("|")[1]; //得到text值
                    var optionValue = currCityObj[j].split("|")[0]; //得到value值
                    var originalOptionValue = optionValue;

                    optionValue = optionValue + "|" + optionText; //为了在使用的时候方便取值，所以令optionValue = optionValue + "|" + optionText;
            
                    oOption.innerText = optionText;
                    oOption.value = optionValue;

                    if (defaultCityID != "") {
                        if (originalOptionValue == defaultCityID) {
                            oOption.setAttribute("selected", "selected");
                            cityChange(cityObj, zoneObj);
                        } 
                    }
                    else {
                        if (optionText == defaultCityName) {
                            oOption.setAttribute("selected", "selected");
                            cityChange(cityObj, zoneObj);
                        }
                    }                       
                }                
            }            
        }
    }
    
    //选定城市时，获取该城市下的所有区县列表
    function cityChangeIE(selCity,zoneObj)
    {
        //清除zoneObj中的所有options
        while(zoneObj.options.length>0)
        {
            zoneObj.options.remove(0);
        }
        
        //填充区县下拉框第一项
        var firstOption = document.createElement("option");
        zoneObj.options.add(firstOption);
        firstOption.innerText = "区、县级市、县";
        firstOption.value = ""; 
        firstOption.inValue = ""; 
        
        //---------------------------------------------------//
           
        //得到城市ID
        var cityID = -1; 
        if(selCity.selectedIndex>=0) 
        {
            cityID = selCity.options[selCity.selectedIndex].value.split("|")[0]; 
        }

        //遍历整个区县数组(cityArray)，找到 数组中第一个元素与选定城市对应的 项                   
        for (var i=0;i<zoneArray.length;i++)
        {
            if (zoneArray[i][0] == cityID) //如果找到了对应的城市，则开始获取该城市下的所有区县
            {
                var currZoneObj = zoneArray[i];                   
                
                for (var j=1;j<currZoneObj.length;j++)
                {
                    var oOption = document.createElement("option");
                    zoneObj.options.add(oOption);
                    
                    var optionText = currZoneObj[j].split("|")[1]; //得到text值
                    var optionValue = currZoneObj[j].split("|")[0]; //得到value值
            
                    optionValue = optionValue + "|" + optionText; //为了在使用的时候方便取值，所以令optionValue = optionValue + "|" + optionText;
            
                    oOption.innerText = optionText;
                    oOption.value = optionValue;

                    if (optionText == defaultZoneName) {
                        oOption.setAttribute("selected", "selected");
                    }                              
                }                
            }            
        }
    }
    
    
    //-------------------For firefox------------------------------------
    
    
    //填充省份
    function fillProvinceObjFX(provinceObj, cityObj, zoneObj)
    {                   
        var str = "<option value=''>省份</option> \n";
         
        //填充省份下拉列表对象 
        for(i=0;i<provinceArray.length;i++)
        { 
            var optionText = provinceArray[i].split("|")[1]; //得到text值
            var optionValue = provinceArray[i].split("|")[0]; //得到value值
            var originalOptionValue = optionValue;

            optionValue = optionValue + "|" + optionText; //为了在使用的时候方便取值，所以令optionValue = optionValue + "|" + optionText;


            if (defaultProvinceID != "") {
                if (originalOptionValue == defaultProvinceID) {
                    str += "<option value='" + optionValue + "' selected='selected'>" + optionText + "</option> \n";
                }
                else {
                    str += "<option value='" + optionValue + "'>" + optionText + "</option> \n";
                }
            }
            else {
                if (optionText == defaultProvinceName) {
                    str += "<option value='" + optionValue + "' selected='selected'>" + optionText + "</option> \n";
                }
                else {
                    str += "<option value='" + optionValue + "'>" + optionText + "</option> \n";
                }
            }
        }

        provinceObj.innerHTML = str;
        provinceChange(provinceObj, cityObj, zoneObj);
    }

    //选定省份时，获取该省份下的所有城市列表
    function provinceChangeFX(selProvince, cityObj, zoneObj)
    {
        var str = "<option value=''>地级市</option> \n";
                
        zoneObj.innerHTML = "<option value=''>区、县级市、县</option> \n";

        //得到省份ID                    
        var provinceID = -1; 
        if(selProvince.selectedIndex>=0) {
            provinceID = selProvince.options[selProvince.selectedIndex].value.split("|")[0];            
        }
           
        //遍历整个城市数组(cityArray)，找到 数组中第一个元素与选定省份对应的 项
        for (var i=0;i<cityArray.length;i++) {
              
            if (cityArray[i][0] == provinceID) //如果找到了对应的省份，则开始获取该省份下的所有区县列表
            {   
                var currCityObj = cityArray[i];
                
                for (var j=1;j<currCityObj.length;j++)
                {
                    var optionText = currCityObj[j].split("|")[1]; //得到text值
                    var optionValue = currCityObj[j].split("|")[0]; //得到value值
                    var originalOptionValue = optionValue;

                    optionValue = optionValue + "|" + optionText; //为了在使用的时候方便取值，所以令optionValue = optionValue + "|" + optionText;

                    if (defaultCityID != "") {
                        if (originalOptionValue == defaultCityID) {
                            str += "<option value='" + optionValue + "' selected='selected'>" + optionText + "</option> \n";
                        }
                        else {
                            str += "<option value='" + optionValue + "'>" + optionText + "</option> \n";
                        }
                    }
                    else {
                        if (optionText == defaultCityName) {
                            str += "<option value='" + optionValue + "' selected='selected'>" + optionText + "</option> \n";
                        }
                        else {
                            str += "<option value='" + optionValue + "'>" + optionText + "</option> \n";
                        }
                    }                                                                            
                }
            }                                    
        }

        cityObj.innerHTML = str;
        cityChange(cityObj, zoneObj);
    }
    
    //选定城市时，获取该城市下的所有区县列表
    function cityChangeFX(selCity,zoneObj)
    {
        var str = "<option value=''>区、县级市、县</option> \n";
       
        //得到城市ID                 
        var cityID = -1; 
        if(selCity.selectedIndex>=0) 
        {
            cityID = selCity.options[selCity.selectedIndex].value.split("|")[0];
        } 

        //遍历整个区县数组(cityArray)，找到 数组中第一个元素与选定城市对应的 项                   
        for (var i=0;i<zoneArray.length;i++)
        {
            if (zoneArray[i][0] == cityID) //如果找到了对应的城市，则开始获取该城市下的所有区县
            {
                var currZoneObj = zoneArray[i];                   
                            
                for (var j=1;j<currZoneObj.length;j++)
                {
                    var optionText = currZoneObj[j].split("|")[1]; //得到text值
                    var optionValue = currZoneObj[j].split("|")[0]; //得到value值
                    
                    optionValue = optionValue + "|" + optionText; //为了在使用的时候方便取值，所以令optionValue = optionValue + "|" + optionText;

                    if (optionText == defaultZoneName) {
                        str += "<option value='" + optionValue + "' selected='selected'>" + optionText + "</option> \n";
                    }
                    else {
                        str += "<option value='" + optionValue + "'>" + optionText + "</option> \n";
                    }
                }              
            }            
        }
        
        zoneObj.innerHTML = str;
    }