﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="order_create_takefood.aspx.cs" Inherits="VA.Modules.JDingCYTPad.mainbiz.diancai" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/editlist.aspx"-->
<link rel="stylesheet" type="text/css" href="../app_themes/default/css/foodtake.css" />
<link rel="stylesheet" type="text/css" href="/scripts/jquery/plugins/simplemodal-1.4.4/css/basic.css" />
<!--#include virtual="../include/js/editlist_s.aspx"--> 
<script type="text/javascript" src="/scripts/jquery/plugins/simplemodal-1.4.4/js/jquery.simplemodal.js"></script>
<script type="text/javascript" src="../scripts/page/order_create_takefood.js"></script>
<script type="text/javascript">         
    var foodMenuItemArray = new Array();
    onPageInited = function () {
        initListPage();
        setLayout();
        initIndexPanel();
        loadFood();    
        getTableInfo();
    }

    function setLayout(){
        var dataBarHeight = $("#dataBar").outerHeight();
        $("#itemContainer").height(dataBarHeight);
        $("#itemContainerWrapper").height(dataBarHeight);
        $("#categoriesPanel").height(dataBarHeight);
    }

    //初始化字母索引面板；
    function initIndexPanel(){
        var dataBarHeight = $("#dataBar").outerHeight();
        $("#indexPanel").height(dataBarHeight);
   
        var tableNo = $("#hfTableNo").val();        
        var itemCategory = $("#hfItemCategory").val();
        var itemType = $("#hfItemType").val();
        $("#letterIndexer").find("li").click(function(){
            var letter = $(this).html();
            if (letter == "全部"){
                letter = "";
            }
            //老方案；
            //window.location.href = "?tableno=" + tableNo + "&category="+ itemCategory +"&itemtype="+ itemType +"&letter=" + letter;

            //新方案；
            window.location.href = "#" + letter;
            $("#tableBody").find("h1.itemName").each(function(){
                var letterIndexer = $(this).attr("data-indexer");
                if (letterIndexer == letter){
                    $(this).addClass("item-selected");
                }else{
                    $(this).removeClass("item-selected");
                }
            });
        });
    }
    
    //加载已点菜品；
    function loadFood(){
        var storage = getStorage();
        var tableMenuKey = getTableMenuKey();
        var tableMenuString = storage.getItem(tableMenuKey);
        if (tableMenuString != null){
            foodMenuItemArray = JSON.parse(tableMenuString);
        }
        $("#spanFoodKindQuantity").html(foodMenuItemArray.length);

        showSelectedItems();
        caculateTotalAmount();
    }

    //醒目显示已点过的菜品；
    function showSelectedItems() {         
        $(".itemList").find("li").each(function(){
            var $hfItemCode = $(this).find("input[name=hfItemCode]").eq(0);
            var $txtQuantity = $(this).find("input[name=txtQuantity]").eq(0);

            var itemCode = $hfItemCode.val();                 
            for (var i=0;i<foodMenuItemArray.length;i++){
                var foodMenuItem = foodMenuItemArray[i];
                if (itemCode == foodMenuItem.itemCode){ //如果已存在，则更新数量
                    $(this).find(".item").addClass("item-selected");
                    $txtQuantity.val(foodMenuItem.quantity);
                }
            }
        });
    }

    //点击事件（选菜或取消选菜）
    function itemClick_handler(itemID) {
        var $item = $("#" + itemID)
        var rowNum = $item.attr("id").split("_")[1];
        var $txtQuantity = $item.find("input[name=txtQuantity]").eq(0);
        if ($txtQuantity.val().trim() == "0" || $txtQuantity.val().trim() == "") {
            takeFood("+", rowNum);
        } else {
            takeFood("-", rowNum);
        }
    }
    
    //加/减菜；
    function takeFood(operator, rowNumber) {
        var tableNo = $("#hfTableNo").val();
              
        var $txtQuantity = $("#txtQuantity_" + rowNumber); 
        var itemCode = $("#hfItemCode_" + rowNumber).val();
        var iCurrQuantity = parseFloat($txtQuantity.val());
        if (operator == "+") { //加菜
            iCurrQuantity++;
        } else if (operator == "-") { //减菜
            iCurrQuantity--;
            if (iCurrQuantity <= 0) { iCurrQuantity = 0; }
        }
        $txtQuantity.val(iCurrQuantity.toString()); //数量

        var exists = false;
        for (var i=0;i<foodMenuItemArray.length;i++){
            var foodMenuItem = foodMenuItemArray[i];
            if (itemCode == foodMenuItem.itemCode){ //如果已存在，则更新数量
                exists = true;
                if (iCurrQuantity > 0){ //更新数量
                    foodMenuItem.quantity = iCurrQuantity.toString();
                }else{ //从数组中移除
                    foodMenuItemArray.splice(i,1);
                    break;   
                }
            }
        }
        
        if (!exists){
            addMenuItem_(rowNumber);
        }

        var tableMenuString = JSON.stringify(foodMenuItemArray);        
        var storage = getStorage();
        storage.setItem(getTableMenuKey(), tableMenuString);               

        if (iCurrQuantity >0){                       
            $("#item_" + rowNumber).addClass("item-selected");
        }
        else{
            $("#item_" + rowNumber).removeClass("item-selected");
        }

        caculateTotalAmount();
        
        $("#spanFoodKindQuantity").html(foodMenuItemArray.length.toString());
        event.stopPropagation();  //阻止事件冒泡，避免行被选中；
    }

    //将选定的菜品放入到已点菜品集合中；
    function addMenuItem_(rowNumber){
        var foodMenuItem = new Object();
        foodMenuItem.itemType = $("#hfItemType_" + rowNumber).val();
        foodMenuItem.itemCategory = $("#hfItemCategory_" + rowNumber).val();
        foodMenuItem.itemCode = $("#hfItemCode_" + rowNumber).val();
        foodMenuItem.itemName = $("#hfItemName_" + rowNumber).val();
        foodMenuItem.unit = $("#hfUnit_" + rowNumber).val();
        foodMenuItem.price = $("#hfPrice_" + rowNumber).val();        
        foodMenuItem.quantity = $("#txtQuantity_" + rowNumber).val();
        foodMenuItem.zuofa = "";
        foodMenuItem.donateFlag = "0";
        foodMenuItemArray.push(foodMenuItem);
    }

    //计算总金额；
    function caculateTotalAmount(){
        
        //计算总金额；
        var totalAmount = 0.00;
        for (var i=0;i<foodMenuItemArray.length;i++){
            var foodMenuItem = foodMenuItemArray[i];
            var price = foodMenuItem.price;
            var quantity = foodMenuItem.quantity;
            var amount = parseFloat(price) * parseFloat(quantity);
            totalAmount += amount;
        }
        $("#spanTotalAmount").html(totalAmount.toFixed(2).toString());
    }

    //获取就餐人数
    function getTableInfo() {
        var tableNo = $("#hfTableNo").val();
        var key = "TableInfo_" + tableNo;
        var storage = getStorage();
        var tableInfoString = storage.getItem(key);
        if (tableInfoString != null) {
            var tableInfo = JSON.parse(tableInfoString);
            $("#hfCustomerQuantity").val(tableInfo.customerQuantity);
        }
    }
    function clearTableInfo() {
        var tableNo = $("#hfTableNo").val().trim();
        var key = "TableInfo_" + tableNo;
        var storage = getStorage();
        storage.removeItem(key);
    }

    //查看详情
    function viewDetail(itemCode){
        window.location.href = "food_view.aspx?itemcode=" + itemCode;
        event.stopPropagation();  //阻止事件冒泡，避免行被选中；
    }

    //重点
    function reTakeFood(){
        JTongAlertConfirm("确定要重新点菜吗？", function () {
            getStorage().removeItem(getTableMenuKey());
            window.location.reload();
        });        
    }

    //继续点餐；
    function takeFoodContinue(){
        closeOrderDetailWindow();
    }

    //取消点餐
    function cancel(){
        JTongAlertConfirm("确定要取消点菜吗？", function () {
            getStorage().removeItem(getTableMenuKey());
            clearTableInfo();
            goHome();
        });        
    }

    //查看订单详情；
    function viewOrderDetail() {      
        showTakeFood();
        $('#divOrderDetail').modal({
            containerCss: { "width": "450px", "height": "550px" },
            //opacity: 30,
            closeHTML: '',
            onClose: closeOrderDetailWindow
        });
    }
    function closeOrderDetailWindow() {
        $.modal.close();
    }

    function getTableMenuKey() {
        var tableNo = $("#hfTableNo").val();
        var key = "TableMenu_" + tableNo;
        return key;
    }
    function getStorage() {
        return window.localStorage;
    }    


    //加载已点菜品；
    function showTakeFood() {
        $("#spanFoodKindQuantity2").html(foodMenuItemArray.length.toString());
        formEditListTable_clearRows();
        for (var i = 0; i < foodMenuItemArray.length; i++) {
            var foodMenuItem = foodMenuItemArray[i];

            var itemType = foodMenuItem.itemType;
            var itemCategory = foodMenuItem.itemCategory;
            var itemCode = foodMenuItem.itemCode;
            var itemName = foodMenuItem.itemName;
            var unit = foodMenuItem.unit;
            var price = foodMenuItem.price;
            var quantity = foodMenuItem.quantity;
            var zuofa = foodMenuItem.zuofa;
            var donateFlag = foodMenuItem.donateFlag;

            formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag);
        }
    }

    function save() {

        var tableNo = $("#hfTableNo").val().trim();
        if (tableNo == "") {
            JTongAlert('提示', "“餐台号”不能为空！", 'warning');
            return;
        }

        if (!formEditListTable_checkTableData()) {
            return;
        }

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        //var data = $("form").eq(0).serialize();
        //var data = $("#orderDetail").eq(0).serialize(); ?取不到值

        var itemTypes = getValues_("hfItemType2");
        var itemCategories = getValues_("hfItemCategory2");
        var itemNames = getValues_("hfItemName2");
        var itemCodes = getValues_("hfItemCode2");
        var itemUnits = getValues_("hfUnit2");
        var itemPrices = getValues_("hfPrice2");
        var itemQuantities = getValues_("txtQuantity2");
        var itemAmounts = getValues_("hfAmount2");
        var itemZuofas = getValues_("txtZuofa2");
        var itemDonates = getValues_("hfDonate2");

        var data = { 
            "hfItemType2": itemTypes,
            "hfItemCategory2": itemCategories,
            "hfItemName2": itemNames,
            "hfItemCode2": itemCodes,
            "hfUnit2": itemUnits,
            "hfPrice2": itemPrices,
            "txtQuantity2": itemQuantities,
            "hfAmount2": itemAmounts,
            "txtZuofa2": itemZuofas,
            "hfDonate2": itemDonates,
            "hfCustomerQuantity": $("input[name=hfCustomerQuantity]").val(),
            "hfTotalAmount2": $("input[name=hfTotalAmount2]").val(),
            "hfTableNo": $("#hfTableNo").val()
        };
        var successFN = function (data, textStatus) {
            var bizNo = "";
            if (data.substring(0, 2) == "ok") {
                bizNo = data.split("|")[1];
                showActResult("开单成功！", true, doAfterAdd, bizNo);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd, bizNo);
            }
            else {
                showActResult("开单失败：" + data, false, doAfterAdd, bizNo);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function getValues_(elementName){
        var values = "";
        $("input[name="+ elementName +"]").each(function(){
            values += "," + $(this).val();
        });
        if (values.length > 0){
            values = values.substr(1, values.length);
        }
        return values;
    }

    function doAfterAdd(actResult, bizNo) {
        if (actResult) {
            getStorage().removeItem(getTableMenuKey());
            clearTableInfo();
            window.location.href = "order_edit_view.aspx?orderno=" + bizNo;
        }
    }

    //显示操作结果；
    function showActResult(sMsg, actResult, callback, bizNo) {
        var icon = "info";
        if (!actResult) {
            icon = "error";
        }

        JTongAlert('操作结果', sMsg, icon, function () {
            if (callback != null && callback != undefined) {
                callback(actResult, bizNo);
            }
        });
    }

</script>
<style type="text/css">  

    
</style>
</head>
<body>
<form id="Form1" method="post" runat="server">
<div id="pageWrapper">  
      
    <div id="headerBar">
        <h1>点菜(<% = base.tableNo %> 号台)</h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:goHome();" class="icon home"></a>
        </div>  
    </div> 
    
    <div id="toolBar">   
        <a runat="server" id="categoryName" class="jtongui-toolbarbutton categoryName"></a>    
        <a href="javascript:reTakeFood()" class="jtongui-toolbarbutton" icon="icon-redo">清空重点</a>    
        <a href="javascript:cancel()" class="jtongui-toolbarbutton" icon="icon-undo">放弃</a>                     
    </div><!--toolBar.END-->  
    
    <div id="dataBar" style="margin-top:0px;">
    <div id="itemContainer">
    <div id="itemContainerWrapper">   

    <!--MainList.Start-->    
    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <ul class="itemList">
    </HeaderTemplate>
    <ItemTemplate>
    <li>
        <div class="item" id="item_<%# Container.ItemIndex%>" data-itemkey="<%# Eval("Item_Code")%>">
            <div class="itemPic">                
                <%--<a href="food_view.aspx?itemcode=<%# Eval("Item_Code")%>"><%# ShowItemImage(Eval("Image").ToString().Trim(), "240", "160")%></a>--%>
                <a onclick="itemClick_handler('item_<%# Container.ItemIndex%>')"><%# ShowItemImage(Eval("Image").ToString().Trim(), "240", "160")%></a>
            </div>
            <div class="itemDesc" onclick="itemClick_handler('item_<%# Container.ItemIndex%>')" >
                <div style="padding:3px;float:left;">
                    <h1><%# Eval("Item_Name")%>/<%# Eval("Price")%></h1>
                    <a name="<%# ShowLetterIndex(Eval("Input_Code").ToString())%>"></a> 
                  <%--  <p><%# ShowStars(Convert.ToInt32(Eval("Stars"))) %></p>--%>                                        
                </div>
                <div style="padding:3px;float:right;">
                    <input type="button" value="+" onclick="takeFood('+', <%# Container.ItemIndex%>);" class="oprBtn" />
                    <input type="button" value="-" onclick="takeFood('-', <%# Container.ItemIndex%>);" class="oprBtn" />
                </div>                
            </div>
            <div class="itemQuantity">
                <input type="text" class="textbox" value="0" name="txtQuantity" id="txtQuantity_<%# Container.ItemIndex%>"  />                
            </div>

            <input type="hidden" name="hfItemType" id="hfItemType_<%# Container.ItemIndex%>" value="<%# Eval("Item_Type")%>" />
            <input type="hidden" name="hfItemCategory" id="hfItemCategory_<%# Container.ItemIndex%>" value="<%# Eval("Category_Code")%>" />
            <input type="hidden" name="hfItemCode" id="hfItemCode_<%# Container.ItemIndex%>" value="<%# Eval("Item_Code")%>"/>
            <input type="hidden" name="hfItemName" id="hfItemName_<%# Container.ItemIndex%>" value="<%# Eval("Item_Name")%>" />
            <input type="hidden" name="hfUnit" id="hfUnit_<%# Container.ItemIndex%>" value="<%# Eval("Unit")%>" />
            <input type="hidden" name="hfPrice" id="hfPrice_<%# Container.ItemIndex%>" value="<%# Eval("Price")%>" />                    
        </div>      
    </li>   
    </ItemTemplate>
    <FooterTemplate>
    </ul>
    </div><!--bodyContainer.END-->        

    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->
     
    <!--MainList.End-->  

    </div><!--itemContainer.END-->           
    </div><!--itemContainerWrapper.END-->
    
    <div id="sideBar">
        <div id="categoriesPanel">
            <asp:Repeater ID="rpFoodCategories" Runat="server" EnableViewState="False"  >    
            <HeaderTemplate>
                <ul class="categories">
            </HeaderTemplate>
            <ItemTemplate>
                <li onclick="window.location.href='?tableno=<% = base.tableNo %>&category=<%# Eval("Category_Code")%>&itemtype=<%# Eval("Item_Type")%>'"><%# Eval("Category_Name")%></li>                
            </ItemTemplate>            
            <FooterTemplate>
                </ul>
            </FooterTemplate>
            </asp:Repeater>    
        </div>
    </div><!--sideBar.END-->

    </div><!--dataBar.END-->
    
    <div id="bottomToolBar" style="margin-top:0px;">
        <div style="padding-top:0px;text-align:right;padding-right:5px;position:relative;border:0px solid red;">
            <div style="position:absolute;left:5px;top:3px;">已点菜品(<span id="spanFoodKindQuantity" class="foodKindQuantity">0</span>),金额(<span id="spanTotalAmount" class="amount">0.00</span>)</div>
            <%--<input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="showMakedFoodMenu('<% = base.tableNo %>');" value="选好了" />--%>
            <input type="button" id="btnViewOrderDetails" class="btn" style="width:80px" onclick="viewOrderDetail()" value="点单明细" />
        </div>
    </div>

    <!--#include virtual="../footer.aspx"-->

    <asp:HiddenField ID="hfTableNo" runat="server" />
    <asp:HiddenField ID="hfItemCategory" runat="server" />
    <asp:HiddenField ID="hfItemType" runat="server" />
    <input type="hidden" name="hfCustomerQuantity" id="hfCustomerQuantity" />
    
</div>

<div id="divOrderDetail" style="display:none;">
    <div class="box-title-bar">
        <div class="title-container"><h1>已点菜品</h1></div>
        <div class="close-container"><a href="#" class="simplemodal-close">×</a></div>
    </div>
    <div id="orderDetail" style="height:515px;position:relative;border:0px solid red;padding-left:10px;padding-right:10px;">        
        <table cellspacing="0" class="formEditListTable" style="margin-top:0px;">
        <thead>
        <tr>
            <td style="width:200px;text-align:center;">菜名</td>        	         	  	       	    
            <td style="width:40px;text-align:center;">数量</td>
            <td style="width:40px;text-align:center;">口味</td>
            <td style="width:30px;text-align:center;">赠</td>
            <td style="text-align:left;">操作</td>
        </tr>        
        </thead>
        </table>
        <table id="tbNoRecord" cellspacing="0" cellpadding="3" style="margin-top:-1px;width:100%;">
        <tr>
        <td style="text-align:center;height:269px;font-size:14px;">
            暂无数据
        </td>
        </tr>
        </table>
        <div id="orderItems" style="height:420px;overflow:auto;border:0px solid red;">
        <table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:-1px;">      
        </table>
        </div>

        <div style="position:absolute;bottom:30px;width:100%;text-align:center;height:30px;line-height:30px;border:0px solid red;">
            <input type="hidden" name="hfTotalAmount2" id="hfTotalAmount2" />            
            共 <span id="spanFoodKindQuantity2" class="foodKindQuantity"></span> 道菜，
            总金额：<span id="spanTotalAmount2" class="amount">0.00</span>
        </div>

        <div style="position:absolute;bottom:0px;width:100%;text-align:center;height:30px;line-height:30px;border:0px solid red;">
            <input type="button" id="btnSubmit" class="btn" style="min-width:100px" onclick="save()" value="提交菜单" />
            <input type="button" id="btnContinue" class="btn" style="min-width:100px" onclick="takeFoodContinue()" value="继续点菜" />
            <input type="button" id="btnCancel" class="btn" style="min-width:100px" onclick="cancel()" value="取消点菜" />
        </div>

    </div>             
</div>

<div id="indexPanel">
        <ul id="letterIndexer" class="letterIndexer">        
            <li>A</li>
            <li>B</li>
            <li>C</li>
            <li>D</li>
            <li>E</li>
            <li>F</li>
            <li>G</li>
            <li>H</li>
           <%-- <li>I</li>--%>
            <li>J</li>
            <li>K</li>
            <li>L</li>
            <li>M</li>
            <li>N</li>
            <li>O</li>
            <li>P</li>
            <li>Q</li>
           <%-- <li>R</li>--%>
            <li>S</li>
            <li>T</li>
           <%-- <li>U</li>
            <li>V</li>--%>
            <li>W</li>
            <li>X</li>
            <li>Y</li>
            <li>Z</li>         
        </ul>
    </div>

</form>

</body>
</html> 