﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="login.aspx.cs" Inherits="VA.Modules.JDingCYTPad.login" %>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="include/viewport.aspx"-->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><% = base.webSiteConfig.WebSiteName %></title>
<link rel="stylesheet" type="text/css" href="app_themes/<% = webSiteConfig.ThemeName %>/css/main.css" />
<link rel="stylesheet" type="text/css" href="app_themes/<% = webSiteConfig.ThemeName %>/css/pages/login.css" />
<link rel="shortcut icon" type="image/x-icon" href="/logo.ico" />
<script type="text/javascript" src="/scripts/jquery/jquery-1.9.1.min.js"></script>
<script type="text/javascript">

    function setLayout() {
        var windowHeight = $(window).outerHeight();
        var mainHeight = $("#main").outerHeight();
        var mainTop = (windowHeight - mainHeight) / 2 - 20;
        $("#main").css("top", mainTop);
        $("#wrapper").height(windowHeight);
    }

    function cancel() {
        window.location.href = "default.aspx";
    }

    $(function () {

        $("#txtUserID").focus();

        $("#txtUserID").keydown(function (e) {
            if (e.keyCode == 13) {
                $("#txtPassword").focus();
            }
        });
        $("#txtPassword").keydown(function (e) {
            if (e.keyCode == 13) {
                $("#btnSubmit").click();
                return false;
            }
        });

        setLayout();

        //绑定窗体resize事件；
        $(window).resize(function () {
            setLayout();
        });
    });

</script>      
</head>
<body>   
<form id="form1" runat="server">
<div id="wrapper">
<div id="main">    
    <div id="title"></div>
    <div id="loginbox">

    <p style="left:15px;top:5px;border:solid 0px red;position:absolute;"><span style="font-size:14px;">点餐登录</span></p>    
    <p style="left:15px;top:53px;border:solid 0px red;position:absolute;">
         
        <span style="display:block;margin-bottom:3px;">账号：</span>
        <asp:TextBox ID="txtUserID" runat="server" 
             CssClass="input"
             Width="240px" />
        <asp:RequiredFieldValidator id="rfvUserID" runat="server" 
	         ErrorMessage="登录名错误." 
	         ControlToValidate="txtUserID" 
	         Display="None" />
	    <asp:RegularExpressionValidator id="revUserID" runat="server"
		     EnableViewState="False" 
		     ErrorMessage="帐号错误."
		     Display="None"
		     ControlToValidate="txtUserID" 
		     ValidationExpression="[a-zA-Z0-9_]{1,16}" />
    </p>

    <p style="left:15px;top:125px;border:solid 0px red;position:absolute;">
        <span style="display:block;margin-bottom:3px;">密码：</span>
        <asp:TextBox ID="txtPassword" runat="server" 
             CssClass="input"
             TextMode="Password"
             Width="240px" />
        <asp:RequiredFieldValidator id="rfvPassword" runat="server" 
	         ErrorMessage="密码错误." 
	         ControlToValidate="txtPassword" 	         
	         Display="None" />
    </p>

    <p style="left:15px;top:200px;border:solid 0px red;position:absolute;">
        <asp:Button ID="btnSubmit" runat="server"
             Text=" 登录 "     
             CssClass="btn"        
             Width="120px"
             height="40px"
             OnClick="btnSubmit_Click"
             />

        <input type="button" class="btn" style="width:115px;height:40px;" value="取消" onclick="cancel()" />
        
        <span style="display:block;margin-top:5px;">
        <asp:Label ID="lblLoginInfo" runat="server" ForeColor="Red"></asp:Label>
        </span>
        <asp:ValidationSummary id="ValidationSummary1"  runat="server" 
	         ShowMessageBox="True" 
	         ShowSummary="False" />   
    </p>

    </div>

    <div id="copyright">
        <p>(C)<% = DateTime.Now.Year.ToString() %> <a href="<% = VA.Modules.JDingCYT.Core.SystemInfo.SupportInfo.WebSite %>" target="_blank"><span style="color:#ffffff"><% = VA.Modules.JDingCYT.Core.SystemInfo.SupportInfo.Company %></span></a>.</p>
    </div>

</div>
</div>
</form>   
</body>  
</html>