﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="workplat.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.consume.workplat" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title>点餐台</title>    
<!--#include virtual="../include/css/editlist.aspx"-->
<link rel="stylesheet" type="text/css" href="../app_themes/icons/icon.css" />
<link rel="stylesheet" type="text/css" href="../app_themes/<% = webSiteConfig.ThemeName %>/css/pages/workplat.css?ver=1" />
    
<script type="text/javascript" src="/scripts/jquery/jquery-1.9.1.js"></script>        
<script type="text/javascript" src="../scripts/biz/common.js"></script>        
<script type="text/javascript" src="/uicontrols/jtongui/plugins/jtong.alert.js"></script>    
<script type="text/javascript" src="/uicontrols/jtongui/plugins/jtong.toolbarbutton.js"></script>
<script type="text/javascript" src="../scripts/page/workplat.js"></script>    

<script type="text/javascript">

    var currTableNo = "";
    var currOrderNo = "";

    function createOrder() {
        var tableNo = currTableNo;
        window.location.href = "order_create.aspx?tableno=" + tableNo
    }

    function changeOrder() {
        var orderNo = currOrderNo;
        var tableNo = currTableNo;
        window.location.href = "order_manage_nav.aspx?orderno=" + orderNo
    }

    //绑定事件；
    function afterDataListLoaded() {            
        $("#tableList").click(function (event) {
            var target = event.target;
            var $target = $(target);
            if (target.tagName.toUpperCase() == "LI") {
                var tableNo = target.id.split('_')[1];
                var orderNo = $target.find(":hidden[name=hfOrderNo]").eq(0).val();
                var masterTableNo = $target.find(":hidden[name=hfMasterTableNo]").eq(0).val();
  
                currTableNo = tableNo;
                currOrderNo = orderNo;

                if (masterTableNo != "") {
                    currTableNo = masterTableNo;
                }

                if (orderNo != "") {
                    changeOrder();
                } else {
                    createOrder();
                }
            }
        });
    }

    function queryByZone(zoneCode) {
        window.location.href = pageName + "?zonecode=" + zoneCode;
    }

    function viewAppointmentInfo(appointmentID, tipObj) {
        return;
        console.log(tipObj.tagName);
        $.get(pageName + "?act=getappointmentinfo", {
            appointmentID: appointmentID
        }, function (data, textStatus) {
            if (data != "") {
                var appointmentInfo = JSON.parse(data);
                $("#appointmentTip").html("<span>姓名：" + appointmentInfo.customerName + "</span><br><span>手机：" + appointmentInfo.mobileNo + "</span>");
                //$("#appointmentTip").html("<span>顾客姓名：" + appointmentInfo.customerName + "</span><br><span>顾客手机：" + appointmentInfo.mobileNo + "</span><br><span>预订时间：" + appointmentInfo.appointmentDate + "</span><span>订台日期：" + appointmentInfo.orderDate + "</span>");

                var $tip = $("#appointmentTip");
                var offset = $(tipObj).offset();
                var top = 0;
                var left = 0;

                top = offset.top + 10;
                left = offset.left + 10;

                $tip.show();
                $tip.offset({ top: top, left: left });
            }
        }, "html");
    }

    function logout() {
        if (confirm("确定要退出吗？")) {
            window.location.href = "../logout.aspx";
        }
    }

    $(function () {
        initListPage();
        afterDataListLoaded();
    });
</script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper">    

    <div id="headerBar">      
        <h1>点餐台</h1>
        <div class="leftToolBar">
            <a href="javascript:window.location.reload();" class="icon refresh"></a>
        </div>                
        <div class="rightToolBar">
            <a href="javascript:logout();" class="icon logout"></a>
        </div>          
    </div> 
    
    <div id="toolBar">                                 
        <a href="#" class="jtongui-toolbarbutton" menu="menu_tableZones">餐区</a> 
        <a href="#" class="jtongui-toolbarbutton" menu="menu_tableBizStatus">餐台状态</a> 
        <a href="#" class="jtongui-toolbarbutton" menu="menu_tableTypes">餐台类型</a> 
       <%-- <a href="#" class="jtongui-toolbarbutton" menu="menu_range">范围</a> --%>
        <div id="menu_tableZones" class="jtongui-toolbarbutton-menu">
            <asp:Repeater ID="rpTableZones" Runat="server" EnableViewState="False"  >    
            <ItemTemplate>
            <a href="?zonecode=<%# Eval("Zone_Code")%>"><%# Eval("Zone_Name")%></a>
            </ItemTemplate>            
            </asp:Repeater>    
        </div>      
        <div id="menu_tableBizStatus" class="jtongui-toolbarbutton-menu">
            <asp:Repeater ID="rpTableBizStatus" Runat="server" EnableViewState="False"  >    
            <ItemTemplate>
            <a href="?tablebizstatus=<%# Eval("Status_Code")%>"><%# Eval("Status_Name")%></a>
            </ItemTemplate>            
            </asp:Repeater>    
        </div>      
        <div id="menu_tableTypes" class="jtongui-toolbarbutton-menu">
            <asp:Repeater ID="rpTableTypes" Runat="server" EnableViewState="False"  >    
            <ItemTemplate>
            <a href="?tabletype=<%# Eval("Type_Code")%>"><%# Eval("Type_Name")%></a>
            </ItemTemplate>            
            </asp:Repeater>    
        </div>      
        <div id="menu_range" class="jtongui-toolbarbutton-menu">
            <a href="?range=1">我的顾客</a>
            <a href="?">全部顾客</a>
        </div>      
    </div><!--toolBar.END-->                     
        
    <% if (base.NewOrderChanges != null && base.NewOrderChanges.Rows.Count >0) {%>
    <div id="orderChangesNoteBar">
        加菜申请：(
        <%
           System.Collections.Generic.List<string> tableNoList = new System.Collections.Generic.List<string>();
           foreach (DataRow row in base.NewOrderChanges.Rows)
           {
               string tableNo = row["Table_No"].ToString();
               if (!tableNoList.Contains(tableNo))
               {
                   tableNoList.Add(tableNo);
               }
           }
           string s = String.Join("/", tableNoList.ToArray());
           Response.Write(s);
        %>
        )
    </div>
    <% } %>    
    
    <div id="dataBar" style="margin-top:0px;">        

    <!--MainList.Start-->    
    <div id="dataBody">               
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False" >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>  
    <ul id="tableList">
    </HeaderTemplate>
    <ItemTemplate>   
        <li id="tableNo_<%# Eval("Table_No")%>" class="<%# SetTableUIState(Eval("Table_Biz_Status").ToString())%>">
            <%# base.ShowAppointmentFlag(Eval("Table_No").ToString()) %>            
            <span class="label"><%# Eval("Table_No")%>号台</span>            
            <span class="masterTableNo"><%# Eval("Master_Table_No")%></span>            
            <%--<span class="seatingQuantity"><%# Eval("Seating_Quantity")%></span>            --%>
            <span class="seatingQuantity"><%# Eval("Seating_Quantity")%>座 <%# VA.Modules.JDingCYT.Core.Enums.TableTypeConverter.Convert_Value_ToText(Eval("Table_Type").ToString()) %></span>
            <input type="hidden" value="<%# Eval("Order_No")%>" name="hfOrderNo" />
            <input type="hidden" value="<%# Eval("Master_Table_No")%>" name="hfMasterTableNo" />
            <input type="hidden" value="<%# Eval("Table_Biz_Status")%>" name="hfTableBizStatus" />
        </li> 
    </ItemTemplate>
    <FooterTemplate>
    </ul><!--tableList.END-->
    </div><!--bodyContainer.END-->        

    </FooterTemplate>
    </asp:Repeater>                   
    </div><!--dataBody.END-->    
    <!--MainList.End-->  
    
    </div><!--dataBar.END-->

    <div class="bar" style="height:20px;padding:5px;background-color:#EDF6FA;" runat="server" visible="false">
        <p>
            餐台总数：<% = base.TotalTableCount.ToString() %>，
            上座台数：<% = base.InusingTableCount.ToString() %>，
            空闲台数：<% = (base.TotalTableCount - base.InusingTableCount).ToString() %>，
            上座率：<% = base.UsingPercentage %>
        </p>                   
    </div>

    <!--#include virtual="../footer.aspx"-->

</div>

<div id="appointmentTip"></div>

</form>
</body>
</html> 