﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="order_manage_nav.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.mainbiz.order_manage_nav" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/edit.aspx"-->
<!--#include virtual="../include/js/edit.aspx"--> 
<script type="text/javascript">        
    onPageInited = function () {
        loadFood();
    }

    function orderView() {
        var orderNo = $("#hfKey").val();
        window.location.href = "order_edit_view.aspx?orderno=" + orderNo;
    }

    function changeTable() {
        var orderNo = $("#hfKey").val();
        window.location.href = "order_changetable.aspx?orderno=" + orderNo;
    }

    function cxBill() {
        JTongAlertConfirm("确定要撤单吗？", function () {
            var requestType = "POST";
            var url = pageName + "?act=cxbill";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();
            var successFN = function (data, textStatus) {
                var bizNo = "";
                if (data.substring(0, 2) == "ok") {
                    showActResult("撤单成功！", true, doAfterAdd, bizNo);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, doAfterAdd, bizNo);
                }
                else {
                    showActResult("撤单失败：" + data, false, doAfterAdd, bizNo);
                }
            };

            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        });
    }
    //显示操作结果；
    function showActResult(sMsg, actResult, callback, bizNo) {
        var icon = "info";
        if (!actResult) {
            icon = "error";
        }

        JTongAlert('操作结果', sMsg, icon, function () {
            if (callback != null && callback != undefined) {
                callback(actResult, bizNo);
            }
        });
    }

    function doAfterAdd(actResult, bizNo) {
        if (actResult) {
            window.location.href = "workplat.aspx";
        }
    }

</script>
</head>
<body>

<form id="Form1" method="post" runat="server">
<div id="pageWrapper">    
    <div id="headerBar">
        <h1><% = base.orderInfo.Table_No %> 号台</h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:goHome();" class="icon home"></a>
        </div>  
    </div> 

    <div id="dataBar">
    
        <div style="padding:20px;">

            餐 台 号：<% = base.orderInfo.Table_No %>

            <br />
            <br />

            排 序 号：<% = base.orderInfo.Order_SequenceNo %>

            <br />
            <br />

            就餐人数：<% = base.orderInfo.Customer_Quantity %>

            <br />
            <br />

            开单时间：<% = base.orderInfo.Order_Date.ToString("yyyy-MM-dd HH点mm分", System.Globalization.CultureInfo.InvariantCulture) %>

            <br />
            <br />

            开单类型：<% = VA.Modules.JDingCYT.Core.Enums.OrderConverter.OrderManTypeConverter.Convert_Value_ToText(base.orderInfo.OrderMan_Type) %>

            <br />
            <br />

            开 单 人：<% = base.orderInfo.OrderMan_Name %>

            <br />
            <br />

            打印次数：<% = base.orderInfo.Print_Count.ToString() %>

            <br />
            <br />

            菜单金额：<% = base.orderInfo.Order_Costs.ToString("F2") %>

            <br />
            <br />

            就餐时长：<% = VA.Modules.JDingCYT.Core.Utils.FormTimespanString(base.orderInfo.Order_Date, DateTime.Now) %>
            
            <br />
            <br />
            菜单状态：<% = VA.Modules.JDingCYT.Core.Enums.OrderConverter.OrderBizStatusConverter.Convert_Value_ToText(base.orderInfo.Order_Biz_Status, true) %>

            <br />
            <br />
        
        </div>                  

    </div>    
    
    <div id="bottomToolBar">
            <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="orderView()" value="菜单" />            
            <input type="button" id="btnChangeTable" class="btn" style="width:80px" onclick="changeTable()" value="转台" />
          <%--  <input type="button" id="btnCx" class="btn" style="width:80px" onclick="cxBill()" value="撤单" />--%>
        </div>        

    <!--#include virtual="../footer.aspx"-->

    <asp:HiddenField ID="hfKey" runat="server" />
    
</div>

</form>
</body>
</html> 