﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="order_edit_removefood.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.mainbiz.order_edit_removefood" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/edit.aspx"-->
<link href="/uicontrols/jtongui_mobile/themes/default/toolbarbutton.css" type="text/css" rel="Stylesheet" />
<link href="/uicontrols/jtongui_mobile/themes/icon.css" type="text/css" rel="Stylesheet" />
<link href="../app_themes/default/css/foodtake.css" type="text/css" rel="stylesheet" >
<!--#include virtual="../include/js/edit.aspx"--> 
<script type="text/javascript" src="/uicontrols/jtongui_mobile/plugins/jtong.toolbarbutton.js"></script>
<script type="text/javascript">    

    onPageInited = function () {
        JTongToolBarButton_init();
    }    

    function goBack() {
        orderView();
    }

    function cancel() {
        goBack();
    }    

    function save() {

        if (!formEditListTable_checkTableData()) {
            return;
        }

        $("#btnSubmit").attr("disabled", "disabled");

        var requestType = "POST";
        var url = pageName + "?act=update";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("提交成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("提交失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            orderView();
        }
    }

    function orderView() {
        var orderNo = $("#hfKey").val();
        window.location.href = "order_edit_view.aspx?orderno=" + orderNo;
    }

    function resetPage() {

        $("#txtTableNo").val("");
        $("#hfTableNo").val("");
        $("#txtCustomerQuantity").val("1");
        $("#txtRemark").val("");

        formEditListTable_clearRows();
        clearInputValidatorError();
    }

</script>

<script type="text/javascript">

    function addRowByOrder(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag, RID) {
        formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag, RID);
    }

    var formEditListTable_RowCounter = 0;
    function formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag, RID) {
            
        formEditListTable_RowCounter++;

        var $srcTable = $("#srcTable");
        var srcTableID = $srcTable.attr("id");

        //如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
        if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
            return;
        }

        var rowHtml = '';
        var $row = null;
        var rowCnt = $srcTable[0].rows.length;
        var rowID = formEditListTable_RowCounter;

        itemName = itemName.replace(/'/g, "‘");
        unit = unit.replace(/'/g, "‘");
                        
        var amount = (price * quantity).toFixed(2).toString(); //优惠前金额
            
        rowHtml += '<tr id="tr_' + rowID + '">';
       
        rowHtml += '<td style="text-align:left;padding-left:5px;">';
        rowHtml += '<span>' + itemName + '</span>';
        rowHtml += '<span>' + price + '</span>';
        rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
        rowHtml += '<input type="hidden" name="hfItemCategory" value="' + itemCategory + '" />';
        rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
        rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" id="hfItemCode_'+ rowID +'" />';
        rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
        rowHtml += '<input type="hidden" name="hfPrice" value="' + price + '" id="hfPrice_'+ rowID +'" />';
        rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
        rowHtml += '<input type="hidden" name="hfRowState" value="1" id="hfRowState_' + rowID + '" />';
        rowHtml += '<input type="hidden" name="hfRID" value="'+ RID +'" id="hfRID_' + rowID + '" />';
        rowHtml += '</td>';
    
        rowHtml += '<td><input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" class="textbox" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" /></td>';

        rowHtml += '<td style="text-align:center;display:none;">';
        if (donateFlag == "1") {
            rowHtml += '<input type="checkbox" name="ckbDonate" id="ckbDonate_' + rowID + '" checked="checked" onclick="setDonate(' + rowID + ')" />';
        } else {
            rowHtml += '<input type="checkbox" name="ckbDonate" id="ckbDonate_' + rowID + '" onclick="setDonate(' + rowID + ')" />';
        }            
        rowHtml += '<input type="hidden" name="hfDonate" value="'+ donateFlag +'" id="hfDonate_' + rowID + '" />';
        rowHtml += '</td>';

        rowHtml += '<td style="text-align:center;"><a href="javascript:formEditListTable_removeRow(' + rowID + ')">删除</a></td>';

        rowHtml += '<td style="text-align:left;"></td>';        

        rowHtml += '</tr>';

        $row = $(rowHtml);
        $srcTable.append($row);

        formEditListTable_setRowNo();
        formEditListTable_setTotalAmount();
        formEditListTable_hideTbNoRecord();
    }

    function formEditListTable_removeRow(rowID) {

        var $srcTable = $("#srcTable");

        //老处理方案：直接删除行；
        //$srcTable.find("#tr_" + rowID).remove();

        //新处理方案：如果是原始行，则只更改行状态，但不删除行;如果是新增行，则直接删除行；                        
        var $tr = $srcTable.find("#tr_" + rowID);
        if (!$tr.hasClass("del")) { //删除
            $srcTable.find("#hfRowState_" + rowID).val("0");
            $tr.addClass("del");
        } else { //取消删除；
            $srcTable.find("#hfRowState_" + rowID).val("1");
            $tr.removeClass("del");
        }

        var dataRowCount = $srcTable.find("input[name=hfAmount]").length;
        if (dataRowCount == 0) {
            dataRowCount = $srcTable.find("input[name=hfItemCode]").length;
        }

        if (dataRowCount == 0) { //如果已无数据行，则重置计数器；
            formEditListTable_RowCounter = 0;
            formEditListTable_showTbNoRecord();
        }

        formEditListTable_setRowNo();
        formEditListTable_setTotalAmount();
    }

    function formEditListTable_setTotalAmount() {
        var $srcTable = $("#srcTable");
        $srcTable.find("#trTotal").remove();

        var totalRowHtml = '';
        var totalAmount = 0.00;
        //var $hfAmountList = $srcTable.find("input[name=hfAmount]");
        var dataRows = $srcTable.find("tr[id]");
        var foodKindQuantity = 0;

        dataRows.each(function () {
            var $hfAmount = $(this).find("input[name=hfAmount]").eq(0);
            var $hfCkbDonate = $(this).find("input[name=ckbDonate]").eq(0);
            var $hfRowState = $(this).find("input[name=hfRowState]").eq(0);

            if (!$hfCkbDonate[0].checked && $hfRowState.val() == "1") { //如果是不是赠送并且行状态为有效，则计入总金额
                totalAmount += parseFloat($hfAmount.val());
            }

            if ($hfRowState.val() == "1") {
                foodKindQuantity++;
            }
        });

        //$hfAmountList.each(function () {
        //    totalAmount += parseFloat($(this).val());
        //});

        //if ($hfAmountList.length > 0) {  //如果有数据行，则添加合计行
        if (dataRows.length > 0) {  //如果有数据行，则添加合计行     
            $("#hfTotalAmount").val(totalAmount.toFixed(2).toString());
            $("#spanTotalAmount").html(totalAmount.toFixed(2).toString());
        } else {
            $("#hfTotalAmount").val("0.00");
            $("#spanTotalAmount").html("0.00");
        }

        $("#spanFoodKindQuantity").html(foodKindQuantity);
    }

    function formEditListTable_caculateAmount(rowID) {
        var $txtQuantity = $("#txtQuantity_" + rowID);
        var $txtPrice = $("#hfPrice_" + rowID);
        var $spanDiscount = "";
        var sQuantity = $txtQuantity.val();
        var sPrice = $txtPrice.val();
        var amount = 0.00; //优惠前

        if (sQuantity == "") {
            sQuantity = "0";
        }
        if (sPrice == "") {
            sPrice = "0";
        }
 
        ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
        //clearNoNum($txtQuantity[0]);
        //clearNoNum($txtPrice[0]);

        if (isNaN(sQuantity)) {
            alert("数量为无效数字！");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (isNaN(sPrice)) {
            alert("单价为无效数字.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }          
        if (parseFloat(sQuantity) > 100000 || parseFloat(sQuantity) <0) {  //限制数量不能超过100000
            alert("数量不能小于0或超过100000.");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (parseFloat(sPrice) > 100000 || parseFloat(sPrice) < 0) {  //单价不能超过100000
            alert("单价不能小于0或超过100000.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }

        if ($txtQuantity.hasClass("error")) {
            $txtQuantity.removeClass("error");
        }
        if ($txtPrice.hasClass("error")) {
            $txtPrice.removeClass("error");
        }

        amount = parseFloat(sQuantity) * parseFloat(sPrice);
            
        $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());
        $("#spanAmount_" + rowID).html(amount.toFixed(2).toString());

        formEditListTable_setTotalAmount();
    }

    function formEditListTable_checkTableData() {

        var result = true;

        var dataRowCount = 0;
        var $srcTable = $("#srcTable");

        $srcTable.find("input[name=txtQuantity]").each(function () {
            dataRowCount++;
            var sQuantity = $(this).val();
            if ($.trim(sQuantity) == "" || $.trim(sQuantity) == "0") {
                alert("数量不能为空或0！");
                $(this).focus();
                $(this).addClass("error");
                result = false;
                return;
            }
        });
        $srcTable.find("input[name=txtPrice]").each(function () {
            var sPrice = $(this).val();
            if ($.trim(sPrice) == "") {
                alert("单价不能为空！");
                $(this).focus();
                $(this).addClass("error");
                result = false;
                return;
            }
        });

        if (dataRowCount == 0) {
            alert("消费清单不能为空！");
            result = false;
        }

        return result;
    }        

    function clearItems() {
        formEditListTable_clearRows();
    }

    </script>

<style type="text/css">
.textbox {
    width:30px;
    text-align:center;
}
.bottomBar {
    margin-top:-1px;
    padding:5px;
    text-align:center;
}
</style>

</head>
<body>

<form id="Form1" method="post" runat="server">

<div id="pageWrapper">    

    <div id="headerBar">
        <h1>减菜(<% = base.orderInfo.Table_No %> 号台)</h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:goHome();" class="icon home"></a>
        </div>  
    </div> 

    <div id="toolBar">   
        <a href="javascript:cancel()" class="jtongui-toolbarbutton" icon="icon-undo">取消</a>
    </div><!--toolBar.END-->  

    <div id="dataBar">

    <table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:0px;">
    <thead>
    <tr>
        <td style="width:170px;text-align:center;">菜名</td>        	         	  	       	    
        <td style="width:40px;text-align:center;">数量</td>
        <td style="width:25px;text-align:center;display:none;">赠</td>
        <td style="width:40px;text-align:center;">操作</td>
        <td style="text-align:left;"></td>
    </tr>        
    </thead>
    </table>
   
    </div><!--dataBar.END-->

    <div class="bar bottomBar">
        <input type="hidden" name="hfTotalAmount" id="hfTotalAmount" />
        共 <span id="spanFoodKindQuantity"></span> 道菜，
        总金额：<span id="spanTotalAmount">0.00</span>
    </div>

    <div id="bottomToolBar">
            <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="save()" value="提交" />
    </div>
    
    <!--#include virtual="../footer.aspx"-->

    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfDataVersionNum" runat="server" />
    <asp:HiddenField ID="hfTableNo" runat="server" />
    
</div>

<% if (base.orderInfo != null){ %>
<%
    
    Response.Write("<script type=\"text/javascript\">");       
    Response.Write("var itemList = [");       
       
    var i = 0;       
    foreach (VA.Modules.JDingCYT.Core.Model.MainBiz.OrderItemInfo item in base.orderInfo.OrderItems)
    {
        string RID = item.RID.ToString();
        string itemType = item.Item_Type;
        string itemCategory = item.Item_Category;
        string itemCode = item.Item_Code;
        string itemName = item.Item_Name;
        string unit = item.Unit;
        string price = item.Price.ToString("F2");        
        string quantity = item.Quantity.ToString();
        string zuofa = item.Zuofa.Replace(",","，").Replace("\"","“").Replace("\'","‘");
        string donateFlag = item.Donate_Flag;
        string bizStatus = item.Biz_Status;

        Response.Write("{");
        Response.Write("\"RID\":\""+ RID +"\",\"itemType\":\"" + itemType + "\",\"itemCategory\":\"" + itemCategory + "\",\"itemName\":\"" + itemName + "\",\"itemCode\":\"" + itemCode + "\",\"unit\":\"" + unit + "\",\"price\":\"" + price + "\",\"quantity\":\"" + quantity + "\",\"zuofa\":\"" + zuofa + "\",\"donateFlag\":\"" + donateFlag + "\",\"bizStatus\":\"" + bizStatus + "\"");

        if (i == base.orderInfo.OrderItems.Count - 1)
            Response.Write("}");
        else
            Response.Write("},");
        
        i++;
    }

    Response.Write("];");      
    Response.Write("</script>");        
%>

<script type="text/javascript">
    for (var i = 0; i < itemList.length; i++) {
        addRowByOrder(
        itemList[i].itemType,
        itemList[i].itemCategory,
        itemList[i].itemCode,
        itemList[i].itemName,
        itemList[i].unit,
        itemList[i].price,
        itemList[i].quantity,
        itemList[i].zuofa,
        itemList[i].donateFlag,
        itemList[i].RID);
    }
    $("#spanFoodKindQuantity").html(itemList.length);
</script>

<% } %>

</form>
</body>
</html> 