﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="order_create_takefood_v_text.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.mainbiz.order_create_takefood_v_text" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/editlist.aspx"-->
<!--#include virtual="../include/js/editlist_s.aspx"--> 
<script type="text/javascript">         
    var foodMenuItemArray = new Array();
    
    onPageInited = function () {
        initListPage();
        loadFood();
    }
    
    function loadFood(){
        var storage = getStorage();
        var tableMenuKey = getTableMenuKey();
        var tableMenuString = storage.getItem(tableMenuKey);
        if (tableMenuString != null){
            foodMenuItemArray = JSON.parse(tableMenuString);
        }
        $("#spanFoodKindQuantity").html(foodMenuItemArray.length);
    }

    function afterDataListLoaded() {         
        var tableNo = $("#hfTableNo").val();
        var storage = getStorage();
        
        $("#tableBody").find("tr").each(function(){
            var $hfItemCode = $(this).find("input[name=hfItemCode]").eq(0);
            var $txtQuantity = $(this).find("input[name=txtQuantity]").eq(0);

            var itemCode = $hfItemCode.val();                 
            for (var i=0;i<foodMenuItemArray.length;i++){
                var foodMenuItem = foodMenuItemArray[i];
                if (itemCode == foodMenuItem.itemCode){ //如果已存在，则更新数量
                    $(this).addClass("tr_selected");
                    $txtQuantity.val(foodMenuItem.quantity);
                }
            }
        });
    }    
       
    function takeFood(operator, rowNumber) {
        var tableNo = $("#hfTableNo").val();
              
        var $txtQuantity = $("#txtQuantity_" + rowNumber); 
        var itemCode = $("#hfItemCode_" + rowNumber).val();
        var iCurrQuantity = parseFloat($txtQuantity.val());
        if (operator == "+") { //加菜
            iCurrQuantity++;
        } else if (operator == "-") { //减菜
            iCurrQuantity--;
            if (iCurrQuantity <= 0) { iCurrQuantity = 0; }
        }
        $txtQuantity.val(iCurrQuantity.toString()); //数量

        var exists = false;
        for (var i=0;i<foodMenuItemArray.length;i++){
            var foodMenuItem = foodMenuItemArray[i];
            if (itemCode == foodMenuItem.itemCode){ //如果已存在，则更新数量
                exists = true;
                if (iCurrQuantity > 0){ //更新数量
                    foodMenuItem.quantity = iCurrQuantity.toString();
                }else{ //从数组中移除
                    foodMenuItemArray.splice(i,1);
                    break;   
                }
            }
        }
        
        if (!exists){
            addMenuItem_(rowNumber);
        }

        var tableMenuString = JSON.stringify(foodMenuItemArray);        
        var storage = getStorage();
        storage.setItem(getTableMenuKey(), tableMenuString);               

        if (iCurrQuantity >0){                       
            $("#tr_" + rowNumber).addClass("tr_selected");
        }
        else{
            $("#tr_" + rowNumber).removeClass("tr_selected");
        }

        $("#spanFoodKindQuantity").html(foodMenuItemArray.length.toString());
        event.stopPropagation();  //阻止事件冒泡，避免行被选中；
    }

    function addMenuItem_(rowNumber){
        var foodMenuItem = new Object();
        foodMenuItem.itemType = $("#hfItemType_" + rowNumber).val();
        foodMenuItem.itemCategory = $("#hfItemCategory_" + rowNumber).val();
        foodMenuItem.itemCode = $("#hfItemCode_" + rowNumber).val();
        foodMenuItem.itemName = $("#hfItemName_" + rowNumber).val();
        foodMenuItem.unit = $("#hfUnit_" + rowNumber).val();
        foodMenuItem.price = $("#hfPrice_" + rowNumber).val();        
        foodMenuItem.quantity = $("#txtQuantity_" + rowNumber).val();
        foodMenuItem.zuofa = "";
        foodMenuItem.donateFlag = "0";
        foodMenuItemArray.push(foodMenuItem);
    }

    function JTongSmartListTable_trClick(trObj) {        
        var rowNum = $(trObj).attr("id").split("_")[1];
        var $txtQuantity = $(trObj).find("input[name=txtQuantity]").eq(0);
        if ($txtQuantity.val().trim() == "0" || $txtQuantity.val().trim() == ""){
            takeFood("+", rowNum);
        }else{
            takeFood("-", rowNum);
        }               
    }

    function reTakeFood(){
        window.localStorage.removeItem(getTableMenuKey());
        window.location.reload();
    }

    function cancel(){
        window.localStorage.removeItem(getTableMenuKey());
        window.location.href = "workplat.aspx";
    }

    function showMakedFoodMenu(tableNo){
        window.location.href = "order_create_takenfood.aspx?tableno=" + tableNo;
    }

    
    function getTableMenuKey() {
        var tableNo = $("#hfTableNo").val();
        var key = "TableMenu_" + tableNo;
        return key;
    }

    function getStorage() {
        return window.localStorage;
    }

</script>

<style type="text/css">
.textbox {
    width:30px;
    text-align:center;
    font-weight:bold;
}
.tr_selected{
    background-color:#ffd800;
}
.bottomBar {
    margin-top:-1px;
    padding:5px;
    text-align:center;
}
</style>

</head>
<body>
<form id="Form1" method="post" runat="server">


<div id="pageWrapper">    

    <div id="headerBar">
        <h1>点菜(<% = base.tableNo %> 号台)</h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:goHome();" class="icon home"></a>
        </div>  
    </div> 
    
    <div id="toolBar">   
        <a href="#" class="jtongui-toolbarbutton" icon="icon-search" menu="menu_foodCategories">分类</a>    
        <div id="menu_foodCategories" class="jtongui-toolbarbutton-menu">
            <asp:Repeater ID="rpFoodCategories" Runat="server" EnableViewState="False"  >    
            <ItemTemplate>
            <a href="?act=continue&tableno=<% = base.tableNo %>&category=<%# Eval("Category_Code")%>"><%# Eval("Category_Name")%></a>
            </ItemTemplate>            
            </asp:Repeater>    
        </div>                               
        <a href="javascript:showMakedFoodMenu('<% = base.tableNo %>')" class="jtongui-toolbarbutton">已点菜单(<span id="spanFoodKindQuantity">0</span>)</a>        
        <a href="#" class="jtongui-toolbarbutton" menu="menu_moreAct">更多操作</a>
        <div id="menu_moreAct" class="jtongui-toolbarbutton-menu">            
            <a href="javascript:reTakeFood()" icon="icon-clear">清空重点</a>            
            <a href="javascript:cancel()" icon="icon-clear">放弃</a>            
        </div>                               
    </div><!--toolBar.END-->  
                       
    <div id="dataBar">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <td style="width:190px;text-align:center;">菜名</td>        	         	  	       	    
        <td style="width:40px;text-align:center;">数量</td>
        <td style="text-align:left;">操作</td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <table id="tableBody" cellpadding="3" cellspacing="0" class="tablebody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr id="tr_<%# Container.ItemIndex%>">
        <td align="left" class="td_itemName"><%# ShowLetterIndex(Eval("Input_Code").ToString())%> <%# Eval("Item_Name")%> <%# Convert.ToDecimal(Eval("Price")).ToString("F2")%>/<%# Eval("Unit")%></td>                
        <td align="center"><input type="text" class="textbox" value="0" name="txtQuantity" id="txtQuantity_<%# Container.ItemIndex%>" /></td>
        <td align="left">
            <input type="hidden" name="hfItemType" id="hfItemType_<%# Container.ItemIndex%>" value="<%# Eval("Item_Type")%>" />
            <input type="hidden" name="hfItemCategory" id="hfItemCategory_<%# Container.ItemIndex%>" value="<%# Eval("Category_Code")%>" />
            <input type="hidden" name="hfItemCode" id="hfItemCode_<%# Container.ItemIndex%>" value="<%# Eval("Item_Code")%>" />
            <input type="hidden" name="hfItemName" id="hfItemName_<%# Container.ItemIndex%>" value="<%# Eval("Item_Name")%>" />
            <input type="hidden" name="hfUnit" id="hfUnit_<%# Container.ItemIndex%>" value="<%# Eval("Unit")%>" />
            <input type="hidden" name="hfPrice" id="hfPrice_<%# Container.ItemIndex%>" value="<%# Eval("Price")%>" />

            <input type="button" value="+" onclick="takeFood('+', <%# Container.ItemIndex%>);" />
            <input type="button" value="-" onclick="takeFood('-', <%# Container.ItemIndex%>);" />
        </td>  
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

    <asp:HiddenField ID="hfTableNo" runat="server" />

    <div id="bottomToolBar">
        <div style="padding-top:3px;text-align:center;">
        <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="showMakedFoodMenu('<% = base.tableNo %>');" value="选好了" />
        </div>
    </div>

    <!--#include virtual="../footer.aspx"-->
    
</div>

<script type="text/javascript">
    var storage = getStorage();    

    <%
        string act = Request.QueryString["act"];
        if (String.IsNullOrEmpty(act))
        {
            Response.Write("storage.removeItem(getTableMenuKey());");
        }
    %>
</script>

</form>
</body>
</html> 