﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="food_view.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.mainbiz.food_view" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/edit.aspx"-->
<link rel="stylesheet" type="text/css" href="../app_themes/default/css/foodtake.css" />
<!--#include virtual="../include/js/edit.aspx"--> 
<script type="text/javascript">     
    var foodMenuItemArray = new Array();
    onPageInited = function () {
        loadFood();
    }

    //加载已点菜品；
    function loadFood() {
        var storage = getStorage();
        var tableMenuKey = getTableMenuKey();
        var tableMenuString = storage.getItem(tableMenuKey);
        if (tableMenuString != null) {
            foodMenuItemArray = JSON.parse(tableMenuString);

            var itemCode = $("#hfItemCode").val();
            for (var i = 0; i < foodMenuItemArray.length; i++) {
                var foodMenuItem = foodMenuItemArray[i];
                if (itemCode == foodMenuItem.itemCode) {
                    $("#txtQuantity").val(foodMenuItem.quantity);
                    break;
                }
            }
        }        
    }

    //加/减菜；
    function takeFood(operator) {
        var tableNo = $("#hfTableNo").val();
        var $txtQuantity = $("#txtQuantity");
        var itemCode = $("#hfItemCode").val();
        var iCurrQuantity = parseFloat($txtQuantity.val());
        if (operator == "+") { //加菜
            iCurrQuantity++;
        } else if (operator == "-") { //减菜
            iCurrQuantity--;
            if (iCurrQuantity <= 0) { iCurrQuantity = 0; }
        }
        $txtQuantity.val(iCurrQuantity.toString()); //数量

        var exists = false;
        for (var i = 0; i < foodMenuItemArray.length; i++) {
            var foodMenuItem = foodMenuItemArray[i];
            if (itemCode == foodMenuItem.itemCode) { //如果已存在，则更新数量
                exists = true;
                if (iCurrQuantity > 0) { //更新数量
                    foodMenuItem.quantity = iCurrQuantity.toString();
                } else { //从数组中移除
                    foodMenuItemArray.splice(i, 1);
                    break;
                }
            }
        }

        if (!exists) {
            addMenuItem_();
        }

        var tableMenuString = JSON.stringify(foodMenuItemArray);
        var storage = getStorage();
        storage.setItem(getTableMenuKey(), tableMenuString);        
    }

    //将选定的菜品放入到已点菜品集合中；
    function addMenuItem_() {
        var foodMenuItem = new Object();
        foodMenuItem.itemType = $("#hfItemType").val();
        foodMenuItem.itemCategory = $("#hfItemCategory").val();
        foodMenuItem.itemCode = $("#hfItemCode").val();
        foodMenuItem.itemName = $("#hfItemName").val();
        foodMenuItem.unit = $("#hfUnit").val();
        foodMenuItem.price = $("#hfPrice").val();
        foodMenuItem.quantity = $("#txtQuantity").val();
        foodMenuItem.zuofa = "";
        foodMenuItem.donateFlag = "0";
        foodMenuItemArray.push(foodMenuItem);
    }

    function getTableMenuKey() {
        var tableNo = $("#hfTableNo").val();
        var orderNo = $("#hfOrderNo").val();
        var key = null;
        if (orderNo == "") {
            key = "TableMenu_" + tableNo;
        } else {
            key = "TableAddedFood_" + tableNo;
        }
            
        return key;
    }
    function getStorage() {
        return window.localStorage;
    }

    function share() {
        var shopID = "<% = base.SystemConfig.BizConfigInfo.Shop_ID %>";
        var itemCode = "<% = base.chargeItemInfo.Item_Code %>";
        window.location.href = "http://shejian.jdingsoft.com/main/shopcenter/food_view.aspx?shopcode=" + shopID + "&itemcode=" + itemCode + "&random=" + Math.random();
    }

</script>
<style type="text/css">
.title{
    padding:10px;
    line-height:170%;
    font-size:16px;
}
.pic {
    padding:0px;
    text-align:center;
}
.tag{
    padding:10px;
    line-height:170%;
    font-size:16px;
}
.desc{
    padding:10px;
    padding-top:0px;
    line-height:170%;
    font-size:16px;
}

</style>
</head>
<body>

<form id="Form1" method="post" runat="server">


<div id="pageWrapper">    

    <div id="headerBar">
        <h1><% = base.chargeItemInfo.Item_Name %></h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:goHome();" class="icon home"></a>
        </div>  
    </div> 

    <div id="dataBar">

        <div class="title">
            <h1><% = base.chargeItemInfo.Item_Name %></h1>
        </div>

        <div class="pic">
            <img src="/resources/pics/chargeitem/m/<% = base.chargeItemInfo.Image %>" />
        </div>

        <div class="tag">
            <p>推荐指数：<% = ShowStars(base.chargeItemInfo.Stars) %> &nbsp;&nbsp;&nbsp;人气值：<% = base.chargeItemInfo.Order_Count.ToString() %></p>
        </div>

        <div class="desc">
            <% = base.chargeItemInfo.Item_Desc %>
        </div>

    </div>

    <div class="bar" style="padding:5px;margin-top:-1px;text-align:center;">
        
        <input type="text" class="textbox" value="0" name="txtQuantity" id="txtQuantity" />

        <input type="button" value="+" onclick="takeFood('+');" class="oprBtn" />
        <input type="button" value="-" onclick="takeFood('-');" class="oprBtn" />        
    </div>

    <div class="bar" style="padding:5px;margin-top:-1px;text-align:center;">
        <input type="button" id="btnShare" class="btn" style="width:100px" onclick="share()" value="分享到朋友圈" />
        <input type="button" id="btnCancel" class="btn" style="" onclick="window.history.back()" value="返回" />
    </div>

    <input type="hidden" name="hfItemType" id="hfItemType" value="<% = base.chargeItemInfo.Item_Type%>" />
    <input type="hidden" name="hfItemCategory" id="hfItemCategory" value="<% = base.chargeItemInfo.Category_Code%>" />
    <input type="hidden" name="hfItemCode" id="hfItemCode" value="<% = base.chargeItemInfo.Item_Code %>" />
    <input type="hidden" name="hfItemName" id="hfItemName" value="<% = base.chargeItemInfo.Item_Name%>" />
    <input type="hidden" name="hfUnit" id="hfUnit" value="<% = base.chargeItemInfo.Unit %>" />
    <input type="hidden" name="hfPrice" id="hfPrice" value="<% = base.chargeItemInfo.Price.ToString("F2")%>" />
    
    <asp:HiddenField ID="hfTableNo" runat="server" />
    <asp:HiddenField ID="hfOrderNo" runat="server" />

    <!--#include virtual="../footer_customer.aspx"-->
    
</div>

</form>
</body>
</html> 