﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="customer_order_view.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.mainbiz.customer_order_edit_view" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/edit.aspx"-->
<link rel="stylesheet" type="text/css" href="../app_themes/default/css/foodtake.css" />
<link href="/uicontrols/jtongui_mobile/themes/default/toolbarbutton.css" type="text/css" rel="Stylesheet" />
<link href="/uicontrols/jtongui_mobile/themes/icon.css" type="text/css" rel="Stylesheet" />
<!--#include virtual="../include/js/edit.aspx"--> 
<script type="text/javascript" src="/uicontrols/jtongui_mobile/plugins/jtong.toolbarbutton.js"></script>
<script type="text/javascript">    

    onPageInited = function () {
        JTongToolBarButton_init();
    }

    //加菜;
    function goAddFood() {
        window.location.href = "customer_order_edit_addfood.aspx"
    }

    function refresh() {
        window.location.reload();
    }

    function orderChanges() {
        window.location.href = "customer_order_changes.aspx";
    }

    function comment() {
        window.location.href = "customer_comment.aspx";
    }
    
    function viewOtherTable() {        
        window.location.href = "customer_order_view_verify.aspx?act=selctbymanual"
    }

    function logout() {
        if (confirm("确定要退出吗？")) {
            window.location.href = "customer_logout.aspx";
        }
    }

</script>

<script type="text/javascript">

    function addRowByOrder(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag) {
        formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag, originalFlag);
    }

    var formEditListTable_RowCounter = 0;
    function formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag, originalFlag) {
            
        formEditListTable_RowCounter++;

        var $srcTable = $("#srcTable");
        var srcTableID = $srcTable.attr("id");

        //不要合并数量；
        ////如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
        //if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
        //    return;
        //}

        var rowHtml = '';
        var $row = null;
        var rowCnt = $srcTable[0].rows.length;
        var rowID = formEditListTable_RowCounter;

        itemName = itemName.replace(/'/g, "‘");
        unit = unit.replace(/'/g, "‘");
                        
        var amount = (price * quantity).toFixed(2).toString(); //优惠前金额
            
        rowHtml += '<tr id="tr_' + rowID + '" onclick="viewDetail(\''+ itemCode +'\');">';
        
        rowHtml += '<td style="text-align:left;padding-left:5px;">';
        rowHtml += '<span>' + itemName + '</span>';
        rowHtml += ' ';
        rowHtml += '<span>' + price + '</span>';
        rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
        rowHtml += '<input type="hidden" name="hfItemCategory" value="' + itemCategory + '" />';
        rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
        rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" id="hfItemCode_'+ rowID +'" />';
        rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
        rowHtml += '<input type="hidden" name="hfPrice" value="' + price + '" id="hfPrice_'+ rowID +'" />';
        rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
        rowHtml += '</td>';
    
        rowHtml += '<td><input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" class="textbox" readonly=readonly onkeyup="formEditListTable_caculateAmount(' + rowID + ')" /></td>';

        rowHtml += '<td>';
        rowHtml += '<input class="zuofa" type="text" name="txtZuofa" maxlength="25" value="' + zuofa + '" id="txtZuofa_' + rowID + '" readonly=readonly/>';
        rowHtml += '</td>';

        rowHtml += '<td style="text-align:center;">';
        if (donateFlag == "1") {
            rowHtml += '√';
        } else {
            rowHtml += '';
        }            
        rowHtml += '<input type="hidden" name="hfDonate" value="'+ donateFlag +'" id="hfDonate_' + rowID + '" />';
        rowHtml += '</td>';
        
        rowHtml += '<td style="text-align:left;">';        
        rowHtml += '<input type="button" value="分享" class="oprBtn" />';
        rowHtml += '</td>';

        rowHtml += '</tr>';

        $row = $(rowHtml);
        $srcTable.append($row);

        formEditListTable_setRowNo();
        formEditListTable_setTotalAmount();
        formEditListTable_hideTbNoRecord();
    }

    function formEditListTable_setTotalAmount() {
        var $srcTable = $("#srcTable");
        $srcTable.find("#trTotal").remove();

        var totalRowHtml = '';
        var totalAmount = 0.00;
        //var $hfAmountList = $srcTable.find("input[name=hfAmount]");
        var dataRows = $srcTable.find("tr[id]");

        dataRows.each(function () {
            var $hfAmount = $(this).find("input[name=hfAmount]").eq(0);
            var donateFlag = $(this).find("input[name=hfDonateFlag]").eq(0);

            if (donateFlag == "0") { //如果不是赠送的
                totalAmount += parseFloat($hfAmount.val());
            }
        });

        //$hfAmountList.each(function () {
        //    totalAmount += parseFloat($(this).val());
        //});

        //if ($hfAmountList.length > 0) {  //如果有数据行，则添加合计行
        if (dataRows.length > 0) {  //如果有数据行，则添加合计行     
            $("#hfTotalAmount").val(totalAmount.toFixed(2).toString());
            $("#spanTotalAmount").html(totalAmount.toFixed(2).toString());
        } else {
            $("#hfTotalAmount").val("0.00");
            $("#spanTotalAmount").html("0.00");
        }
    }

    function formEditListTable_caculateAmount(rowID) {
        var $txtQuantity = $("#txtQuantity_" + rowID);
        var $txtPrice = $("#hfPrice_" + rowID);
        var $spanDiscount = "";
        var sQuantity = $txtQuantity.val();
        var sPrice = $txtPrice.val();
        var amount = 0.00; //优惠前

        if (sQuantity == "") {
            sQuantity = "0";
        }
        if (sPrice == "") {
            sPrice = "0";
        }
 
        ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
        //clearNoNum($txtQuantity[0]);
        //clearNoNum($txtPrice[0]);

        if (isNaN(sQuantity)) {
            alert("数量为无效数字！");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (isNaN(sPrice)) {
            alert("单价为无效数字.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }          
        if (parseFloat(sQuantity) > 100000 || parseFloat(sQuantity) <0) {  //限制数量不能超过100000
            alert("数量不能小于0或超过100000.");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (parseFloat(sPrice) > 100000 || parseFloat(sPrice) < 0) {  //单价不能超过100000
            alert("单价不能小于0或超过100000.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }

        if ($txtQuantity.hasClass("error")) {
            $txtQuantity.removeClass("error");
        }
        if ($txtPrice.hasClass("error")) {
            $txtPrice.removeClass("error");
        }

        amount = parseFloat(sQuantity) * parseFloat(sPrice);
            
        $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());
        $("#spanAmount_" + rowID).html(amount.toFixed(2).toString());

        formEditListTable_setTotalAmount();
    }

    function viewDetail(itemCode) {
        var tableNo = $("#hfTableNo").val();
        var orderNo = $("#hfKey").val();
        window.location.href = "food_view.aspx?itemcode=" + itemCode + "&tableno=" + tableNo + "&orderno=" + orderNo;        
        event.stopPropagation();  //阻止事件冒泡，避免行被选中；
    }    

    </script>

<style type="text/css">
.textbox {
    width:30px;
    text-align:center;
}
.bottomBar {
    margin-top:-1px;
    padding:5px;
    text-align:center;
}
</style>

</head>
<body>

<form id="Form1" method="post" runat="server">

<div id="pageWrapper">    

    <div id="headerBar">
        <h1>菜单(<% = base.tableNo %> 号台)</h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:logout();" class="icon logout"></a>
            <a href="javascript:goHome('1');" class="icon home"></a>
        </div>  
    </div> 

    <div id="toolBar">   
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>
        <a href="javascript:goAddFood()" class="jtongui-toolbarbutton" icon="icon-add">加菜</a> 
        <a href="javascript:orderChanges()" class="jtongui-toolbarbutton" icon="icon-detail">调菜记录</a>       
        <a href="javascript:comment()" class="jtongui-toolbarbutton" icon="icon-edit">点评</a>
      <%--  <a href="javascript:viewOtherTable()" class="jtongui-toolbarbutton" icon="icon-search">查看其它餐台菜单</a>--%>
    </div><!--toolBar.END-->  

    <div id="dataBar">
        <table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:0px;">
        <thead>
        <tr>
            <td style="text-align:center;">菜名</td>        	         	  	       	    
            <td style="width:40px;text-align:center;">数量</td>
            <td style="width:30px;text-align:center;">口味</td>
            <td style="width:25px;text-align:center;">赠</td>
            <td style="width:40px;text-align:center;">分享</td>
        </tr>        
        </thead>
        </table>           
    </div><!--dataBar.END-->    

    <div class="bar bottomBar">
        <input type="hidden" name="hfTotalAmount" id="hfTotalAmount" />
        共 <span id="spanFoodKindQuantity">0</span> 道菜，
        总金额：<span id="spanTotalAmount">0.00</span> 
        <% 
            if (base.orderInfo != null)
            {
                Response.Write("（状态："+ VA.Modules.JDingCYT.Core.Enums.OrderConverter.OrderBizStatusConverter.Convert_Value_ToText(base.orderInfo.Order_Biz_Status) +"）"); 
            }   
        %>
    </div>

   <%-- <div class="bar bottomBar" style="text-align:left;">
       <span class="note">注：如需调菜，请通知服务员。</span>
    </div>--%>    

    <!--#include virtual="../footer_customer.aspx"-->

    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfTableNo" runat="server" />
    
</div>

<% if (base.orderInfo != null){ %>
<%
    
    Response.Write("<script type=\"text/javascript\">");       
    Response.Write("var itemList = [");       
       
    var i = 0;       
    foreach (VA.Modules.JDingCYT.Core.Model.MainBiz.OrderItemInfo item in base.orderInfo.OrderItems)
    {
        string itemType = item.Item_Type;
        string itemCategory = item.Item_Category;
        string itemCode = item.Item_Code;
        string itemName = item.Item_Name;
        string unit = item.Unit;
        string price = item.Price.ToString("F2");        
        string quantity = item.Quantity.ToString();
        string zuofa = item.Zuofa.Replace(",","，").Replace("\"","“").Replace("\'","‘");
        string donateFlag = item.Donate_Flag;
        string bizStatus = item.Biz_Status;

        Response.Write("{");
        Response.Write("\"itemType\":\"" + itemType + "\",\"itemCategory\":\"" + itemCategory + "\",\"itemName\":\"" + itemName + "\",\"itemCode\":\"" + itemCode + "\",\"unit\":\"" + unit + "\",\"price\":\"" + price + "\",\"quantity\":\"" + quantity + "\",\"zuofa\":\"" + zuofa + "\",\"donateFlag\":\"" + donateFlag + "\",\"bizStatus\":\"" + bizStatus + "\"");

        if (i == base.orderInfo.OrderItems.Count - 1)
            Response.Write("}");
        else
            Response.Write("},");
        
        i++;
    }

    Response.Write("];");      
    Response.Write("</script>");        
%>

<script type="text/javascript">
    var originalFlag = "1";
    for (var i = 0; i < itemList.length; i++) {
        addRowByOrder(
        itemList[i].itemType,
        itemList[i].itemCategory,
        itemList[i].itemCode,
        itemList[i].itemName,
        itemList[i].unit,
        itemList[i].price,
        itemList[i].quantity,
        itemList[i].zuofa,
        itemList[i].donateFlag,
        originalFlag);
    }
    $("#spanFoodKindQuantity").html(itemList.length);
    $("#spanTotalAmount").html("<% = orderInfo.Order_Costs.ToString("F2")%>");
</script>

<% } %>

</form>
</body>
</html> 