﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="customer_order_create_takenfood.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.mainbiz.customer_order_create_takenfood" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/edit.aspx"-->
<link href="/uicontrols/jtongui_mobile/themes/default/toolbarbutton.css" type="text/css" rel="Stylesheet" />
<link href="/uicontrols/jtongui_mobile/themes/icon.css" type="text/css" rel="Stylesheet" />
<link href="../app_themes/default/css/foodtake.css" type="text/css" rel="stylesheet" >
<!--#include virtual="../include/js/edit.aspx"--> 
<script type="text/javascript" src="/uicontrols/jtongui_mobile/plugins/jtong.toolbarbutton.js"></script>
<script type="text/javascript">    

    var foodMenuItemArray = new Array();

    onPageInited = function () {
        JTongToolBarButton_init();
        loadFood();
    }

    //加载已点菜品；
    function loadFood() {
        var storage = getStorage();
        var tableMenuKey = getTableMenuKey();
        var tableMenuString = storage.getItem(tableMenuKey);
        if (tableMenuString != null) {
            foodMenuItemArray = JSON.parse(tableMenuString);            
        }
        
        for (var i = 0; i < foodMenuItemArray.length; i++) {
            var foodMenuItem = foodMenuItemArray[i];

            var itemType = foodMenuItem.itemType;
            var itemCategory = foodMenuItem.itemCategory;
            var itemCode = foodMenuItem.itemCode;
            var itemName = foodMenuItem.itemName;
            var unit = foodMenuItem.unit;
            var price = foodMenuItem.price;
            var quantity = foodMenuItem.quantity;
            var zuofa = foodMenuItem.zuofa;
            var donateFlag = foodMenuItem.donateFlag;

            formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag);
        }
        $("#spanFoodKindQuantity").html(foodMenuItemArray.length);
    }

    function takeFood(operator, rowNumber) {

        var $txtQuantity = $("#txtQuantity_" + rowNumber);
        var itemCode = $("#hfItemCode_" + rowNumber).val();
        var iCurrQuantity = parseFloat($txtQuantity.val());
        if (operator == "+") { //加菜
            iCurrQuantity++;
        } else if (operator == "-") { //减菜
            iCurrQuantity--;
            if (iCurrQuantity <= 0) { iCurrQuantity = 0; }
        }
        $txtQuantity.val(iCurrQuantity.toString()); //数量

        for (var i = 0; i < foodMenuItemArray.length; i++) {            
            var foodMenuItem = foodMenuItemArray[i];        
            if (itemCode == foodMenuItem.itemCode) { //如果已存在，则更新数量     
                if (iCurrQuantity > 0) { //更新数量
                    foodMenuItem.quantity = iCurrQuantity.toString();
                    formEditListTable_caculateAmount(rowNumber);
                } else { //从数组中移除
                    foodMenuItemArray.splice(i, 1);
                    formEditListTable_removeRow(rowNumber);
                    break;
                }
            }
        }

        var tableMenuString = JSON.stringify(foodMenuItemArray);
        var storage = getStorage();
        storage.setItem(getTableMenuKey(), tableMenuString);

        $("#spanFoodKindQuantity").html(foodMenuItemArray.length.toString());
    }

    function getTableMenuKey() {
        var tableNo = $("#hfTableNo").val();
        var key = "TableMenu_" + tableNo;
        return key;
    }

    function getStorage() {
        return window.localStorage;
    }

    function goTakeNewFood() {
        var tableNo = $("#hfTableNo").val();
        window.location.href = "customer_order_create_takefood.aspx?tableno="+ tableNo +"&act=continue"
    }

    function cancel() {
        resetPage();
        window.location.href = "../";
    }    

    function save() {

        var tableNo = $("#hfTableNo").val().trim();
        if (tableNo == "") {
            JTongAlert('提示', "“餐台号”不能为空！", 'warning');
            return;
        }

        if (!formEditListTable_checkTableData()) {
            return;
        }

        JTongAlertConfirm("确定要提交菜单吗？", function () {

            var requestType = "POST";
            var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();
            var successFN = function (data, textStatus) {
                var bizNo = "";
                if (data.substring(0, 2) == "ok") {
                    bizNo = data.split("|")[1];
                    showActResult("菜单提交成功，请及时通知服务员确认菜单！", true, doAfterAdd, bizNo);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, doAfterAdd, bizNo);
                }
                else {
                    showActResult("菜单提交失败：" + data, false, doAfterAdd, bizNo);
                }
            };
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );

        });        
    }

    function doAfterAdd(actResult, bizNo) {
        if (actResult) {
            resetPage();
            var tableNo = $("#hfTableNo").val().trim();
            window.location.href = pageName + "?act=setsession&orderno=" + bizNo + "&tableno=" + tableNo;
        }
    }

    //显示操作结果；
    function showActResult(sMsg, actResult, callback, bizNo) {
        var icon = "info";
        if (!actResult) {
            icon = "error";
        }

        JTongAlert('操作结果', sMsg, icon, function () {
            if (callback != null && callback != undefined) {
                callback(actResult, bizNo);
            }
        });
    }

    function resetPage() {
        getStorage().removeItem(getTableMenuKey());
        formEditListTable_clearRows();
        clearTableInfo();
    }

    function clearTableInfo() {
        var tableNo = $("#hfTableNo").val().trim();
        var key = "TableInfo_" + tableNo;
        var storage = getStorage();
        storage.removeItem(key);
    }

</script>

<script type="text/javascript">

    var formEditListTable_RowCounter = 0;

    function formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag) {
            
        formEditListTable_RowCounter++;

        var $srcTable = $("#srcTable");
        var srcTableID = $srcTable.attr("id");

        //如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
        if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
            return;
        }

        var rowHtml = '';
        var $row = null;
        var rowCnt = $srcTable[0].rows.length;
        var rowID = formEditListTable_RowCounter;

        itemName = itemName.replace(/'/g, "‘");
        unit = unit.replace(/'/g, "‘");
                        
        var amount = (price * quantity).toFixed(2).toString(); //优惠前金额
            
        rowHtml += '<tr id="tr_' + rowID + '">';
        
        rowHtml += '<td style="text-align:left;padding-left:5px;">';
        rowHtml += '<span>' + itemName + '</span>';
        rowHtml += '<span>' + price + '</span>';
        rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
        rowHtml += '<input type="hidden" name="hfItemCategory" value="' + itemCategory + '" />';
        rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
        rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" id="hfItemCode_'+ rowID +'" />';
        rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
        rowHtml += '<input type="hidden" name="hfPrice" value="' + price + '" id="hfPrice_'+ rowID +'" />';
        rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
        rowHtml += '</td>';
    
        rowHtml += '<td><input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" /></td>';

        rowHtml += '<td onclick="takeZuofa(' + rowID + ')">';
        rowHtml += '<span id="spanZuofa_' + rowID + '">'+ zuofa +'</span>';
        rowHtml += '<input class="zuofa" type="hidden" name="txtZuofa" maxlength="25" value="' + zuofa + '" id="txtZuofa_' + rowID + '" onclick="takeZuofa(' + rowID + ')" onkeyup="formEditListTable_processZuofaText(' + rowID + ')" />';
        rowHtml += '</td>';

        rowHtml += '<td style="text-align:center;display:none;">';
        if (donateFlag == "1") {
            rowHtml += '<input type="checkbox" name="ckbDonate" id="ckbDonate_' + rowID + '" checked="checked" onclick="setDonate(' + rowID + ')" />';
        } else {
            rowHtml += '<input type="checkbox" name="ckbDonate" id="ckbDonate_' + rowID + '" onclick="setDonate(' + rowID + ')" />';
        }            
        rowHtml += '<input type="hidden" name="hfDonate" value="'+ donateFlag +'" id="hfDonate_' + rowID + '" />';
        rowHtml += '</td>';

        rowHtml += '<td style="text-align:left;">';        
        rowHtml += '<input type="button" value="+" onclick="takeFood(\'+\',' + rowID + ');" class="oprBtn" />';
        rowHtml += ' ';
        rowHtml += '<input type="button" value="-" onclick="takeFood(\'-\',' + rowID + ');" class="oprBtn" />';
        rowHtml += '</td>';

        rowHtml += '</tr>';

        $row = $(rowHtml);
        $srcTable.append($row);

        formEditListTable_setRowNo();
        formEditListTable_setTotalAmount();
        formEditListTable_hideTbNoRecord();
    }

    function formEditListTable_setTotalAmount() {
        var $srcTable = $("#srcTable");
        $srcTable.find("#trTotal").remove();

        var totalRowHtml = '';
        var totalAmount = 0.00;
        //var $hfAmountList = $srcTable.find("input[name=hfAmount]");
        var dataRows = $srcTable.find("tr[id]");

        dataRows.each(function () {
            var $hfAmount = $(this).find("input[name=hfAmount]").eq(0);
            var $hfCkbDonate = $(this).find("input[name=ckbDonate]").eq(0);

            if (!$hfCkbDonate[0].checked) {
                totalAmount += parseFloat($hfAmount.val());
            }
        });

        //$hfAmountList.each(function () {
        //    totalAmount += parseFloat($(this).val());
        //});

        //if ($hfAmountList.length > 0) {  //如果有数据行，则添加合计行
        if (dataRows.length > 0) {  //如果有数据行，则添加合计行   
            $("#hfTotalAmount").val(totalAmount.toFixed(2).toString());
            $("#spanTotalAmount").html(totalAmount.toFixed(2).toString());
        } else {
            $("#hfTotalAmount").val("0.00");
            $("#spanTotalAmount").html("0.00");
        }
    }

    function formEditListTable_caculateAmount(rowID) {
        var $txtQuantity = $("#txtQuantity_" + rowID);
        var $txtPrice = $("#hfPrice_" + rowID);
        var $spanDiscount = "";
        var sQuantity = $txtQuantity.val();
        var sPrice = $txtPrice.val();
        var amount = 0.00; //优惠前

        if (sQuantity == "") {
            sQuantity = "0";
        }
        if (sPrice == "") {
            sPrice = "0";
        }
 
        ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
        //clearNoNum($txtQuantity[0]);
        //clearNoNum($txtPrice[0]);

        if (isNaN(sQuantity)) {
            alert("数量为无效数字！");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (isNaN(sPrice)) {
            alert("单价为无效数字.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }          
        if (parseFloat(sQuantity) > 100000 || parseFloat(sQuantity) <0) {  //限制数量不能超过100000
            alert("数量不能小于0或超过100000.");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (parseFloat(sPrice) > 100000 || parseFloat(sPrice) < 0) {  //单价不能超过100000
            alert("单价不能小于0或超过100000.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }

        if ($txtQuantity.hasClass("error")) {
            $txtQuantity.removeClass("error");
        }
        if ($txtPrice.hasClass("error")) {
            $txtPrice.removeClass("error");
        }

        amount = parseFloat(sQuantity) * parseFloat(sPrice);
            
        $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());
        $("#spanAmount_" + rowID).html(amount.toFixed(2).toString());

        formEditListTable_setTotalAmount();
    }

    function formEditListTable_checkTableData() {

        var result = true;

        var dataRowCount = 0;
        var $srcTable = $("#srcTable");

        $srcTable.find("input[name=txtQuantity]").each(function () {
            dataRowCount++;
            var sQuantity = $(this).val();
            if ($.trim(sQuantity) == "" || $.trim(sQuantity) == "0") {
                alert("数量不能为空或0！");
                $(this).focus();
                $(this).addClass("error");
                result = false;
                return;
            }
        });
        $srcTable.find("input[name=txtPrice]").each(function () {
            var sPrice = $(this).val();
            if ($.trim(sPrice) == "") {
                alert("单价不能为空！");
                $(this).focus();
                $(this).addClass("error");
                result = false;
                return;
            }
        });

        if (dataRowCount == 0) {
            alert("消费清单不能为空！");
            result = false;
        }

        return result;
    }        

    function clearItems() {
        formEditListTable_clearRows();
    }

    //做法============================================

    function formEditListTable_processZuofaText(rowID) {
        var $txtZuofa = $("#txtZuofa_" + rowID);
        var zuofa = $txtZuofa.val();
        zuofa = zuofa.replace(/,/g, "，");
        $txtZuofa.val(zuofa);
    }

    var $current_txtZuofa = null;
    var $current_spanZuofa = null;
    function takeZuofa(rowID) {
        var $txtZuofa = $("#txtZuofa_" + rowID);
        var $spanZuofa = $("#spanZuofa_" + rowID);
        $current_txtZuofa = $txtZuofa;
        $current_spanZuofa = $spanZuofa;
        openFrameWindow("做法列表", 200, 200, "get_foodmakeway_list.aspx?callback=takeZuofaCallback", true);
    }
    function takeZuofaCallback(trObj) {
        closeFrameWindow();
        var zuofa = $(trObj).find("td.zuofa").eq(0).html();
        $current_txtZuofa.val(zuofa);
        $current_spanZuofa.html(zuofa);
        
    }

    </script>

<style type="text/css">
.bottomBar {
    margin-top:-1px;
    padding:5px;
    text-align:center;
}
</style>

</head>
<body>

<form id="Form1" method="post" runat="server">

<div id="pageWrapper">    

    <div id="headerBar">
        <h1>菜单(<% = base.tableNo %> 号台)</h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:goHome('1');" class="icon home"></a>
        </div>  
    </div> 

    <div id="toolBar">   
        <a href="javascript:goTakeNewFood()" class="jtongui-toolbarbutton" icon="icon-add">继续点菜</a>
        <a href="javascript:cancel()" class="jtongui-toolbarbutton" icon="icon-undo">取消点菜</a>
    </div><!--toolBar.END-->  

    <div id="dataBar">

        <table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:0px;">
        <thead>
        <tr>
            <td style="width:170px;text-align:center;">菜名</td>        	         	  	       	    
            <td style="width:30px;text-align:center;">数量</td>
            <td style="width:30px;text-align:center;">口味</td>
            <td style="width:25px;text-align:center;display:none;">赠</td>
            <td style="text-align:left;">操作</td>
        </tr>        
        </thead>
        </table>        
   
    </div><!--dataBar.END-->   

    <div class="bar bottomBar">
        <input type="hidden" name="hfTotalAmount" id="hfTotalAmount" />        
        共 <span id="spanFoodKindQuantity"></span> 道菜，
        总金额：<span id="spanTotalAmount">0.00</span>
    </div>

    <div id="bottomToolBar">
            <input type="button" id="btnSubmit" class="btn" style="min-width:80px" onclick="save()" value="提交菜单" />           
    </div>    

    <!--#include virtual="../footer_customer.aspx"-->

    <asp:HiddenField ID="hfTableNo" runat="server" />
    <asp:HiddenField id="hfCustomerQuantity" runat="server" />

</div>

</form>
</body>
</html> 