﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="customer_order_create_takefood.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.mainbiz.customer_order_create_takefood" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/editlist.aspx"-->
<link rel="stylesheet" type="text/css" href="../app_themes/default/css/foodtake.css" />
<!--#include virtual="../include/js/editlist_s.aspx"--> 
<script type="text/javascript">         
    var foodMenuItemArray = new Array();
    
    onPageInited = function () {
        initListPage();
        initIndexPanel();
        loadFood();
    }

    //初始化字母索引面板；
    function initIndexPanel(){
        var dataBarHeight = $("#dataBar").outerHeight();
        $("#indexPanel").height(dataBarHeight);
   
        var tableNo = $("#hfTableNo").val();        
        var itemCategory = $("#hfItemCategory").val();
        var itemType = $("#hfItemType").val();
        $("#letterIndexer").find("li").click(function(){
            var letter = $(this).html();
            if (letter == "全部"){
                letter = "";
            }
            //window.location.href = "?tableno=" + tableNo + "&category="+ itemCategory +"&itemtype="+ itemType +"&letter=" + letter;

            //老方案；
            //window.location.href = "?tableno=" + tableNo + "&category="+ itemCategory +"&itemtype="+ itemType +"&letter=" + letter;

            //新方案；
            window.location.href = "#" + letter;
            $("#tableBody").find("h1.itemName").each(function(){
                var letterIndexer = $(this).attr("data-indexer");
                if (letterIndexer == letter){
                    $(this).addClass("item-selected");
                }else{
                    $(this).removeClass("item-selected");
                }
            });
        });
    }
    
    function loadFood(){
        var storage = getStorage();
        var tableMenuKey = getTableMenuKey();
        var tableMenuString = storage.getItem(tableMenuKey);
        if (tableMenuString != null){
            foodMenuItemArray = JSON.parse(tableMenuString);
        }
        $("#spanFoodKindQuantity").html(foodMenuItemArray.length);

        showSelectedItems();
        caculateTotalAmount();
    }    

    //醒目显示已点过的菜品；
    function showSelectedItems() { 
        $("#tableBody").find("tr").each(function(){
            var $hfItemCode = $(this).find("input[name=hfItemCode]").eq(0);
            var $txtQuantity = $(this).find("input[name=txtQuantity]").eq(0);

            var itemCode = $hfItemCode.val();                 
            for (var i=0;i<foodMenuItemArray.length;i++){
                var foodMenuItem = foodMenuItemArray[i];
                if (itemCode == foodMenuItem.itemCode){ //如果已存在，则更新数量
                    $(this).addClass("tr_selected");
                    $txtQuantity.val(foodMenuItem.quantity);
                }
            }
        });
    }
    
    //行点击事件（选菜或取消选菜）
    function trClick_handler(trObj) {
        var rowNum = $(trObj).attr("id").split("_")[1];
        var $txtQuantity = $(trObj).find("input[name=txtQuantity]").eq(0);
        if ($txtQuantity.val().trim() == "0" || $txtQuantity.val().trim() == ""){
            takeFood("+", rowNum);
        }else{
            takeFood("-", rowNum);
        }               
    }
       
    //加/减菜；
    function takeFood(operator, rowNumber) {
        var tableNo = $("#hfTableNo").val();
              
        var $txtQuantity = $("#txtQuantity_" + rowNumber); 
        var itemCode = $("#hfItemCode_" + rowNumber).val();
        var iCurrQuantity = parseFloat($txtQuantity.val());
        if (operator == "+") { //加菜
            iCurrQuantity++;
        } else if (operator == "-") { //减菜
            iCurrQuantity--;
            if (iCurrQuantity <= 0) { iCurrQuantity = 0; }
        }
        $txtQuantity.val(iCurrQuantity.toString()); //数量

        var exists = false;
        for (var i=0;i<foodMenuItemArray.length;i++){
            var foodMenuItem = foodMenuItemArray[i];
            if (itemCode == foodMenuItem.itemCode){ //如果已存在，则更新数量
                exists = true;
                if (iCurrQuantity > 0){ //更新数量
                    foodMenuItem.quantity = iCurrQuantity.toString();
                }else{ //从数组中移除
                    foodMenuItemArray.splice(i,1);
                    break;   
                }
            }
        }
        
        if (!exists){
            addMenuItem_(rowNumber);
        }

        var tableMenuString = JSON.stringify(foodMenuItemArray);        
        var storage = getStorage();
        storage.setItem(getTableMenuKey(), tableMenuString);               

        if (iCurrQuantity >0){                       
            $("#tr_" + rowNumber).addClass("tr_selected");
        }
        else{
            $("#tr_" + rowNumber).removeClass("tr_selected");
        }

        caculateTotalAmount();

        $("#spanFoodKindQuantity").html(foodMenuItemArray.length.toString());
        event.stopPropagation();  //阻止事件冒泡，避免行被选中；
    }

    //将选定的菜品放入到已点菜品集合中；
    function addMenuItem_(rowNumber){
        var foodMenuItem = new Object();
        foodMenuItem.itemType = $("#hfItemType_" + rowNumber).val();
        foodMenuItem.itemCategory = $("#hfItemCategory_" + rowNumber).val();
        foodMenuItem.itemCode = $("#hfItemCode_" + rowNumber).val();
        foodMenuItem.itemName = $("#hfItemName_" + rowNumber).val();
        foodMenuItem.unit = $("#hfUnit_" + rowNumber).val();
        foodMenuItem.price = $("#hfPrice_" + rowNumber).val();        
        foodMenuItem.quantity = $("#txtQuantity_" + rowNumber).val();
        foodMenuItem.zuofa = "";
        foodMenuItem.donateFlag = "0";
        foodMenuItemArray.push(foodMenuItem);
    }

    //计算总金额；
    function caculateTotalAmount(){
        
        //计算总金额；
        var totalAmount = 0.00;
        for (var i=0;i<foodMenuItemArray.length;i++){
            var foodMenuItem = foodMenuItemArray[i];
            var price = foodMenuItem.price;
            var quantity = foodMenuItem.quantity;
            var amount = parseFloat(price) * parseFloat(quantity);
            totalAmount += amount;
        }
        $("#totalAmount").html(totalAmount.toFixed(2).toString());
    }

    function viewDetail(itemCode){
        var tableNo = $("#hfTableNo").val(); 
        window.location.href = "food_view.aspx?itemcode=" + itemCode + "&tableno=" + tableNo;
        event.stopPropagation();  //阻止事件冒泡，避免行被选中；
    }    

    function reTakeFood(){
        getStorage().removeItem(getTableMenuKey());
        window.location.reload();
    }

    function cancel(){
        getStorage().removeItem(getTableMenuKey());
        goHome('1');
    }

    function showMakedFoodMenu(tableNo){
        window.location.href = "customer_order_create_takenfood.aspx";
    }
    
    function getTableMenuKey() {
        var tableNo = $("#hfTableNo").val();
        var key = "TableMenu_" + tableNo;
        return key;
    }

    function getStorage() {
        return window.localStorage;
    }

</script>    
</head>
<body>
<form id="Form1" method="post" runat="server">


<div id="pageWrapper">    

    <div id="headerBar">
        <h1>自助点菜(<% = base.tableNo %> 号台)</h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:goHome('1');" class="icon home"></a>
        </div>  
    </div> 
    
    <div id="toolBar">   
        <a href="#" class="jtongui-toolbarbutton" icon="icon-search" menu="menu_foodCategories">分类</a>    
        <div id="menu_foodCategories" class="jtongui-toolbarbutton-menu">
            <asp:Repeater ID="rpFoodCategories" Runat="server" EnableViewState="False"  >    
            <ItemTemplate>
            <a href="?act=continue&tableno=<% = base.tableNo %>&category=<%# Eval("Category_Code")%>&itemtype=<%# Eval("Item_Type")%>"><%# Eval("Category_Name")%></a>
            </ItemTemplate>            
            </asp:Repeater>    
        </div>            
        <a runat="server" id="categoryName" class="jtongui-toolbarbutton categoryName"></a>       
        <a href="javascript:reTakeFood()" class="jtongui-toolbarbutton" icon="icon-redo">清空重点</a>    
        <a href="javascript:cancel()" class="jtongui-toolbarbutton" icon="icon-undo">放弃</a>                    
        <%--<a href="javascript:showMakedFoodMenu('<% = base.tableNo %>')" class="jtongui-toolbarbutton">已点菜单(<span id="spanFoodKindQuantity">0</span>)</a>        
        <a href="#" class="jtongui-toolbarbutton" menu="menu_moreAct">更多操作</a>
        <div id="menu_moreAct" class="jtongui-toolbarbutton-menu">            
            <a href="javascript:reTakeFood()" icon="icon-clear">清空重点</a>            
            <a href="javascript:cancel()" icon="icon-clear">放弃</a>            
        </div>  --%>                             
    </div><!--toolBar.END-->  
                  
    <div id="dataBar" style="margin-top:0px;">

    <!--MainList.Start-->    
    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <table id="tableBody" cellpadding="3" cellspacing="0" class="listTable" style="margin-top:-1px;">
    <thead>
    <tr>
        <td style="text-align:center;">菜名</td>        	         	  	       	    
        <td style="width:30px;text-align:center;">数量</td>
        <td style="width:40px;text-align:left;">操作</td>
    </tr>    
    </thead>
    </HeaderTemplate>
    <ItemTemplate>
    <tr id="tr_<%# Container.ItemIndex%>" onclick="trClick_handler(this)">
        <td align="left" class="td_itemName">
            <% if (base.ItemType == VA.Modules.JDingCYT.Core.Enums.ChargeItemType.Food.ToString("d")) { %>
                <div class="item">
                    <div class="itemPic">
                        <a onclick="viewDetail('<%# Eval("Item_Code")%>');"><%# ShowItemImage(Eval("Image").ToString().Trim(), "80", "60")%></a>
                        <a name="<%# ShowLetterIndex(Eval("Input_Code").ToString())%>"></a>
                    </div>
                    <div class="itemDesc">
                        <h1 class="itemName" data-indexer="<%# ShowLetterIndex(Eval("Input_Code").ToString())%>"><%# Eval("Item_Name")%></h1>
                        <p><%# ShowStars(Convert.ToInt32(Eval("Stars"))) %>
                        <p><%# Convert.ToDecimal(Eval("Price")).ToString("F2")%></p>
                    </div>
                </div>    
            <% } else { %>                   
                <a name="<%# ShowLetterIndex(Eval("Input_Code").ToString())%>"></a> 
                <h1 class="itemName" data-indexer="<%# ShowLetterIndex(Eval("Input_Code").ToString())%>"><%# Eval("Item_Name")%> <%# Convert.ToDecimal(Eval("Price")).ToString("F2")%>/<%# Eval("Unit")%></h1>             
            <% } %>
        </td>         
        <td align="center"><input type="text" class="textbox" value="0" name="txtQuantity" id="txtQuantity_<%# Container.ItemIndex%>" /></td>
        <td align="left">
            <input type="hidden" name="hfItemType" id="hfItemType_<%# Container.ItemIndex%>" value="<%# Eval("Item_Type")%>" />
            <input type="hidden" name="hfItemCategory" id="hfItemCategory_<%# Container.ItemIndex%>" value="<%# Eval("Category_Code")%>" />
            <input type="hidden" name="hfItemCode" id="hfItemCode_<%# Container.ItemIndex%>" value="<%# Eval("Item_Code")%>" />
            <input type="hidden" name="hfItemName" id="hfItemName_<%# Container.ItemIndex%>" value="<%# Eval("Item_Name")%>" />
            <input type="hidden" name="hfUnit" id="hfUnit_<%# Container.ItemIndex%>" value="<%# Eval("Unit")%>" />
            <input type="hidden" name="hfPrice" id="hfPrice_<%# Container.ItemIndex%>" value="<%# Eval("Price")%>" />

            <input type="button" value="+" onclick="takeFood('+', <%# Container.ItemIndex%>);" class="oprBtn" />
            <input type="button" value="-" onclick="takeFood('-', <%# Container.ItemIndex%>);" class="oprBtn" />
        </td>  
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->
    
    <!--MainList.End-->  

    </div><!--dataBar.END-->
    
    <div id="bottomToolBar" style="margin-top:0px;">
        <div style="padding-top:0px;text-align:right;padding-right:5px;position:relative;border:0px solid red;">
            <div style="position:absolute;left:5px;top:3px;">已点菜品(<span id="spanFoodKindQuantity">0</span>),金额(<span id="totalAmount">0.00</span>)</div>
            <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="showMakedFoodMenu('<% = base.tableNo %>');" value="选好了" />
        </div>
    </div>

    <!--#include virtual="../footer_customer.aspx"-->

    <asp:HiddenField ID="hfTableNo" runat="server" />
    <asp:HiddenField ID="hfItemCategory" runat="server" />
    <asp:HiddenField ID="hfItemType" runat="server" />
    
</div>

<div id="indexPanel">
    <ul id="letterIndexer" class="letterIndexer">             
        <li>A</li>
        <li>B</li>
        <li>C</li>
        <li>D</li>
        <li>E</li>
        <li>F</li>
        <li>G</li>
        <li>H</li>
        <%-- <li>I</li>--%>
        <li>J</li>
        <li>K</li>
        <li>L</li>
        <li>M</li>
        <li>N</li>
        <li>O</li>
        <li>P</li>
        <li>Q</li>
        <%-- <li>R</li>--%>
        <li>S</li>
        <li>T</li>
        <%-- <li>U</li>
        <li>V</li>--%>
        <li>W</li>
        <li>X</li>
        <li>Y</li>
        <li>Z</li>     
    </ul>
</div>

</form>
</body>
</html> 