﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="customer_comment.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.mainbiz.customer_comment" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/edit.aspx"-->
<link href="/uicontrols/jtongui_mobile/themes/default/toolbarbutton.css" type="text/css" rel="Stylesheet" />
<link href="/uicontrols/jtongui_mobile/themes/icon.css" type="text/css" rel="Stylesheet" />
<!--#include virtual="../include/js/edit.aspx"--> 
<script type="text/javascript" src="/uicontrols/jtongui_mobile/plugins/jtong.toolbarbutton.js"></script>
<script type="text/javascript">    

    onPageInited = function () {
        JTongToolBarButton_init();
    }

    function save() {

        var mobileNo = $("#txtMobileNo").val().trim();
        if (mobileNo != "") {
            var validator = new DataValidator();
            if (!validator.isMobile(mobileNo)) {
                JTongAlert("提示", "手机号格式错误！", "info", function () {
                    $("#txtMobileNo").select();
                });
                return;
            }
        }

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {            
            if (data == "ok") {
                showActResult("评论提交成功，感谢您的参与！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("评论提交失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult, bizNo) {
        if (actResult) {
            window.location.href = "customer_order_view.aspx";
        }
    }

</script>

<script type="text/javascript">

    function addRowByOrder(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag) {
        formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag);
    }

    var formEditListTable_RowCounter = 0;
    function formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag) {
            
        formEditListTable_RowCounter++;

        var $srcTable = $("#srcTable");
        var srcTableID = $srcTable.attr("id");

        //不要合并数量；
        ////如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
        //if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
        //    return;
        //}

        var rowHtml = '';
        var $row = null;
        var rowCnt = $srcTable[0].rows.length;
        var rowID = formEditListTable_RowCounter;

        itemName = itemName.replace(/'/g, "‘");
        unit = unit.replace(/'/g, "‘");
                        
        var amount = (price * quantity).toFixed(2).toString(); //优惠前金额
            
        rowHtml += '<tr id="tr_' + rowID + '">';
        
        rowHtml += '<td style="text-align:left;padding-left:5px;">';
        rowHtml += '<span>' + itemName + '</span>';
        rowHtml += '<span>' + price + '</span>';
        rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
        rowHtml += '<input type="hidden" name="hfItemCategory" value="' + itemCategory + '" />';
        rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
        rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" id="hfItemCode_'+ rowID +'" />';
        rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
        rowHtml += '<input type="hidden" name="hfPrice" value="' + price + '" id="hfPrice_' + rowID + '" />';
        rowHtml += '<input type="hidden" name="hfQuantity" value="' + quantity + '" id="hfQuantity_' + rowID + '" />';
        rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
        rowHtml += '</td>';
    
        rowHtml += '<td style="text-align:center;">';
        rowHtml += '<select name="ddlQuality" id="ddlQuality_' + rowID + '"><option value="1" selected="selected">很好</option><option value="2">一般</option><option value="3">较差</option></select>';
        rowHtml += '</td>';

        rowHtml += '<td style="text-align:center;">';
        rowHtml += '<select name="ddlPrice" id="ddlPrice_' + rowID + '"><option value="1" selected="selected">实惠</option><option value="2">一般</option><option value="3">偏高</option></select>';
        rowHtml += '</td>';

        rowHtml += '<td style="text-align:center;">';
        rowHtml += '<select name="ddlFenliang" id="ddlFenliang_' + rowID + '"><option value="1" selected="selected">充足</option><option value="2">一般</option><option value="3">偏少</option></select>';
        rowHtml += '</td>';

        rowHtml += '</tr>';

        $row = $(rowHtml);
        $srcTable.append($row);

        formEditListTable_setRowNo();
        formEditListTable_setTotalAmount();
        formEditListTable_hideTbNoRecord();
    }

    function formEditListTable_setTotalAmount() {
        var $srcTable = $("#srcTable");
        $srcTable.find("#trTotal").remove();

        var totalRowHtml = '';
        var totalAmount = 0.00;
        //var $hfAmountList = $srcTable.find("input[name=hfAmount]");
        var dataRows = $srcTable.find("tr[id]");

        dataRows.each(function () {
            var $hfAmount = $(this).find("input[name=hfAmount]").eq(0);
            var donateFlag = $(this).find("input[name=hfDonateFlag]").eq(0);

            if (donateFlag == "0") { //如果不是赠送的
                totalAmount += parseFloat($hfAmount.val());
            }
        });

        //$hfAmountList.each(function () {
        //    totalAmount += parseFloat($(this).val());
        //});

        //if ($hfAmountList.length > 0) {  //如果有数据行，则添加合计行
        if (dataRows.length > 0) {  //如果有数据行，则添加合计行     
            $("#hfTotalAmount").val(totalAmount.toFixed(2).toString());
            $("#spanTotalAmount").html(totalAmount.toFixed(2).toString());
        } else {
            $("#hfTotalAmount").val("0.00");
            $("#spanTotalAmount").html("0.00");
        }
    }

    function formEditListTable_caculateAmount(rowID) {
        var $txtQuantity = $("#txtQuantity_" + rowID);
        var $txtPrice = $("#hfPrice_" + rowID);
        var $spanDiscount = "";
        var sQuantity = $txtQuantity.val();
        var sPrice = $txtPrice.val();
        var amount = 0.00; //优惠前

        if (sQuantity == "") {
            sQuantity = "0";
        }
        if (sPrice == "") {
            sPrice = "0";
        }
 
        ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
        //clearNoNum($txtQuantity[0]);
        //clearNoNum($txtPrice[0]);

        if (isNaN(sQuantity)) {
            alert("数量为无效数字！");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (isNaN(sPrice)) {
            alert("单价为无效数字.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }          
        if (parseFloat(sQuantity) > 100000 || parseFloat(sQuantity) <0) {  //限制数量不能超过100000
            alert("数量不能小于0或超过100000.");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (parseFloat(sPrice) > 100000 || parseFloat(sPrice) < 0) {  //单价不能超过100000
            alert("单价不能小于0或超过100000.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }

        if ($txtQuantity.hasClass("error")) {
            $txtQuantity.removeClass("error");
        }
        if ($txtPrice.hasClass("error")) {
            $txtPrice.removeClass("error");
        }

        amount = parseFloat(sQuantity) * parseFloat(sPrice);
            
        $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());
        $("#spanAmount_" + rowID).html(amount.toFixed(2).toString());

        formEditListTable_setTotalAmount();
    }

    </script>

<style type="text/css">
.textbox {
    width:30px;
    text-align:center;
}
.bottomBar {
    margin-top:-1px;
    padding:5px;
    text-align:center;
}
.editTable .th{
    width:80px;
}
</style>

</head>
<body>

<form id="Form1" method="post" runat="server">

<div id="pageWrapper">    

    <div id="headerBar">
        <h1>点评(<% = base.tableNo %> 号台)</h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:goHome('1');" class="icon home"></a>
        </div>  
    </div> 

    <div id="noteBar">   
        <p>您的参与 -- 我们的动力！</p>
    </div><!--toolBar.END-->  

    <div id="noteBar2" style="height:20px;line-height:20px;font-size:12px;padding:3px;background-color:#f5f5f5">  
        <p>注：1）菜单经过确认后方可进行评论 2）每个餐台只能评论一次。</p>
    </div>

    <div id="dataBar">
        <table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:0px;">
        <thead>
        <tr>
            <td style="text-align:center;">菜名</td>        	         	  	       	    
            <td style="width:50px;text-align:center;">味道</td>
            <td style="width:50px;text-align:center;">价格</td>
            <td style="width:60px;text-align:center;">份量</td>
        </tr>        
        </thead>
        </table>           

        <table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">       
        <tr>
        <td class="th">服务质量：</td>
        <td>
            <input type="radio" checked="checked" name="rdService" value="1" id="rdService_1" /><label for="rdService_1">很好</label>
            <input type="radio" name="rdService" value="2" id="rdService_2" /><label for="rdService_2">一般</label>
            <input type="radio" name="rdService" value="3" id="rdService_3" /><label for="rdService_3">较差</label>

            <%--<select name="ddlService" id="ddlService"><option value="1" selected="selected">很好</option><option value="2">一般</option><option value="3">较差</option></select>--%>
        </td>
        </tr>
        <tr>
        <td class="th">候餐时间：</td>
        <td>
            <input type="radio" checked="checked" name="rdWaittime" value="1" id="rdWaittime_1" /><label for="rdWaittime_1">较短</label>
            <input type="radio" name="rdWaittime" value="2" id="rdWaittime_2" /><label for="rdWaittime_2">一般</label>
            <input type="radio" name="rdWaittime" value="3" id="rdWaittime_3" /><label for="rdWaittime_3">较长</label>

            <%--<select name="ddlWaittime" id="ddlWaittime"><option value="1" selected="selected">较短</option><option value="2">一般</option><option value="3">较长</option></select>--%>
        </td>
        </tr>
        <tr>
        <td class="th">综合评分：</td>
        <td>
            <select name="ddlScore" id="ddlScore">
                <option value="5">5分 ★★★★★</option>
                <option value="3">3分 ★★★</option>
                <option value="1">1分 ★</option>
            </select>
        </td>
        </tr>
        <tr>
        <td class="th">评论内容：</td>
        <td><textarea name="txtCommentContent" id="txtCommentContent" maxlength="100" style="width:98%;height:50px;"></textarea></td>
        </tr>
         <tr>
        <td class="th">您的姓名：</td>
        <td>        
            <input type="text" name="txtCustomerName" id="txtCustomerName" maxlength="10" class="input" placeHolder="选填" />
        </td>
        </tr>
        <tr>
        <td class="th">您的手机：</td>
        <td>
            <input type="tel" name="txtMobileNo" id="txtMobileNo" maxlength="11" class="input" placeHolder="选填" value="<% = base.mobileNo %>" />
        </td>
        </tr>
        </table>
        
    </div><!--dataBar.END-->    

    <div id="bottomToolBar" style="margin-top:0px;">
        <% if (base.commentInfo != null && !String.IsNullOrEmpty(base.commentInfo.Order_No)) {%>
            <p style="color:red;font-weight:bold;line-height:28px;">本台客人已经提交过评论</p>
        <% } else { %>
            <% if (base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.NewOrder.ToString("d")) {%>
            <p style="color:red;font-weight:bold;line-height:28px;">菜单尚未经过确认，请确认后再评论</p>
            <% } else { %>
            <input type="button" id="btnSubmit" class="btn" style="min-width:80px" onclick="save()" value="提交评论" />
            <% } %>
        <% } %>
    </div>    

    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfOrderSequenceNo" runat="server" />
    <asp:HiddenField ID="hfTableNo" runat="server" />

    
</div>

<% if (base.orderInfo != null){ %>
<%
    
    Response.Write("<script type=\"text/javascript\">");       
    Response.Write("var itemList = [");       
       
    var i = 0;       
    foreach (VA.Modules.JDingCYT.Core.Model.MainBiz.OrderItemInfo item in base.orderInfo.OrderItems)
    {
        string itemType = item.Item_Type;
        string itemCategory = item.Item_Category;
        string itemCode = item.Item_Code;
        string itemName = item.Item_Name;
        string unit = item.Unit;
        string price = item.Price.ToString("F2");        
        string quantity = item.Quantity.ToString();
        string zuofa = item.Zuofa.Replace(",","，").Replace("\"","“").Replace("\'","‘");
        string donateFlag = item.Donate_Flag;
        string bizStatus = item.Biz_Status;

        Response.Write("{");
        Response.Write("\"itemType\":\"" + itemType + "\",\"itemCategory\":\"" + itemCategory + "\",\"itemName\":\"" + itemName + "\",\"itemCode\":\"" + itemCode + "\",\"unit\":\"" + unit + "\",\"price\":\"" + price + "\",\"quantity\":\"" + quantity + "\",\"zuofa\":\"" + zuofa + "\",\"donateFlag\":\"" + donateFlag + "\",\"bizStatus\":\"" + bizStatus + "\"");

        if (i == base.orderInfo.OrderItems.Count - 1)
            Response.Write("}");
        else
            Response.Write("},");
        
        i++;
    }

    Response.Write("];");      
    Response.Write("</script>");        
%>

<script type="text/javascript">
    var originalFlag = "1";
    for (var i = 0; i < itemList.length; i++) {
        addRowByOrder(
        itemList[i].itemType,
        itemList[i].itemCategory,
        itemList[i].itemCode,
        itemList[i].itemName,
        itemList[i].unit,
        itemList[i].price,
        itemList[i].quantity,
        itemList[i].donateFlag);
    }
    $("#spanFoodKindQuantity").html(itemList.length);
</script>

<% } %>

</form>
</body>
</html> 