using System;
using System.Xml;
using System.Collections;
using System.Configuration;

using VA.Modules.JDingCYT.Core.Config;

namespace VA.Modules.JDingCYT.WebBase
{
    /// <summary>
    /// BasePage ժҪ˵
    /// </summary>
    public class BasePage_Admin : BasePage
    {
        
        /***Ȩϵͳֶ.BEGIN****/

        bool isAdministrator;    //ûɫǷΪϵͳóԱ(administrators)
        bool canAccessThisPage;  //ǷԷʸҳ棻
        bool isCommonPage;       //ǷΪҳ棨ҲǲҪκ֤ɷʵҳ棩

        string userID = "administrator";           //û磺zhangsan
        string userRoleString = "";
        string employeeID = "0000";       //룬  磺001
        string employeeName = "ϵͳԱ";     //,
        string shopCode = "001";
        string shopName = "ܵ";


        /***Ȩϵͳֶ.END****/

        protected bool IsAdministrator
        {
            get { return isAdministrator; }
        }

        protected bool CanAccessThisPage
        {
            get { return canAccessThisPage; }
        }

        protected bool IsCommonPage
        {
            get { return isCommonPage; }
        }

        protected string UserID
        {
            get { return userID; }
        }

        protected string EmployeeID
        {
            get { return employeeID; }
        }

        protected string EmployeeName
        {
            get { return employeeName; }
        }

        protected string ShopCode
        {
            get { return shopCode; }
        }

        protected string ShopName
        {
            get { return shopName; }
        }

        #region OnInit

        protected override void OnInit(System.EventArgs e)
        {
            if (VA.Modules.JDingCYT.Core.SystemInfo.RunMode.CurrentRunMode == VA.Modules.JDingCYT.Core.SystemInfo.RunMode.Released)
            {
                //Ƿ¼¼ȡûɫԱţ
                if (!Chaokers.CN.SysMembership.API.Passport.Authenticate(ref userID, ref employeeID, ref userRoleString))
                {
                    Response.Redirect(this.ApplicationPath + "/modules/cytmobile/login.aspx");
                }

                //ǷзʸҳȨޣûУֹҳִУУȡ isAdministratorisCommonPage ֵ
                if (!Chaokers.CN.SysMembership.API.Privilege.HasAccessPrivilege(Chaokers.CN.SysMembership.API.Passport.AuthType.Cookie, userID, ref isAdministrator, ref isCommonPage))
                {
                    Response.Write("ûзʸҳȨޣ");
                    Response.End();
                }
            }

            //ˣ˵϶жԸҳķȨޣͨcanAccessThisPageǣ
            this.canAccessThisPage = true;

            //-------------------------------------------------------------------------------------------

            if (VA.Modules.JDingCYT.Core.SystemInfo.RunMode.CurrentRunMode == VA.Modules.JDingCYT.Core.SystemInfo.RunMode.Released)
            {
                VA.Modules.JDingCYT.Core.Model.Basic.EmployeeInfo employeeInfo = new VA.Modules.JDingCYT.Core.Business.Basic.Employee().GetEntity(employeeID);
                if (employeeInfo == null || String.IsNullOrEmpty(employeeInfo.Employee_Code))
                {
                    Response.Write("˻޶ӦԱţ¼ϵͳ");
                    Response.End();
                }

                this.employeeName = employeeInfo.Employee_Name;
                this.shopCode = employeeInfo.Shop_Code;
                this.shopName = new VA.Modules.JDingCYT.Core.Business.Basic.ShopDict().GetEntity(this.shopCode).Shop_Name;
            }

            base.OnInit(e);
        }

        #endregion 
              
    }
}
