﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="voucher_allocate.aspx.cs" Inherits="VA.Modules.JDingCYT.voucher.voucher_allocate" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>分配代金券</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->  
    <script type="text/javascript">
    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        var shopCode = $("#txtShop_hiddenValue").val();
        if (shopCode == "" || shopCode == "-9999") {
            JTongAlert("提示", "领取门店不能为空且只能从列表中选择！", "warning");
            return;
        }

        JTongAlertConfirm("确定要分配吗？ <br /><br />请确认填写信息无误！", add);
    }

    function add() {

        $("#btnSubmit").attr("disabled", "disabled");

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {

            var sucCnt = "0";
            if (data.substring(0, 2) == "ok") {
                sucCnt = data.split("|")[1];
                showActResult("分配完毕！共分配成功代金券 "+ sucCnt +" 张", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("分配失败：" + data, false, doAfterAdd);
            }

            $("#btnSubmit").removeAttr("disabled");
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            try{
                if (window.parent != window.self) {
                    window.parent.completeReload();
                }
            }catch(e){}
            resetPage();
        }
    }

    function resetPage() {

        $("#txtBeginNumber").val("");
        $("#txtEndNumber").val("");

        clearInputValidatorError();

        $("#txtBeginNumber").focus();
    }

    $(function () {
        $("#txtBeginNumber").select();

        //焦点控制
        $("input,select").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;
                switch (targetID) {                   
                    case "txtBeginNumber":
                        $("#txtEndNumber").select();
                        break;
                    case "txtEndNumber":
                        $("#txtShop").focus();
                        break;
                    default:
                        break;
                }
            }
        });
    });

    </script>

    <style type="text/css">  
    .editTable .th{
        width:140px;
    }
    </style>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:690px;">

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">分配代金券</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr>
<td class="th">代金券名称：</td>
<td>              
    <% = base.voucherInfo.Voucher_Name %>       
</td>
</tr>
<tr>
<td class="th">代金券面值：</td>
<td>
    <% = base.voucherInfo.Face_Value.ToString("F2") %>       
</td>
</tr>
<tr>
<td class="th">每日限使用次数：</td>
<td>
     <% = base.voucherInfo.Limit_MaxUseTimes_PerDay == 0 ? "不限" : base.voucherInfo.Limit_MaxUseTimes_PerDay.ToString() %>
</td>
</tr>
<tr>
<td class="th">最低消费金额：</td>
<td>
     <% = base.voucherInfo.Limit_MinConsumeAmount_PerBill == 0 ? "不限" : base.voucherInfo.Limit_MinConsumeAmount_PerBill.ToString("F2") %>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)分配号段：</td>
<td>
     <VACTL:TextBox runat="server" ID="txtBeginNumber" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="起始号码"
            RequiredFieldType="PositiveInteger"
            Text="0"
            />

    至

    <VACTL:TextBox runat="server" ID="txtEndNumber" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="终止号码"
            RequiredFieldType="PositiveInteger"
            Text="0"
            />

</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)领取门店：</td>
<td>
     <VACTL:TextBox runat="server" ID="txtShop" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_shops.aspx',true,true,300,200);"
            />
    <asp:HiddenField runat="server" id="txtShop_hiddenValue" />
</td>
</tr>
<tr>
<td colspan="2" class="footer">

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="分配" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="重置" />
    <asp:HiddenField ID="hfKey" runat="server" />

    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    <span id="spanNote"></span>
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</form>
</body>
</html>

