﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sms_send_takemember.aspx.cs" Inherits="VA.Modules.JDingCYT.sms.sms_send_takemember" %>

<%@ Import Namespace="System.Data"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>短信发送-选择会员</title>    
    <!--#include virtual="/modules/cyt/include/css/editlist.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/editlist.aspx"-->  
    <script type="text/javascript">

        var $hiddenMemberIDStorage = null;
        var memberIDArray = new Array();
        
        //选择全部记录
        function selectAllRecords(){
            var requestType = "GET";
            var url = pageName + "?act=get";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();
            var successFN = function (data, textStatus) {
                if (data.indexOf("01|") != -1) {
                    showActResult(data, false);
                }
                else {
                    $hiddenMemberIDStorage.val(data);
                    memberIDArray = data.split(',');
                    //alert(memberIDArray.length);
                    selectRows();
                }
            };
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        }

        //根据memberIDArray数组的值来选中行；
        function selectRows() {
            var $dataTable = $("#tablebody");
            var $dataRows = $dataTable.find("tr");
            $dataRows.each(function () {
                var checkboxObj = $(this).find(":checkbox")[0];
                var memberID = this.cells[2].innerHTML;
                if (memberIDArray.indexOf(memberID) != -1) {
                    smartListTable_selectTR(true, $(this));
                    checkboxObj.checked = true;
                }
            });
        }

        //选择当页记录
        function selectCurrentPageRecords() {
            var tableID = "tb1_header";
            smartListTable_selectAll(tableID, true);
        }

        //列表页数据加载完毕后会自动调用该函数；
        function afterDataListLoaded() {
            selectRows();
        }
        
        function JTongSmartListTable_afterSelect(trObj) {
            var memberID = trObj.cells[2].innerHTML;            
            addMember(memberID);
        }

        function JTongSmartListTable_afterCancelSelect(trObj) {
            var memberID = trObj.cells[2].innerHTML;
            removeMember(memberID);
        }

        function addMember(memberID) {
            if (memberID == "会员ID") {
                return;
            }
            if (memberIDArray.indexOf(memberID) == -1) {
                memberIDArray.push(memberID);
                saveMemberIDString();
            } 
        }

        function removeMember(memberID) {
            var index = memberIDArray.indexOf(memberID);
            if (index != -1) {
                memberIDArray.splice(index, 1);
                saveMemberIDString();
            }
        }

        function saveMemberIDString() {
            var memberIDString = memberIDArray.join(",");
            $hiddenMemberIDStorage.val(memberIDString);
        }

        function ok() {
            var memberIDString = memberIDArray.join(",");
            $hiddenMemberIDStorage.val(memberIDString);

            var requestType = "POST";
            var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = { memberIDString: memberIDString };
            var successFN = function (data, textStatus) {
                if (data == "ok") {
                    showActResult("添加成功！", true);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data, false);
                }
                else {
                    showActResult("添加失败：" + data, false);
                }
            };
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        }

        function showActResult(actDesc, actResult) {
            if (actResult) {
                $.messager.alert('操作结果', actDesc, 'info', function () {
                    try {
                        if (window.parent != window.self) {
                            window.parent.closeFrameWindow();
                            window.parent.refresh();
                        }
                    } catch (e) { }
                });
            } else {
                $.messager.alert('操作结果', actDesc, 'warning')
            }
        }

        function cancel() {
            window.parent.closeFrameWindow();
        }

        $(function(){                   
            initListPage();
            $hiddenMemberIDStorage = $("#hiddenMemberIDStorage");
        });
    </script>

</head>
<body>
<!--说明：该页面是以 employee_editlist_nofresh_5.aspx 为原型封装的结果-->
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper">    

    <div id="toolBar">
        <a href="javascript:selectAllRecords()" class="jtongui-toolbarbutton" icon="icon-add">选择全部记录</a>
        <a href="javascript:selectCurrentPageRecords()" class="jtongui-toolbarbutton" icon="icon-add">选择本页记录</a>
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>

    </div>
    <!--toolBar.END-->

    <div id="noteBar">
        <p>说明：充值时赠送的金额不计入累计充值。</p>
    </div>
                     
    <div id="searchBar">
    
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>

        <asp:DropDownList ID="ddlMemberStatus" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlMemberStatus_SelectedIndexChanged">           
        </asp:DropDownList>                           
        <asp:DropDownList ID="ddlMemberLevel" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlMemberLevel_SelectedIndexChanged">           
        </asp:DropDownList>
            
        <asp:DropDownList ID="ddlSearchField" runat="server" EnableViewState="false">
        <asp:ListItem Value="">检索字段</asp:ListItem>
        <asp:ListItem Value="1">会员卡号</asp:ListItem>
        <asp:ListItem Value="2">手机号</asp:ListItem>
        <asp:ListItem Value="3">姓名</asp:ListItem>
        <asp:ListItem Value="4">会员ID</asp:ListItem>
        <asp:ListItem Value="5">会员生日</asp:ListItem>
        <asp:ListItem Value="6">办卡人</asp:ListItem>
        <asp:ListItem Value="7">推荐人ID</asp:ListItem>
        <asp:ListItem Value="8">客户经理</asp:ListItem>
<%--        <asp:ListItem Value="9">办卡门店</asp:ListItem> --%>
        </asp:DropDownList>               
                 
        <%--<asp:DropDownList ID="ddlSearchType" runat="server" EnableViewState="false">
        <asp:ListItem Value="1">模糊匹配</asp:ListItem>
        <asp:ListItem Value="2">精确匹配</asp:ListItem>
        </asp:DropDownList>               --%>

        <asp:TextBox ID="txtKeyWords" runat="server"
            CssClass="input keywords"
            Width="100px" />
   
        <asp:DropDownList ID="ddlDateRule" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">办卡日期</asp:ListItem>
        <asp:ListItem Value="1">今天</asp:ListItem>
            <asp:ListItem Value="2">昨天</asp:ListItem>
            <asp:ListItem Value="3">前天</asp:ListItem>
            <asp:ListItem Value="4">近两天</asp:ListItem>
            <asp:ListItem Value="5">近三天</asp:ListItem>
            <asp:ListItem Value="6">近一周</asp:ListItem>
            <asp:ListItem Value="7">近一月</asp:ListItem>
            <asp:ListItem Value="8">上月</asp:ListItem>
            <asp:ListItem Value="9">本月</asp:ListItem>
            <asp:ListItem Value="10">自定义</asp:ListItem>
        </asp:DropDownList>    

        <VACTL:TextBox ID="txtBeginDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />  
        -      
        <VACTL:TextBox ID="txtEndDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />       

        <asp:DropDownList ID="ddlAccountBalanceOperator" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">账户余额</asp:ListItem>
        <asp:ListItem Value="<"><</asp:ListItem>
        <asp:ListItem Value="<="><=</asp:ListItem>
        <asp:ListItem Value="=">=</asp:ListItem>
        <asp:ListItem Value=">">></asp:ListItem>
        <asp:ListItem Value=">=">>=</asp:ListItem>
        </asp:DropDownList>  
        <VACTL:TextBox ID="txtAccountBalance" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="40px"            
            MaxLength="10"
            RequiredFieldType="Money" />  

        <asp:DropDownList ID="ddlPointOperator" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">剩余积分</asp:ListItem>
        <asp:ListItem Value="<"><</asp:ListItem>
        <asp:ListItem Value="<="><=</asp:ListItem>
        <asp:ListItem Value="=">=</asp:ListItem>
        <asp:ListItem Value=">">></asp:ListItem>
        <asp:ListItem Value=">=">>=</asp:ListItem>
        </asp:DropDownList>  
        <VACTL:TextBox ID="txtPoints" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="40px"            
            MaxLength="10"
            RequiredFieldType="Integer" /> 

        <asp:DropDownList ID="ddlOrderBy" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlOrderBy_SelectedIndexChanged">
        <asp:ListItem Value="">排序规则</asp:ListItem>
        <asp:ListItem Value="MemberID|ASC">按建卡顺序-正序</asp:ListItem>
        <asp:ListItem Value="MemberID|DESC">按建卡顺序-倒序</asp:ListItem>
        <asp:ListItem Value="Account_Balance|DESC">按账户余额-由多到少</asp:ListItem>
        <asp:ListItem Value="Account_Balance|ASC">按账户余额-由少到多</asp:ListItem>
        <asp:ListItem Value="Account_Points|DESC">按剩余积分-由多到少</asp:ListItem>
        <asp:ListItem Value="Account_Points|ASC">按剩余积分-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_Charge_Amount|DESC">按累计充值-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_Charge_Amount|ASC">按累计充值-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_Withdraw_Amount|DESC">按累计提现-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_Withdraw_Amount|ASC">按累计提现-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_Consume_Amount|DESC">按累计消费-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_Consume_Amount|ASC">按累计消费-由少到多</asp:ListItem>
       <%-- <asp:ListItem Value="Total_PointCardCharge_Amount|DESC">按累计充次-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_PointCardCharge_Amount|ASC">按累计充次-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_PointCardConsume_Amount|DESC">按累计划次-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_PointCardConsume_Amount|ASC">按累计划次-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_BeDonated_Amount|DESC">按累计受赠-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_BeDonated_Amount|ASC">按累计受赠-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_DonatedConsume_Amount|DESC">按赠品划次-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_DonatedConsume_Amount|ASC">按赠品划次-由少到多</asp:ListItem>--%>
        </asp:DropDownList>             
         
        <asp:Button ID="btnSearch" runat="server" 
             CssClass="simpleBtn"
             Text="查询" 
             Onclick="btnSearch_Click" />
        
        </ContentTemplate>
        </asp:UpdatePanel>

    </div><!--searchBar.END-->      

    <div id="dataBar">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <td style="width:30px;text-align:center;"><input type="checkbox" id="ckb_selectAll"/></td>
        <td style="width:30px;text-align:center;">No.</td>
        <td style="width:70px;text-align:center;">会员ID</td>
        <td style="width:70px;text-align:center;">卡号</td>
        <td style="width:70px;text-align:center;">姓名</td>        
        <td style="width:70px;text-align:center;">手机号</td>
        <td style="width:70px;text-align:center;">出生日期</td>
        <td style="width:60px;text-align:center;">账户余额</td>
        <td style="width:60px;text-align:center;">累计充值</td>
        <td style="width:60px;text-align:center;">累计提现</td>
        <td style="width:60px;text-align:center;">累计消费</td>
<%--        <td style="width:60px;text-align:center;">累计充次</td>
        <td style="width:60px;text-align:center;">累计划次</td>
        <td style="width:60px;text-align:center;">累计受赠</td>
        <td style="width:60px;text-align:center;">赠品划次</td>--%>
        <td style="width:70px;text-align:center;">会员等级</td>	 	 
        <td style="width:70px;text-align:center;">当前积分</td>	 
        <td style="width:80px;text-align:center;">办卡时间</td>
        <td style="width:70px;text-align:center;">办卡人</td>
        <td style="width:100px;text-align:center;display:none;">办卡门店</td>
        <td style="width:70px;text-align:center;">推荐人ID</td>
        <td style="width:70px;text-align:center;">推荐人姓名</td>
	    <td style="width:70px;text-align:center;">客户经理</td>	       	    
	    <td style="width:70px;text-align:center;">会员状态</td>      
        <td></td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>    
    <table id="tablebody" cellpadding="3" cellspacing="0" class="tablebody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td style="text-align:center;"><input type="checkbox" name="ckb_dataItem" value="<%# Eval("MemberID")%>" /></td>
        <td align="center"><%# (base.currPage - 1)*base.PageSize + Container.ItemIndex + 1%></td>
        <td align="center"><%# Eval("MemberID")%></td>
        <td align="center"><%# Eval("CardNo")%></td>
        <td align="left"><%# Eval("Member_Name")%></td>
        <td align="center"><%# Eval("MobileNo")%></td>    
        <td align="center"><%# VA.Utils.DateHelper.GetDateStringFormatNullDate(String.Format("{0:yyyy-MM-dd}", Eval("BirthDate")))%></td>            
        <td align="right"><%# Convert.ToDecimal(Eval("Account_Balance")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_Charge_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_Withdraw_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_Consume_Amount")).ToString("F2")%></td>
       <%-- <td align="right"><%# Convert.ToDecimal(Eval("Total_PointCardCharge_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_PointCardConsume_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_BeDonated_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_DonatedConsume_Amount")).ToString("F2")%></td>--%>
        <td align="center"><%# Eval("Level_Name")%></td>
        <td align="center"><%# Eval("Account_Points")%></td>                
        <td align="center"><%# String.Format("{0:yyyy-MM-dd}",Eval("Create_Date"))%></td>
        <td align="left"><%# Eval("Operator_Name")%></td>
        <td align="left" style="display:none;"><%# Eval("Shop_Name")%></td>
	    <td align="center"><%# Eval("Introducer_ID")%></td>
        <td align="center"><%# Eval("Introducer_Name")%></td>
        <td align="left"><%# Eval("Salesman_Name")%></td>        
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.MemberStatusConverter.Convert_Value_ToText(Eval("Status").ToString(),true)%></td>                                    	       	     
        <td></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <div id="divPagerInfo" style="display:none">
        <%=base.pageInfo%>
    </div>

    <input type="hidden" id="hidden_pageCnt" value="<% = base.PageCnt%>" />
    <input type="hidden" id="hidden_rdCnt" value="<% = base.RdCnt%>" />
    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

    <div id="pagerBar">
       ……
    </div><!--pageNavBar.END-->

    <div id="bottomToolBar">                                          
        <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="ok()" value="添加" />
        <input type="button" id="btnCancel" class="btn" style="width:100px" onclick="cancel()" value="取消" />
    </div><!--toolBar.END-->  
    
    <asp:HiddenField runat="server" ID="hfCurrPage" EnableViewState="true" />
    
</div>


</form>
</body>
</html> 