﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sms_send_free.aspx.cs" Inherits="VA.Modules.JDingCYT.sms.sms_send_free" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>自由短信发送</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    
    <script type="text/javascript">
        function save() {

            ////调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
            //var validationResult = Page_ClientValidate('');
            //if (!validationResult) {
            //    return;
            //}

            var content = $("#txtContent").val();
            if ($.trim(content) == "") {
                JTongAlert("提示", "短息内容不能为空！", "warning");
                return false;
            }

            var sendOption = $('input:radio[name=rbnSendOption]:checked').val();
            if (sendOption == "2") { //定时发送
                var planningSendDate = $("#txtPlanningSendDate").val();
                if ($.trim(planningSendDate) == "") {
                    JTongAlert("提示", "如果选择了定时发送，则必须指定定时发送时间！", "warning");
                    return false;
                }
            }

            JTongAlertConfirm("确定发送吗？", add);
        }

        function add() {

            $("#btnSubmit").attr("disabled", "disabled");
            openDivWindow("", 300, 100, 200, 120, "divProgressNote");

            var requestType = "POST";
            var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();
            var successFN = function (data, textStatus) {
                if (data == "ok") {
                    showActResult("操作成功（短信已提交到发送队列）！", true, doAfterAdd);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, doAfterAdd);
                }
                else {
                    showActResult("操作失败：" + data, false, doAfterAdd);
                }
            };
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        }

        function doAfterAdd(actResult) {

            $("#btnSubmit").removeAttr("disabled");
            closeWindow("divProgressNote");

            if (actResult) {
                try {
                    if (window.parent != window.self) {
                        window.parent.reload();
                    }
                } catch (e) { }
                resetPage();
            }
        }
        
        function resetPage() {
            $("#txtMobileNo").val("");
            $("#txtContent").val("");
            $("#spanMemberCount").html("0");
            clearInputValidatorError();
        }

        function takeMember() {
            openFrameWindow("短信发送-编辑发送会员列表", 800, 500, "sms_send_selectedmembers.aspx", true);
        }

        function finishTakeMember(selectedMemberCount) {
            $("#spanMemberCount").html(selectedMemberCount);
            closeFrameWindow();
        }

        function takeTemplate() {
            openFrameWindow("短信发送-选择模板", 800, 500, "sms_send_taketemplate.aspx", false);
        }

        function finishTakeTemplate(templateContent) {
            $("#txtContent").val(templateContent);
            closeFrameWindow();
        }

        function statContentLength() {
            var length = $("#txtContent").val().length;
            //$("#lblContentLength").html("建议短信内容在80个汉字以内。 当前已 " + length + " 个字.");
            $("#lblContentLength").html("建议短信内容在70个汉字左右。 当前已 " + length + " 个字符.");
        }

        $.fn.pasteEvents = function (delay) {
            if (delay == undefined) delay = 20;
            return $(this).each(function () {
                var $el = $(this);
                $el.on("paste", function () {
                    $el.trigger("prepaste");
                    setTimeout(function () { $el.trigger("postpaste"); }, delay);
                });
            });
        };

        function takeContacts() {
            openFrameWindow("选择联系人", 800, 500, "sms_telbookcontact_editlist.aspx", false);
        }

        function finishTakeTelBookContacts(contacts, takeOption) {

            if ($.trim(contacts) == "") {
                closeFrameWindow();
                return;
            }
            
            if (takeOption == "1") { //覆盖
                $("#txtMobileNo").val(contacts);
            }
            else { //追加；
              
                var oldMobileNoString = $("#txtMobileNo").val().trim();
               
                if (oldMobileNoString == "") {
                    $("#txtMobileNo").val(contacts);
                }
                else {
                    var oldMobileNoArray = oldMobileNoString.split('|');
                    var newMobileNoArray = contacts.split('|');

                    var finalMobileString = oldMobileNoString;
                    for (var i = 0; i < newMobileNoArray.length; i++) {
                        var newMobileNo = newMobileNoArray[i];

                        var exists = false;
                        if (oldMobileNoArray.indexOf(newMobileNo) != -1) { //已经存在！
                            exists = true;
                            continue;
                        }
                       
                        if (!exists) {
                            finalMobileString += "|" + newMobileNo;
                        }

                        console.log(exists);
                        console.log(newMobileNo);
                        console.log(finalMobileString);
                    }

                    $("#txtMobileNo").val(finalMobileString);
                }
            }

            closeFrameWindow();
        }

        function rbnSendOption_ChangeHandler() {
            var sendOption = $('input:radio[name=rbnSendOption]:checked').val();
            if (sendOption == "1") { //立即发送
                $("#txtPlanningSendDate").attr("disabled", "disabled");
                $(".laydate-icon").hide();
            } else if (sendOption == "2") { //定时发送
                $("#txtPlanningSendDate").removeAttr("disabled");
                $(".laydate-icon").show();
            }
        }

        $(function () {

            $("#txtContent").keydown(function () {
                statContentLength();
            });

            $("#txtContent").on("postpaste", function () {
                statContentLength();
            }).pasteEvents();

            $('input:radio[name=rbnSendOption]').change(function () {
                rbnSendOption_ChangeHandler();
            });
            rbnSendOption_ChangeHandler();
        });

    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:700px;">

<%
    if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Free ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Basic)
    {
        base.ShowSoftFunctionLimitNote(VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName);
    }
%>

<div class="centerFormTitle">
   <h1>自由短信发送</h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr>
<td class="th">(<span class="note mustfill">*</span>)手 机 号：</td>
<td> 
    <VACTL:TextBox ID="txtMobileNo" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="578px"
            Height="60px"
            CanBeNull="No"
            TextMode="MultiLine"
            FieldName="手机号"
            />  
    <div style="height:1%;overflow:hidden;margin-top:2px;">
        <div style="float:left">多个手机号以“|”分割，如：1352628XXXX|1352629XXXX|1352630XXXX</div>  
        <div style="float:right"><input type="button" class="simpleBtn" value=" 号码本 " onclick="takeContacts()" /></div>      
    </div> 
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)发送目的：</td>
<td> 
    <asp:DropDownList ID="ddlSendReason" Runat="server">    
    </asp:DropDownList>
</td>
</tr>
<tr>
<td class="th" rowspan="2">(<span class="note mustfill">*</span>)短信内容：</td>
<td>              
    <VACTL:TextBox ID="txtContent" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="578px"
            Height="60px"
            CanBeNull="No"
            TextMode="MultiLine"
            FieldName="模板内容"
            MaxLength="300" />         
    <div style="height:1%;overflow:hidden;margin-top:2px;">
        <div style="float:left"><asp:Label ID="lblContentLength" runat="server"></asp:Label></div>
        <div style="float:right"><input type="button" class="simpleBtn" value=" 短信模板 " onclick="takeTemplate()" /></div>
    </div>       
</td>
</tr>
<tr>
<td>              
    变量：{ShopName}:店名
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)发送选项：</td>
<td>              
    <asp:RadioButtonList ID="rbnSendOption" runat="server"
         RepeatDirection="Horizontal"
         RepeatLayout="Flow">
        <asp:ListItem Value="1" Selected="True">立即发送</asp:ListItem>
        <asp:ListItem Value="2">定时发送</asp:ListItem>
    </asp:RadioButtonList>

    <VACTL:TextBox ID="txtPlanningSendDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="130px"
            ReadOnly="true"
            onclick="laydate({istime:true,format: 'YYYY-MM-DD hh:mm'})"
            MaxLength="20" />
    <span class="laydate-icon" onclick="laydate({elem: '#txtPlanningSendDate',istime:true,format: 'YYYY-MM-DD hh:mm'});"></span>
</td>
</tr>
<tr>
<td class="th">操作选项：</td>
<td>              
    <asp:CheckBox ID="ckbSaveTemplate" runat="server"
         Text="将短信内容存为模板" />       
</td>
</tr>
<tr>
<td colspan="2" class="footer">                        

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="发送" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="重置" />

    <script type="text/javascript">
        statContentLength();
    </script>
    
    <asp:HiddenField ID="hfKey" runat="server" />
    <input type="hidden" id="hiddenSessionID" value="<% = Session.SessionID %>" />                     
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>

</tr>
</table>

<%--<div id="divProgressNote" style="border:solid 1px #cccccc;background-color:#f5f5f5;width:300px;height:80px;text-align:center;line-height:80px;position:absolute;left:200px;top:120px;">--%>
<div id="divProgressNote" style="display:none;line-height:80px;text-align:center;">
    <span style="font-weight:bold;font-size:14px;">正在发送，请稍后……</span>
</div>

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

