﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="voucher_donate.aspx.cs" Inherits="VA.Modules.JDingCYT.sale.voucher_donate" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>代金券赠送</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

        function save() {
            
            var donateType = $("#ddlDonateType").val();
            if (donateType == "1") { //自由赠送

                if ($("#ckbIsFreeCustomer")[0].checked == false) {
                    var memberID = $("#hfMemberID").val();
                    if ($.trim(memberID) == "") {
                        JTongAlert('提示', '会员信息不能为空！', 'info');
                        return;
                    }
                }
            }
            else if (donateType == "2" || donateType == "3") {
                var bizNo = $("#txtBizNo").val();
                if ($.trim(bizNo) == "") {
                    JTongAlert('提示', '当赠送类型为‘充值赠送’或‘消费赠送’时，业务单号不能为空！', 'info');
                    return;
                }
            }

        JTongAlertConfirm("确定要赠送吗？", add);
    }

    function add() {

        $("#btnSubmit").attr("disabled", "disabled");

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            var bizNo = "";
            if (data.substring(0, 2) == "ok") {
                bizNo = data.split("|")[1];
                showActResult("赠送成功！", true, doAfterAdd, bizNo);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd, bizNo);
            }
            else {
                showActResult("赠送失败：" + data, false, doAfterAdd, bizNo);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );        
    }

    function doAfterAdd(actResult, bizNo) {
        if (actResult) {

            if ($("#ckbNotify")[0].checked == true) {
                ajaxExecute("get", "../notification/biztransaction_notify.aspx", { "biztype": "donatevoucher", "bizno": bizNo });
            }

            resetPage();
        }
    }

    //显示操作结果；
    function showActResult(sMsg, actResult, callback, bizNo) {

        $("#btnSubmit").removeAttr("disabled");

        var icon = "info";
        if (!actResult) {
            icon = "error";
        }

        JTongAlert('操作结果', sMsg, icon, function () {
            if (callback != null && callback != undefined) {
                callback(actResult, bizNo);
            }
        });
    }

    function resetPage() {

        $("#txtBizNo").val("");
        $("#txtVoucherNo").val("");
        $("#hfVoucherNo").val("");
        $("#spanVoucerName").html("");
        $("#spanVoucerFaceValue").html("");
        $("#txtRemark").val("");

        clearMemberInfo();

        $("#ddlDonateType").focus();
    }  

    function setControls() {
        
        var donateType = $("#ddlDonateType").val();
        if (donateType == "1") { //自由赠送
            $("#tr_BizNo").hide();
            $("#divMemberInfoContainer").show();
            $("#tbCustomerType").show();
        } 
        else if (donateType == "2") { //充值赠送
            $("#tr_BizNo").show();
            $("#divMemberInfoContainer").hide();
            $("#tbCustomerType").hide();
        }
        else if (donateType == "3") { //消费赠送
            $("#tr_BizNo").show();
            $("#divMemberInfoContainer").hide();
            $("#tbCustomerType").hide();
        }
    }

    function browseBizNoList() {
        var donateType = $("#ddlDonateType").val();
        if (donateType == "2" ){ //充值赠送
            browseWalletChargeList();
        }
        else if (donateType == "3") { //消费赠送
            browseMemberConsumeList();
        }
    }

    //充值记录；
    function browseWalletChargeList() {
        $('#winBizNoList').css("display", "block");
        $('#winBizNoList').window({
            width: 780,
            height: 430,
            modal: true,
            minimizable: false,
            collapsible: false,
            title: '充值记录'
        });    
        $('#winBizNoList').html("<iframe src='../datasrc/get_walletcharge_list.aspx' style='width:100%;height:100%;border:0px;margin:0px;padding:0px;'  ></iframe>");
    }
    //从弹窗窗口中获取充值业务流水号，并关闭弹出窗口
    function takeWalletChargeInfo(bizNo) {
        $("#winBizNoList").window("close", true);
        $("#txtBizNo").val(bizNo);
    }

    //消费记录；
    function browseMemberConsumeList() {
        $('#winBizNoList').css("display", "block");
        $('#winBizNoList').window({
            width: 830,
            height: 419,
            modal: true,
            minimizable: false,
            collapsible: false,
            title: '消费收银记录'
        });
        $('#winBizNoList').html("<iframe src='../datasrc/get_charge_list.aspx' style='width:100%;height:100%;border:0px;margin:0px;padding:0px;'  ></iframe>");
    }
    //从弹窗窗口中获取消费业务流水号，并关闭弹出窗口
    function takeConsumeInfo(bizNo) {
        $("#winBizNoList").window("close", true);
        $("#txtBizNo").val(bizNo);
    }

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc(memberInfo) {
      
        $("#txtVoucherNo").focus();
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {

    }

    function browseVouchers() {
        openFrameWindow("选择代金券", 600,500, "voucher_selectvoucher_step1.aspx", false);
    }

    function finishTakeVoucher(voucherNo) {
       
        var requestType = "GET";
        var url = "../datasrc/get_voucherinfo_json.aspx";
        var dataType = "json";
        var data = { "voucherno" : voucherNo };
        var successFN = function (data, textStatus) {
            if (data != "error") {
                if (data == "") {
                    alert("没有对应的代金券信息，该代金券可能已经被删除！");
                } else {
                    
                    $("#txtVoucherNo").val(data.VoucherNo);
                    $("#hfVoucherNo").val(data.VoucherNo);
                    $("#spanVoucerName").html(data.Voucher_Name);
                    $("#spanVoucerFaceValue").html(data.Face_Value);

                    closeFrameWindow();
                }
            }
            else {
                showActResult("获取代金券信息失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    $(function () {
        $("#ddlDonateType").focus();
        $("#ddlDonateType").change(function () {
            $("#txtBizNo").val("");
            setControls();
        });

        $("#ckbIsFreeCustomer").click(function () {
            var ckbIsFreeCustomer = $("#ckbIsFreeCustomer")[0];
            if (ckbIsFreeCustomer.checked) {

                clearMemberInfo();

                $("#txtKey").attr("disabled", "disabled");
                $("#ddlKeyType").attr("disabled", "disabled");
                $("#btnBrowseMembers").attr("disabled", "disabled");

                $("#ckbNotify").attr("disabled", "disabled");
                $("#ckbNotify")[0].checked = false;
            }
            else {
                $("#txtKey").removeAttr("disabled");
                $("#ddlKeyType").removeAttr("disabled");
                $("#btnBrowseMembers").removeAttr("disabled");

                $("#ckbNotify").removeAttr("disabled");
            }
        });

        setControls();
    });

    </script>
     
</head>
<body>
<form id="Form1" method="post" runat="server">
  
<div id="pageWrapper" class="pageWrapper">    

<div class="editPageWrapper" style="width:700px;float:left;">

<%
    if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Free ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Basic ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Standard)
    {
        base.ShowSoftFunctionLimitNote(VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName);
    }
%>

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">代金券赠送</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr style="display:none;">
<td class="th">(<span class="note mustfill">*</span>)赠送类型：</td>
<td>
    <asp:DropDownList ID="ddlDonateType" runat="server" EnableViewState="false">
    </asp:DropDownList>      
</td>
</tr>
<tr id="tr_BizNo">
<td class="th">(<span class="note mustfill">*</span>)业务单号：</td>
<td>
    <VACTL:TextBox ID="txtBizNo" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="150px"
            MaxLength="50" />  
    <input type="button" id="Button1" class="simpleBtn" onclick="browseBizNoList()" value="浏览" />    
</td>
</tr>
</table>

<table id="tbCustomerType" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="font-weight:bold;text-align:right;">
    <asp:CheckBox ID="ckbIsFreeCustomer" runat="server"
         Text="散客" />
</td>
</tr>
</table>

<div id="divMemberInfoContainer" style="margin-top:-1px;">
<!--#include file="../include/memberinfo.aspx"--> 
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" colspan="2" style="font-weight:bold;text-align:left;">代金券赠送信息</td>
</tr>
<tr>
<td class="th">代金券编号：</td>
<td>
     <VACTL:TextBox runat="server" ID="txtVoucherNo" 
            CssClass="input" 
            Width="130px"
            CanBeNull="No"
            FieldName="代金券编号"
            Text=""
            Enabled="false"
            />
    <input type="hidden" id="hfVoucherNo" name="hfVoucherNo" />
    <input type="button" id="btnAdd" class="simpleBtn" onclick="browseVouchers()" value="浏览" />    
</td>
</tr>
<tr>
<td class="th">代金券名称：</td>
<td>              
    <span id="spanVoucerName"></span>
</td>
</tr>
<tr>
<td class="th">代金券面值：</td>
<td>
    <span id="spanVoucerFaceValue"></span>
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">备注：</td>
<td>    
    <VACTL:TextBox ID="txtRemark" Runat="server"
        EnableViewState="False"
        CssClass="input"
        Width="561px"
        MaxLength="100"     
        />        
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <asp:CheckBox ID="ckbNotify" runat="server"
             Text="短信通知" />      

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnResetPage" class="btn" style="width:100px" onclick="resetPage()" value="重置" />    
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<!--业务记录窗口-->
<div id="winBizNoList" style="display:none;"></div> 

</form>
</body>
</html>

