﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="salestrategy_edit.aspx.cs" Inherits="VA.Modules.JDingCYT.sale.salestrategy_edit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">
        function save(flag) {

            //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
            var validationResult = Page_ClientValidate('');
            if (!validationResult) {
                return;
            }

            var sBeginDate = $("#txtBeginDate").val().replace(/-/g, "/");
            var sEndDate = $("#txtEndDate").val().replace(/-/g, "/");
            var beginDate = new Date(sBeginDate);
            var endDate = new Date(sEndDate);            
            if(Date.parse(beginDate) - Date.parse(endDate)>0)   
            {   
                JTongAlert('提示', '开始日期不能晚于截止日期!', 'info');
                return;
            }

            var limitCustomerType = $("#ddlLimitCustomerType").val();
            if (limitCustomerType == "1") { //会员
                if ($("input[name=ckbMemberLevel]:checked").length <= 0) {
                    JTongAlert('提示', '请选择要限定的会员!', 'info');
                    return;
                }                
            }

            if (flag == 0) {
                add();
            }
            else {
                update();
            }
        }

        function add() {
            $.ajax({
                type: "POST",
                url: pageName + "?act=add",
                dataType: "html",
                data: $("form").eq(0).serialize(),
                success: function (data, textStatus) {
                    var strategyCode = "";
                    if (data.substring(0, 2) == "ok") {
                        strategyCode = data.split("|")[1];

                        showActResult("添加成功！", true, strategyCode);
                        
                        $("#txtStrategyName").val("");
                        $("#txtStrategyDesc").val("");

                        clearInputValidatorError();

                    } else if (data.indexOf("01|") != -1) {
                        showActResult(data.substring(3), false, "");
                    }
                    else {
                        showActResult("添加失败：" + data, false, "");
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    showActResult("添加失败！textStatus :" + textStatus, false);
                }
            });
        }

        function update() {
            $.ajax({
                type: "POST",
                url: pageName + "?act=update",
                dataType: "html",
                data: $("form").eq(0).serialize(),
                success: function (data, textStatus) {
                    var strategyCode = $("#hfKey").val();
                    if (data == "ok") {
                        showActResult("修改成功！", true, strategyCode);
                    } else if (data.indexOf("01|") != -1) {
                        showActResult(data.substring(3), false, strategyCode);
                    }
                    else {
                        showActResult("修改失败：" + data, false, strategyCode);
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    showActResult("修改失败！textStatus :" + textStatus, false);
                }
            });
        }

        function resetPage() {
            
            $("#ddlBizType")[0].options[0].selected = true;
            $("#txtStrategyName").val("");
            $("#ddlLimitCustomerType")[0].options[0].selected = true;
            $("#txtStrategyDesc").val("");
            $("#txtBeginDate").val("");
            $("#txtEndDate").val("");

            clearInputValidatorError();
        }

        //显示操作结果；
        function showActResult(sMsg, actResult, strategyCode) {
            if (actResult) {
                window.location.href = "salestrategy_config_nav.aspx?strategycode=" + strategyCode;
            } else {
                //JTongAlert('操作结果', sMsg, 'error');
                alert(sMsg);
            }
        }

        function set_TrMemberLevel() {
            var limitCustomerType = $("#ddlLimitCustomerType").val();
            if (limitCustomerType == "1") { //会员
                $("#tr_memberLevel").show();
            } else if (limitCustomerType == "2" || limitCustomerType == "3") { //散客||全部
                $("#tr_memberLevel").hide();
            }
        }

        $(function () {
            $("#txtStrategyName").focus();
            $("#ddlLimitCustomerType").change(function () {
                set_TrMemberLevel();
            });

            set_TrMemberLevel();
        });
    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:700px;">


<%
    if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Free ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Basic ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Standard)
    {
        base.ShowSoftFunctionLimitNote(VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName);
    }
%>


<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">添加营销策略</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr id="trEditResult" runat="server" visible="false">
<td colspan="2" style="text-align:center;">
    <div class="editResult">
    <asp:Literal id="litEditResult" runat="server" />
    </div>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)策略类型：</td>
<td>
    <asp:DropDownList ID="ddlBizType" Runat="server" Width="204px" >
    <asp:ListItem Value="1" Selected="True">充值营销策略</asp:ListItem>
    <asp:ListItem Value="2">消费营销策略</asp:ListItem>    
    </asp:DropDownList>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)策略名称：</td>
<td>              
    <VACTL:TextBox ID="txtStrategyName" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="400px"
            CanBeNull="No"
            FieldName="策略名称"
            MaxLength="50" />        
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)限定人群：</td>
<td>
    <asp:DropDownList ID="ddlLimitCustomerType" Runat="server" Width="104px" >
    <asp:ListItem Value="1" Selected="True">会员</asp:ListItem>
    <asp:ListItem Value="2">散客</asp:ListItem>    
    <asp:ListItem Value="3">全部</asp:ListItem>    
    </asp:DropDownList>
</td>
</tr>
<tr id="tr_memberLevel">
<td class="th">(<span class="note mustfill">*</span>)限定会员：</td>
<td>
    <asp:Repeater ID="rpMemberLevel" runat="server">
        <ItemTemplate>
            <input ID="iptCheckBox_<%# Container.ItemIndex%>" type="checkbox" name="ckbMemberLevel" value='<%# Eval("Level_Code") %>' <%# base.SetChecked(Eval("Level_Code").ToString())%> />
            <label ID="iptLabel" for="iptCheckBox_<%# Container.ItemIndex%>"><%# Eval("Level_Name") %></label>
            <br />
        </ItemTemplate>
    </asp:Repeater>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)有效日期：</td>
<td>
    <VACTL:TextBox ID="txtBeginDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            FieldName="有效日期-起始日期"
            RequiredFieldType="Date"
            CanBeNull="No"
            onfocus="laydate()"
            MaxLength="20" />
    至
    <VACTL:TextBox ID="txtEndDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            FieldName="有效日期-截止日期"
            RequiredFieldType="Date"            
            CanBeNull="No"
            onfocus="laydate()"
            MaxLength="20" />
</td>
</tr>
<tr>
<td class="th">备注：</td>
<td>    
	<VACTL:TextBox ID="txtStrategyDesc" Runat="server"
		 EnableViewState="False"
		 CssClass="input"
         Width="200px"
         MaxLength="100"  />	
</td>
</tr>
<tr>
<td colspan="2" class="footer">
    <% if (base.flag == 0) { %>
    <input type="button" id="btnSubmit" class="btn" style="width:150px" onclick="save(0)" value="保存，并进入下一步" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="清空" />
    <% } else { %>
    <input type="button" id="Button1" class="btn" style="width:150px" onclick="save(1)" value="保存，并进入下一步" />
    <% } %>    
    
    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfShopCode" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

