﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="salestrategy_config_setdiscountamountrule.aspx.cs" Inherits="VA.Modules.JDingCYT.sale.salestrategy_config_setdiscountamountrule" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

        function save(flag) {

            var enableRule = $("input[name=rbnEnableRule]:checked").val();            
            if (enableRule == "1") { //启用规则
                if (!formEditListTable_checkTableData()) {
                    return;
                }
            }

            if (flag == 1) {
                update();
            }
        }

        function update() {
            $.ajax({
                type: "POST",
                url: pageName + "?act=update",
                dataType: "html",
                data: $("form").eq(0).serialize(),
                success: function (data, textStatus) {
                    if (data == "ok") {
                        showActResult("保存成功！", true);
                    } else if (data.indexOf("01|") != -1) {
                        showActResult(data.substring(3), false);
                    }
                    else {
                        showActResult("保存失败：" + data, false);
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    showActResult("修改失败！textStatus :" + textStatus, false);
                }
            });
        }

        //显示操作结果；
        function showActResult(sMsg, actResult) {
            if (actResult) {
                JTongAlert('操作结果', sMsg, 'info', function () {
                    window.parent.closeFrameWindow();
                    window.parent.refresh();
                });
            } else {
                JTongAlert('操作结果', sMsg, 'error');
            }
        }

        function resetPage() {
            $("#txtCharges").val("");
            $("#txtDiscountAmount").val("");
            
            formEditListTable_clearRows();
        }

        function addRule() {
            var chargeAmount = $("#txtCharges").val();
            if (chargeAmount == "") {
                alert("请填写消费金额！");
                $("#txtCharges").focus();
                return;
            }

            var donateAmount = $("#txtDiscountAmount").val();
            if (donateAmount == "") {
                alert("请填写减免金额！");
                $("#txtDiscountAmount").focus();
                return;
            }

            /*检测是否存在给定的金额*/
            var $srcTable = $("#srcTable");
            var srcTableID = $srcTable.attr("id");

            var result = true;
            $srcTable.find("input[name=txtChargeAmount]").each(function () {
                var sChargeAmount = $(this).val();
                if (parseFloat(chargeAmount) == parseFloat(sChargeAmount)) {
                    JTongAlert("提示", "已经存在消费金额为" + chargeAmount + "的规则！", "warning");
                    result = false;
                    return;
                }
            });
            if (!result) {
                return;
            }

            formEditListTable_addRow(chargeAmount, donateAmount);
            $("#txtCharges").val("");
            $("#txtDiscountAmount").val("");

            $("#txtCharges").select();
            clearInputValidatorError();
        }

        $(function () {
            $("#txtCharges").focus();

            $("#txtCharges").keydown(function (event) {
                var keyCode = event.keyCode;
                if (keyCode == 13) {
                    $("#txtDiscountAmount").select();
                }
            });
            $("#txtDiscountAmount").keydown(function (event) {
                var keyCode = event.keyCode;
                if (keyCode == 13) {
                    addRule();
                }
            });
        });
    </script>

    <script type="text/javascript">

        var formEditListTable_RowCounter = 0;

        function formEditListTable_addRow(chargeAmount, donateAmout) {

            formEditListTable_RowCounter++;
            
            var $srcTable = $("#srcTable");
            var srcTableID = $srcTable.attr("id");

            var rowHtml = '';
            var $row = null;
            var rowCnt = $srcTable[0].rows.length;
            var rowID = formEditListTable_RowCounter;
        
            rowHtml += '<tr id="tr_' + rowID + '">';
            rowHtml += '<td style="text-align:center;" class="tdRowNo"></td>';

            rowHtml += '<td><input type="text" name="txtChargeAmount" value="' + chargeAmount + '" id="txtChargeAmount_' + rowID + '" /></td>';            
            rowHtml += '<td><input type="text" name="txtDiscountAmount" value="' + donateAmout + '" id="txtDiscountAmount_' + rowID + '" /></td>';

            rowHtml += '<td style="text-align:center;"><a href="javascript:formEditListTable_removeRow(' + rowID + ')">删除</a></td>';
            rowHtml += '<td></td>';
            rowHtml += '</tr>';

            $row = $(rowHtml);
            $srcTable.append($row);

            formEditListTable_setRowNo();
            formEditListTable_hideTbNoRecord();
        }

        function formEditListTable_removeRow(rowID) {

            var $srcTable = $("#srcTable");
            $srcTable.find("#tr_" + rowID).remove();

            var dataRowCount = $srcTable.find("input[name=txtChargeAmount]").length;
            if (dataRowCount == 0) { //如果已无数据行，则重置计数器；
                formEditListTable_RowCounter = 0;
                formEditListTable_showTbNoRecord();
            }

            formEditListTable_setRowNo();
        }

        function formEditListTable_clearRows() {
            var $srcTable = $("#srcTable");
            $srcTable.find("tr[id]").remove();

            formEditListTable_showTbNoRecord();
        }

        function formEditListTable_showTbNoRecord() {
            $("#tbNoRecord").show();
        }
        function formEditListTable_hideTbNoRecord() {
            $("#tbNoRecord").hide();
        }

        function formEditListTable_setRowNo() {
            var $srcTable = $("#srcTable");
            var $tdNos = $srcTable.find("td.tdRowNo");
            $.each($tdNos, function (n, value) {
                $(value).html(n + 1);
            });
        }

        function formEditListTable_checkTableData() {

            var result = true;

            var dataRowCount = 0;
            var $srcTable = $("#srcTable");

            $srcTable.find("input[name=txtChargeAmount]").each(function () {
                dataRowCount++;
                var sChargeAmount = $(this).val();
                if ($.trim(sChargeAmount) == "" || $.trim(sChargeAmount) == "0") {
                    alert("消费金额不能为空或0！");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });

            $srcTable.find("input[name=txtDiscountAmount]").each(function () {
                dataRowCount++;
                var sDonateAmount = $(this).val();
                if ($.trim(sDonateAmount) == "" || $.trim(sDonateAmount) == "0") {
                    alert("减免金额不能为空或0！");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });

            if (dataRowCount == 0) {
                alert("规则条目不能为空！");
                result = false;
            }

            return result;
        }
    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:700px;">

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">设置营销规则</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr id="trEditResult" runat="server" visible="false">
<td colspan="2" style="text-align:center;">
    <div class="editResult">
    <asp:Literal id="litEditResult" runat="server" />
    </div>
</td>
</tr>
<tr>
<td class="th">策略类型：</td>
<td>
    <asp:Label ID="lblBizType" runat="server"></asp:Label>
</td>
</tr>
<tr>
<td class="th">策略名称：</td>
<td>              
    <asp:Label ID="lblStrategyName" runat="server"></asp:Label>
</td>
</tr>
<tr style="display:none;">
<td class="th">启用规则：</td>
<td>              
    <asp:RadioButtonList ID="rbnEnableRule" runat="server"
         RepeatDirection="Horizontal"
         RepeatLayout="Flow">
        <asp:ListItem Value="1" Selected="True">启用</asp:ListItem>
        <asp:ListItem Value="0">不启用</asp:ListItem>
    </asp:RadioButtonList>                 
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">减免金额规则</td>
</tr>
</table>
<table cellspacing="0" class="formEditListTable" id="srcTable" style="width:700px;margin-top:-1px;">
<thead>
<tr>
<td style="width:30px;text-align:center;">No.</td>
<td style="width:100px;text-align:center;">消费金额满</td>
<td style="width:100px;text-align:center;">减免金额</td>
<td style="width:100px;text-align:center;">操作</td>
<td></td>    
</tr>    
</thead>    
<tbody>
</tbody>
</table>

<table id="tbNoRecord" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="text-align:center;height:100px;">
    暂无数据
</td>
</tr>
</table>

<table id="Table1" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">添加规则：</td>
<td style="text-align:right;">

    消费金额满：
    <VACTL:TextBox ID="txtCharges" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="60px"
            CanBeNull="No"
            FieldName="消费金额"
            RequiredFieldType="Money"
            MaxLength="10" /> 元  
    &nbsp;
    减免金额：
    <VACTL:TextBox ID="txtDiscountAmount" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="60px"
            CanBeNull="No"
            FieldName="减免金额"
            RequiredFieldType="Money"
            MaxLength="10" />  
    <input type="button" id="Button1" runat="server" class="simpleBtn" onclick="addRule()" value="添加" /> 
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <input type="button" id="btnUpdate" runat="server" class="btn" style="width:100px" onclick="save(1)" value="保存" />
    <input type="button" id="btnReset" class="btn" style="width:80px" onclick="resetPage()" value="重置" />
    <asp:Label ID="lblNote" runat="server" ForeColor="Red"></asp:Label>

    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>  
        
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

<%    
    Response.Write("<script type=\"text/javascript\">");       
    Response.Write("var itemList = [");       
       
    var i = 0;
    System.Collections.Generic.List<VA.Modules.JDingCYT.Core.Model.Sale.Strategy.SSDiscountAmountRuleInfo> rules = base.strategy.GetDiscountAmountRules(base.strategyCode);
    foreach (VA.Modules.JDingCYT.Core.Model.Sale.Strategy.SSDiscountAmountRuleInfo item in rules)
    {
        string chargeAmount = item.Charges.ToString("F2");
        string discountAmount = item.Discount_Amount.ToString("F2");

        Response.Write("{");
        Response.Write("\"chargeAmount\":\"" + chargeAmount + "\",\"discountAmount\":\"" + discountAmount + "\"");

        if (i == rules.Count - 1)
            Response.Write("}");
        else
            Response.Write("},");
        
        i++;
    }

    Response.Write("];");      
    Response.Write("</script>");        
%>

<script type="text/javascript">
    for (var i = 0; i < itemList.length; i++) {
        formEditListTable_addRow(
            itemList[i].chargeAmount,
            itemList[i].discountAmount);
    }
</script>
