﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="employee_commision_list.aspx.cs" Inherits="VA.Modules.JDingCYT.query.employee_commision_list" %>

<%@ Import Namespace="System.Data"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>员工提成</title>    
    <!--#include virtual="/modules/cyt/include/css/editlist.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/statquery_s.aspx"--> 
    <script type="text/javascript">

        //设置日期检索条件控件的行为；
        function setDateControlBehavior() {
            var $ddlDate = $("#ddlDateRule");
            if ($ddlDate.length == 0) {
                return;
            }

            if ($ddlDate.val() != "3") {
                $("#txtBeginDate").attr("disabled", "disabled");
                $("#txtEndDate").attr("disabled", "disabled");
            }
            $ddlDate.change(function () {
                var $txtBeginDate = $("#txtBeginDate");
                var $txtEndDate = $("#txtEndDate");
                var beginDate = null;
                var endDate = null;
                var sBeginDate = null;
                var sEndDate = null;

                var myDate = new Date();

                var dateRule = $ddlDate.val();
                if (dateRule == "1") { //上月          
                    var preMonth_today = myDate.dateAdd("m", -1);                    
                    var preMonth_year = preMonth_today.getFullYear();
                    var preMonth_month = preMonth_today.getMonth();                   
                    var thisMonth_today = myDate;
                    var thisMonth_year = myDate.getFullYear();
                    var thisMonth_month = myDate.getMonth();
                    var thisMonth_firstDay = new Date(thisMonth_year, thisMonth_month, 1);
                    beginDate = new Date(preMonth_year, preMonth_month, 1);
                    endDate = thisMonth_firstDay.dateAdd("d", -1); 
                }
                else if (dateRule == "2") { //本月          
                    var thisMonth_today = myDate;
                    var thisMonth_year = myDate.getFullYear();
                    var thisMonth_month = myDate.getMonth();
                    beginDate = new Date(thisMonth_year, thisMonth_month, 1);
                    endDate = myDate;
                }
                else if (dateRule == "3") { //自定义
                    beginDate = myDate;
                    endDate = myDate;
                    $("#txtBeginDate").removeAttr("disabled");
                    $("#txtEndDate").removeAttr("disabled");
                }

                sBeginDate = beginDate.format("yyyy-MM-dd");
                sEndDate = endDate.format("yyyy-MM-dd");

                $txtBeginDate.val(sBeginDate);
                $txtEndDate.val(sEndDate);

                if (dateRule == "3") { //自定义
                    //$("#txtBeginDate").val("");
                    $("#txtEndDate").val("");
                }

                $("#btnSearch").click();
            });
        }

        //单条查看详细信息；
        function sviewDetail(shopCode, employeeCode, employeeName, beginDate, endDate) {            
            openTopestWindow("提成明细(" + employeeName + ")", "/modules/cyt/query/employee_commision_detail_list.aspx?shopcode="+ shopCode +"&employeecode="+ employeeCode +"&employeename="+ encodeURI(employeeName) +"&&begindate="+ beginDate +"&enddate=" + endDate);
            event.stopPropagation();  //阻止事件冒泡，避免行被选中；
        }

        $(function () {
            initListPage();
            setDateControlBehavior();
        });

    </script>

</head>
<body>
<!--说明：该页面是以 employee_editlist_nofresh_5.aspx 为原型封装的结果-->
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper">        
    
    <div id="toolBar">                          
        <asp:LinkButton ID="lbnExportToExcel" runat="server" CssClass="jtongui-toolbarbutton" icon="icon-export" OnClick="lbnExportToExcel_Click">导出</asp:LinkButton>
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>                   
    </div><!--toolBar.END-->    

    <%
    if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Free ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Basic ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Standard)
    {
        base.ShowSoftFunctionLimitNote(VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName);
    }
%>
    
    <div id="shopBar">                            
        <div class="title">门店</div>
        <div class="textBox">
            <VACTL:TextBox runat="server" ID="txtShop" 
                CssClass="input" 
                onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_shops.aspx',true,true,300,400);"
                />
            <asp:HiddenField runat="server" id="txtShop_hiddenValue" />
        </div>
    </div>

    <div id="searchBar">
    
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>        

        <asp:DropDownList ID="ddlDateRule" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">统计期间</asp:ListItem>
        <asp:ListItem Value="1" >上月</asp:ListItem>
        <asp:ListItem Value="2">本月</asp:ListItem>
        <asp:ListItem Value="3">自定义</asp:ListItem>
        </asp:DropDownList>   

        <VACTL:TextBox ID="txtBeginDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />  
        -      
        <VACTL:TextBox ID="txtEndDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />      
        
        <asp:DropDownList ID="ddlOrderBy" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlOrderBy_SelectedIndexChanged">
        <asp:ListItem Value="">排序规则</asp:ListItem>            
        <asp:ListItem Value="Employee_Code|ASC">按服务人员代码-正序</asp:ListItem>        
        <asp:ListItem Value="Employee_Code|DESC">按服务人员代码-倒序</asp:ListItem>
        <asp:ListItem Value="Total_Consume_Amount|DESC">按顾客消费总额-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_Consume_Amount|ASC">按顾客消费总额-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_Commision_Amount|DESC">按提成总额-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_Commision_Amount|ASC">按提成总额-由少到多</asp:ListItem>
        </asp:DropDownList>                       
         
        <asp:Button ID="btnSearch" runat="server" 
             CssClass="simpleBtn"
             Text="查询" 
             Onclick="btnSearch_Click" />
        
        </ContentTemplate>
        </asp:UpdatePanel>

    </div>             

    <div id="dataBar" style="margin-top:-1px;">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <td style="width:30px;text-align:center;">No.</td>
        <td style="width:80px;text-align:center;">服务人员代码</td>
        <td style="width:80px;text-align:center;">服务人员姓名</td>
	    <td style="width:80px;text-align:center;">顾客消费总额</td>
        <td style="width:80px;text-align:center;">提成总额</td>	    	 
        <td style="width:80px;text-align:center;">提成明细</td>	    	 
        <td></td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <table cellpadding="3" cellspacing="0" class="tablebody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td align="center"><%# Container.ItemIndex + 1%></td>
        <td align="center"><%# Eval("Employee_Code")%></td>
        <td align="left"><%# Eval("Employee_Name")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_Consume_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_Commision_Amount")).ToString("F2")%></td>
        <td align="center">
            <a href="#" onclick="javascript:sviewDetail('<% = base.ShopCode%>','<%# Eval("Employee_Code")%>', '<%# Eval("Employee_Name")%>', '<% = base.BeginDate %>', '<% = base.EndDate %>');"><img src="/admin/icons/detail.png" alt="详情"/>  </a>
        </td>   
        <td></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

</div>


<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  


</form>
</body>
</html> 