﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="pointcard_sale_free.aspx.cs" Inherits="VA.Modules.JDingCYT.pointcard.pointcard_sale_free" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>自由充次</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

    function confirm() {

        var hfMemberID = $("#hfMemberID").val();
        var cardName = "";
        var cardType = $("#lblPointCardType").html();
        var payAmount = $("#lblTotalAmount").html();
        var payTypeName = $("#ddlPayTypes").find("option:selected").text();

        if ($.trim(hfMemberID) == "") {
            JTongAlert('提示', "会员信息不能为空！", 'warning');
            return;
        }

        if ($("#ddlPointCards").find("option").length == 0) {
            JTongAlert('提示', "没有计次卡可供销售！", 'warning');
            return;
        } else {
            cardName = $("#ddlPointCards").find("option:selected").text();
        }

        $("#span_Confirm_CardName").html(cardName);
        $("#span_Confirm_CardType").html(cardType);
        $("#span_Confirm_PayAmount").html(payAmount);
        $("#span_Confirm_PayTypeName").html(payTypeName);

        var windowTitle = "确认";
        var windowWidth = 380;
        var windowHeight = 330;
        var left = 180;
        var top = 116;
        var winDivID = "winConfirm";
        openDivWindow(windowTitle, windowWidth, windowHeight, left, top, winDivID);
        $("#btnSubmit").focus();
    }

    function cancelSave() {
        $('#winConfirm').window("close");
    }

    function save() {

        $("#btnSubmit").attr("disabled", "disabled");

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("充次成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("充次失败：" + data, false, doAfterAdd);
            }

            $("#btnSubmit").removeAttr("disabled");
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            try {
                if (window.parent != window.self) {
                    window.parent.reload();
                }
            } catch (e) { }
            cancelSave();
            resetPage();            
        }
    }

    function resetPage() {
                
        $("#txtPayAmount").val("");
        $("#ddlPayTypes")[0].options[0].selected = true;

        $("#txtPayAmount").attr("disabled", "disabled");
        $("#ddlPayTypes").attr("disabled", "disabled");
        $("#ddlPointCards").attr("disabled", "disabled");        
        $("#txtRemark").attr("disabled", "disabled");
        $("#btnNext").attr("disabled", "disabled");

        clearMemberInfo();

        clearInputValidatorError();
    }

    //刷新整个页面；
    function refresh() {
        window.location.reload();
    }

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc() {
        $("#txtPayAmount").removeAttr("disabled");
        $("#ddlPayTypes").removeAttr("disabled");
        $("#ddlPointCards").removeAttr("disabled");
        $("#txtRemark").removeAttr("disabled");
        $("#btnNext").removeAttr("disabled");

        $("#ddlPointCards").focus();
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {
        $("#txtKey").focus();
    }

    //获取计次卡价格；
    function loadPointCardInfo() {
        var cardID = $("#ddlPointCards").val();
        $.ajax({
            type: "GET",
            url: "../datasrc/get_pointcardinfo_json.aspx",
            dataType: "json",
            data: { "cardid": cardID },
            success: function (data, textStatus) {
                if (data != "error") {
                    if (data == "") {
                        alert("没有对应的计次卡信息，该卡可能已经删除！");
                    } else {
                        $("#lblPointCardPrice").html(data.cardPrice);
                        $("#lblPointCardType").html(data.cardTypeName);
                        $("#hidden_PointCardType").val(data.cardType);                        
                        $("#lblTotalAmount").html(data.cardPrice);

                        if (data.cardType == "1"){ //自由消费卡
                            $("#tr_Term").hide();
                            $("#tr_ChargeHistory").hide();
                        } else if (data.cardType == "2") {  //包期消费卡
                            $("#tr_Term").show();
                            $("#tr_ChargeHistory").show();
                        }

                        if (data.enableRule == "1") {
                            $("#lblPointCardEnableRule").html("即时生效");
                        } else if (data.enableRule == "2") {
                            $("#lblPointCardEnableRule").html("月初生效");
                        } else {
                            $("#lblPointCardEnableRule").html("未知的生效规则");
                        }                        
                    }
                }
                else {
                    showActResult("获取计次卡信息失败！", false);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showActResult("请求失败！textStatus :" + textStatus, false);
            }
        });
    }

    function viewCardInfo() {
        var $ddlPointCards = $("#ddlPointCards");
        if ($ddlPointCards[0].options.length == 0) {
            alert("请选择计次卡！");
            return;
        }
        var pointCardID = $ddlPointCards.val();
        openFrameWindow("计次卡详情", 735, 550, "pointcard_info.aspx?cardid=" + pointCardID);
    }

    $(function () {

        $("#ddlPointCards").change(function () {
            loadPointCardInfo();
        });

        if ($("#ddlPointCards")[0].options.length > 0){
            loadPointCardInfo();
        }

        $("#txtPayAmount").attr("disabled", "disabled");
        $("#ddlPayTypes").attr("disabled", "disabled");
        $("#ddlPointCards").attr("disabled", "disabled");
        $("#ddlTerm").attr("disabled", "disabled");
        $("#txtRemark").attr("disabled", "disabled");
        $("#btnNext").attr("disabled", "disabled");

        //焦点控制
        $("input,select").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;
                switch (targetID) {
                    case "ddlPointCards":
                        $("#ddlPayTypes").focus();
                        break;
                    case "ddlPayTypes":
                        $("#txtRemark").select();
                        break;                 
                    case "txtRemark":
                        confirm();
                        return false;
                        break;
                    default:
                        break;
                }
            }
        });
    });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:700px;">

<%
    if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Free ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Basic)
    {
        base.ShowSoftFunctionLimitNote(VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName);
    }
%>

<div class="centerFormTitle">
   <h1>自由充次</h1>
</div>

<!--#include file="../include/memberinfo.aspx"--> 

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" colspan="2" style="font-weight:bold;text-align:left;">充次信息</td>
</tr>
<tr>
<td class="th">日期：</td>
<td>    
	<% = DateTime.Now %>
</td>
</tr>
<tr>
<td class="th">操作员：</td>
<td>    
	<% = base.EmployeeName %>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)计次卡：</td>
<td>
    <asp:DropDownList ID="ddlPointCards" Runat="server" >
    </asp:DropDownList>
    <a href="javascript:viewCardInfo();">[ 计次卡详情 ]</a>
</td>
</tr>
<tr>
<td class="th">价格：</td>
<td>
    <asp:Label ID="lblPointCardPrice" runat="server"></asp:Label>    
</td>
</tr>
<tr>
<td class="th">卡类型：</td>
<td>
    <asp:Label ID="lblPointCardType" runat="server"></asp:Label> 
    <input type="hidden" id="hidden_PointCardType" />
</td>
</tr>
<tr>
<td class="th">生效方式：</td>
<td>
    <asp:Label ID="lblPointCardEnableRule" runat="server"></asp:Label>    
</td>
</tr>
<tr style="display:none;">
<td class="th">合计金额：</td>
<td>
    <asp:Label ID="lblTotalAmount" runat="server" Font-Bold="true"></asp:Label>    
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)付款方式：</td>
<td>
    <asp:DropDownList ID="ddlPayTypes" Runat="server" >
    </asp:DropDownList>
</td>
</tr>
<tr>
<td class="th">备注：</td>
<td>    
	<VACTL:TextBox ID="txtRemark" Runat="server"
		 EnableViewState="False"
		 CssClass="input"
         Width="200px"
         MaxLength="100"  />	
</td>
</tr>

<tr>
<td colspan="2" class="footer">

    <input type="button" id="btnNext" class="btn" style="width:100px" onclick="confirm()" value="充次" />
    <input type="button" id="btnResetPage" class="btn" style="width:80px" onclick="resetPage()" value="重置" />
    <input type="button" id="btnRefresh" class="btn" style="width:80px" onclick="refresh()" value="刷新" />
    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

<!--确认窗口-->    
<div id="winConfirm" style="display:none;">

    <div style="width:350px;margin:auto;">
    
    <br />

    <div class="centerFormTitle">
        <h1>确认充次信息</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;width:100%;">
    <tr>
    <td class="th">操 作 员：</td>
    <td>    
	    <span id="span_Confirm_OperatorName"><%= base.EmployeeName %></span>
    </td>
    </tr>
    <tr>
    <td class="th">售卡日期：</td>
    <td>    
	    <span id="span1"><% = DateTime.Now.ToString("yyyy-MM-dd") %></span>
    </td>
    </tr>
    <tr>
    <td class="th">计 次 卡：</td>
    <td>    
        <span id="span_Confirm_CardName" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td class="th">卡 类 型：</td>
    <td>    
        <span id="span_Confirm_CardType" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td class="th">充次金额：</td>
    <td>   
        <span id="span_Confirm_PayAmount" style="font-weight:bold;"></span> 
    </td>
    </tr>  
    <tr>
    <td class="th">支付方式：</td>
    <td>    
        <span id="span_Confirm_PayTypeName" style="font-weight:bold;"></span>
    </td>
    </tr>  
    <tr>
    <td colspan="2" class="footer">

        <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="save()" value="确定" />
        <input type="button" id="btnCancel" class="btn" style="width:80px" onclick="cancelSave()" value="取消" />
        <%--<asp:CheckBox ID="ckbPrintBill" runat="server"
             Text="打票" /> --%>
    </td>
    </tr>
    </table>
    </div>

</div><!--winConfirm.END-->

</form>
</body>
</html>

