﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="member_register_simple.aspx.cs" Inherits="VA.Modules.JDingCYT.member.member_register_simple" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>会员快速登记</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">    
    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        add();
    }

    function add() {
        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("登记成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("登记失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            try {
                if (window.parent != window.self) {
                    window.parent.reload();
                }
            } catch (e) { }
            resetPage();
        }
    }

    function resetPage() {

        //姓名
        $("#txtName").val("");
        
        //手机
        $("#txtMobileNo").val("");

        //卡号
        $("#txtCardNo").val("");

        clearInputValidatorError();

        $("#txtCardNo").focus();
    }

    $(function () {
        $("#txtCardNo").focus();
        $("#txtCardNo").keyup(function (event) {
            if (event.keyCode != 13) {
                $("#txtMobileNo").val($(this).val());
            }
        });

        //焦点控制
        $("input").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;
                switch (targetID) {
                    case "txtCardNo":
                        if ($("#txtCardNo").val() != "") {
                            $("#txtName").select();
                        }
                        break;
                    case "txtName":
                        $("#txtMobileNo").select();
                        break;
                    case "txtMobileNo":
                        save();
                        break;
                    default:
                        break;
                }
                return false;
            }
        });
    });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:600px;">

<div class="centerFormTitle">
   <h1>会员快速登记</h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr id="trEditResult" runat="server" visible="false">
<td colspan="2" style="text-align:center;">
    <div class="editResult">
    <asp:Literal id="litEditResult" runat="server" />
    </div>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)<b>会员卡号</b>：</td>
<td>
    <VACTL:TextBox ID="txtCardNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="200px"
            CanBeNull="No"
            FieldName="会员卡号"
            MaxLength="30"
            /> 
 <%--   <input type="button" id="btnReadCard" class="btn" onclick="readPhyCard()" value="读实体卡" />--%>
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:5px;">
<tr>
<td class="th">(<span class="note mustfill">*</span>)姓名：</td>
<td>              
    <VACTL:TextBox ID="txtName" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="姓名"
            MaxLength="10" />        
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)手机：</td>
<td>
    <VACTL:TextBox ID="txtMobileNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="手机"
            RequiredFieldType="Mobile"
            MaxLength="11" /> 
</td>
</tr>
<tr>
<td colspan="2" class="footer">

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="清空" />

    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

