﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="member_register_noborder.aspx.cs" Inherits="VA.Modules.JTongMember.member.member_register_noborder" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <!--#include virtual="/include/css/edit.aspx"-->
    <!--#include virtual="/include/js/edit.aspx"-->     
    <script type="text/javascript">

    //在选中一项前；
    function JTongSmartDropDownList_BeforeTakeValue(JTongSmartDropDownList_inputObjID, selectedRow) {
        if (selectedRow != null) {
            if (JTongSmartDropDownList_inputObjID == "txtIntroducer") {
                var memberID = selectedRow.cells[0].innerHTML;
                var memberName = selectedRow.cells[1].innerHTML;
                var cardNo = selectedRow.cells[2].innerHTML; //会员卡号；

                if (cardNo == $.trim(document.getElementById("txtCardNo").value)) {
                    alert("推荐人不能是会员自己！");
                    $("#txtIntroducer").focus();
                    return false;
                }
            }
        }

        //返回true，继续取值；返回false，取消取值；
        return true;
    }

    function save(flag) {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        if (flag == 0) {
            add();
        }
        else {
            update();
        }
    }

    function add() {
        $.ajax({
            type: "POST",
            url: "member_register.aspx?act=add",
            dataType: "html",
            data: $("form").eq(0).serialize(),
            success: function (data, textStatus) {
                if (data == "ok") {
                    showActResult("添加成功！", true);
                    clear();
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false);
                }
                else {
                    showActResult("添加失败：" + data, false);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showActResult("添加失败！textStatus :" + textStatus, false);
            }
        });
    }

    function update() {
        $.ajax({
            type: "POST",
            url: "member_register.aspx?act=update",
            dataType: "html",
            data: $("form").eq(0).serialize(),
            success: function (data, textStatus) {
                if (data == "ok") {
                    showActResult("修改成功！", true);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false);
                }
                else {
                    showActResult("修改失败：" + data, false);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showActResult("修改失败！textStatus :" + textStatus,false);
            }
        });
    }

    function clearControls() {

        //姓名
        $("#txtName").val("");

        //性别；

        //生日
        $("#txtBirthDate").val("");
        
        //手机
        $("#txtMobileNo").val("");

        //电话
        $("#txtPhone").val("");

        //Email
        $("#txtEmail").val("");

        //会员级别
        //$("#ddlMemberLevel").val("");

        //选中第1项;
        $("#ddlMemberLevel")[0].options[0].selected = true;

        //会员卡号
        $("#txtCardNo").val("");

        //推荐人
        $("#txtIntroducer").val("");
        $("#txtIntroducer_hiddenValue").val("");

        //客户经理
        $("#txtSalesman").val("");
        $("#txtSalesman_hiddenValue").val("");

        //身份证号
        $("#txtIDCardNo").val("");

        //地址
        $("#txtAddress").val("");

        //备注
        $("#txtRemark").val("");

        //清除错误提示样式；
        $("select,input").each(function () {
            if ($(this).hasClass("error_indicator")) {
                $(this).removeClass("error_indicator");
            }
        });
    }

    //显示操作结果；
    function showActResult(sMsg,actResult) {
        if (actResult) {
            JTongAlert('操作结果', sMsg, 'info');
        } else {
            JTongAlert('操作结果', sMsg, 'error');
        }

        if (actResult) {
            try {
                window.parent.reload();
            } catch (e) { }
        }
    }

    $(function () {
        $("#txtName").focus();
        $("#txtMobileNo").keyup(function (event) {
            $("#txtCardNo").val($(this).val());
        });
    });

    </script>

    <style type="text/css">  
    
    /**editTable.BEGIN******/
    .editTable
    {	
        width:100%;     
        border:solid 0px #B9CAD3;
        border-collapse:collapse;
        font-size:14px;
    }
    .editTable .th
    {
        text-align:left;
        width:80px;
    }

    .editTable td
    {
        text-align:left;    
        vertical-align:middle;   
        padding:3px;
    
    }
    .editTable .editResult
    {   
        padding:5px;
        background-color:#fffff0;    
        border: 1px solid #c4cbd3;
        font-size:13px;
        text-align:left;
        color:green;
        line-height:150%;
        margin-bottom:10px;
    }

    .editTable .editResult a{
	    font-size:14px;
    }


    .editTable .th{
        width:100px;
    }
    

    </style>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper">

<div class="formTitle">
   <h1>会员登记</h1>
</div>

<br />

<table cellspacing="0" cellpadding="3" class="editTable">
<tr id="trEditResult" runat="server" visible="false">
<td colspan="2" style="text-align:center;">
    <div class="editResult">
    <asp:Literal id="litEditResult" runat="server" />
    </div>
</td>
</tr>
<tr>
<td class="th">姓名(<span class="note mustfill">*</span>)：</td>
<td>              
    <VACTL:TextBox ID="txtName" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="姓名"
            MaxLength="10" />        
</td>
</tr>
<tr>
<td class="th">性别：</td>
<td>
    <asp:DropDownList ID="ddlSex" Runat="server" Width="104px" >
    <asp:ListItem Value="男">男</asp:ListItem>
    <asp:ListItem Value="女">女</asp:ListItem>    
    </asp:DropDownList>
</td>
</tr>
<tr>
<td class="th">出生日期：</td>
<td>
    <VACTL:TextBox ID="txtBirthDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            FieldName="出生日期"
            RequiredFieldType="Date"
            HintInfo="如：2015-02-01"
            onclick="WdatePicker()"
            MaxLength="20" />
    <img onclick="WdatePicker({el:'txtBirthDate'})" src="/app_themes/default/images/icons/ico_datepicker.gif" align="absmiddle">
</td>
</tr>
<tr>
<td class="th">手机(<span class="note mustfill">*</span>)：</td>
<td>
    <VACTL:TextBox ID="txtMobileNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="手机"
            RequiredFieldType="Mobile"
            HintInfo="如：13073788830"
            MaxLength="11" /> 
</td>
</tr>
<tr>
<td class="th">Email：</td>
<td>
   <VACTL:TextBox ID="txtEmail" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="100px"
            FieldName="Email"
            RequiredFieldType="Email"
            MaxLength="50" /> 
            
</td>
</tr>
<tr>
<td class="th">会员等级：</td>
<td>
    <asp:DropDownList ID="ddlMemberLevel" Runat="server" Width="104px" >    
    </asp:DropDownList>
</td>
</tr>
<tr>
<td class="th">会员卡号(<span class="note mustfill">*</span>)：</td>
<td>
    <VACTL:TextBox ID="txtCardNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="会员卡号"
            MaxLength="30"
            /> 
</td>
</tr>
<tr>
<td class="th">推荐人卡号：</td>
<td>
    <asp:TextBox runat="server" ID="txtIntroducer" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, 'smartdropdownlist_datasrc/get_members.aspx',true,false,300,180);"
            Width="100px"
            MaxLength="30" />
    <asp:HiddenField runat="server" id="txtIntroducer_hiddenValue" />
</td>
</tr>
<tr>
<td class="th">客户经理：</td>
<td>
    <asp:TextBox runat="server" ID="txtSalesman" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, 'smartdropdownlist_datasrc/get_employees.aspx',true,false,300,150);"
            Width="100px"
            MaxLength="20" />
    <asp:HiddenField runat="server" id="txtSalesman_hiddenValue" />
</td>
</tr>
<tr>
<td class="th">身份证号：</td>
<td>
    <VACTL:TextBox ID="txtIDCardNo" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="200px"
            FieldName="身份证号"
            RequiredFieldType="IDCardNum"
            MaxLength="18"
            />
</td>
</tr>
<tr>
<td class="th">联系地址：</td>
<td>
    <VACTL:TextBox ID="txtAddress" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="200px"
            FieldName="地址"
            MaxLength="50" />
</td>
</tr>
<tr>
<td class="th">备注：</td>
<td>    
	<VACTL:TextBox ID="txtRemark" Runat="server"
		 EnableViewState="False"
		 CssClass="input"
         Width="200px"
         MaxLength="100"  />	
</td>
</tr>

<tr>
<td class="th"></td>
<td>
    <% if (base.flag == 0) { %>
    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save(0)" value="保存" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="clearControls()" value="清空" />
    <% } else { %>
    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save(1)" value="保存" />
    <% } %>    
    
    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

