﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="member_register.aspx.cs" Inherits="VA.Modules.JDingCYT.member.member_register" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>会员登记</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">    
    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        var memberLevelCode = $("#txtLevel_hiddenValue").val();
        if (memberLevelCode == "" || memberLevelCode == "9999") {
            JTongAlert("提示", "会员级别不能为空！\n\n请从列表中选择，不要手工输入！", "info");
            return;
        }

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("登记成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("登记失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            try {
                if (window.parent != window.self) {
                    window.parent.reload();
                }
            } catch (e) { }
            resetPage();
        }
    }

    function resetPage() {

        //姓名
        $("#txtName").val("");

        //性别；

        //生日
        $("#txtBirthDate").val("");
        
        //手机
        $("#txtMobileNo").val("");

        //微信；
        $("#txtWeixinNo").val("");

        //电话
        $("#txtPhone").val("");

        //Email
        $("#txtEmail").val("");

        //卡号
        $("#txtCardNo").val("");

        //推荐人
        $("#txtIntroducerName").val("");
        $("#hfIntroducerID").val("");

        //客户经理
        $("#txtSalesmanName").val("");
        $("#hfSalesmanCode").val("");

        //身份证号
        $("#txtIDCardNo").val("");

        //地址
        $("#txtAddress").val("");

        //备注
        $("#txtRemark").val("");

        clearInputValidatorError();

        $("#txtName").focus();
    }

    function JTongSmartDropDownList_AfterTakeValue(JTongSmartDropDownList_inputObjID, selectedRow) {
        if (selectedRow != null) {

            if (JTongSmartDropDownList_inputObjID == "txtLevel") {
                $("#txtCardNo").focus();
            }

        }

        //返回true，继续取值；返回false，取消取值；
        return true;
    }

    //浏览新推荐人列表；
    function browseIntroducers(keyType, keyValue) {
        if (keyType == "cardno") {
            keyType = "1";
        }
        else if (keyType == "mobileno") {
            keyType = "2";
        }
        openFrameWindow("会员列表", 730, 419, "../datasrc/get_memberlist.aspx?searchfield=" + keyType + "&keywords=" + keyValue + "&callback=takeIntroducerInfo");
    }

    //从弹窗窗口中获取新推荐人信息
    function takeIntroducerInfo(trObj) {
        closeFrameWindow();

        var memberID = $(trObj).find("td.memberid").eq(0).html();
        var memberName = $(trObj).find("td.membername").eq(0).html();
        
        $("#txtIntroducerName").val(memberName);
        $("#hfIntroducerID").val(memberID);
    }

    //浏览新客户经理列表；
    function browseEmployees(keywords) {
        openFrameWindow("员工列表", 730, 419, "../datasrc/get_employee_list.aspx");
    }

    //从弹窗窗口中获取新客户经理信息
    function takeEmployeeInfo(trObj) {
        closeFrameWindow();

        var employeeCode = $(trObj).find("td.employeeCode").eq(0).html();
        var employeeName = $(trObj).find("td.employeeName").eq(0).html();

        $("#hfSalesmanCode").val(employeeCode);
        $("#txtSalesmanName").val(employeeName);
    }

    $(function () {
        $("#txtCardNo").focus();
        $("#txtCardNo").keyup(function (event) {
            if (event.keyCode != 13) {
                $("#txtMobileNo").val($(this).val());
            }
        });

        //焦点控制
        $("input:not(#txtMemberLevel,#txtIntroducerName,#txtSalesmanName),select").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;           
                switch (targetID) {
                    case "txtCardNo":
                        if ($("#txtCardNo").val() != "") {
                            $("#txtName").select();
                        }
                        break;
                    case "txtName":
                        if ($("#txtName").val() != "") {
                            $("#ddlSex").focus();
                        }
                        break;
                    case "ddlSex":
                        $("#txtBirthDate").select();
                        break;
                    case "txtBirthDate":
                        $("#txtMobileNo").select();                        
                        break;
                    case "txtMobileNo":
                        $("#txtWeixinNo").select();
                        break;
                    case "txtWeixinNo":
                        $("#txtEmail").select();
                        break;
                    case "txtEmail":;
                        if ($("#txtLevel").val() == "") {
                            $("#txtLevel").select();
                        } else {
                            $("#txtIDCardNo").select();
                        }
                        break;
                    case "txtIDCardNo":
                        $("#txtAddress").select();
                        break;
                    case "txtAddress":
                        $("#txtRemark").select();
                        break;
                    case "txtRemark":
                        save();
                        break;
                    default:
                        break;
                }
            }
        });

        
    });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:600px;">

<div class="centerFormTitle">
   <h1>会员登记</h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr id="trEditResult" runat="server" visible="false">
<td colspan="2" style="text-align:center;">
    <div class="editResult">
    <asp:Literal id="litEditResult" runat="server" />
    </div>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)<b>会员卡号</b>：</td>
<td>
    <VACTL:TextBox ID="txtCardNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="200px"
            CanBeNull="No"
            FieldName="会员卡号"
            MaxLength="30"
            /> 
   <%-- <input type="button" id="btnReadCard" class="btn" onclick="readPhyCard()" value="读实体卡" />--%>
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:5px;">
<tr>
<td class="th">(<span class="note mustfill">*</span>)姓名：</td>
<td>              
    <VACTL:TextBox ID="txtName" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="姓名"
            MaxLength="10"
            next="ddlSex" />        
</td>
</tr>
<tr>
<td class="th">性别：</td>
<td>
    <asp:DropDownList ID="ddlSex" Runat="server" Width="104px" next="txtBirthDate" >
    <asp:ListItem Value="" Selected="True"></asp:ListItem>
    <asp:ListItem Value="男">男</asp:ListItem>
    <asp:ListItem Value="女">女</asp:ListItem>    
    </asp:DropDownList>
</td>
</tr>
<tr>
<td class="th">出生日期：</td>
<td>
    <VACTL:TextBox ID="txtBirthDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            FieldName="出生日期"
            RequiredFieldType="Date"
            onclick="laydate()"
            MaxLength="20" /> <span class="note">格式：yyyy-MM-dd，如：1980-01-15</span>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)手机：</td>
<td>
    <VACTL:TextBox ID="txtMobileNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="手机"
            RequiredFieldType="Mobile"
            MaxLength="11" /> 
</td>
</tr>
<tr>
<td class="th">微信：</td>
<td>
    <VACTL:TextBox ID="txtWeixinNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="200px"            
            MaxLength="50" /> 
</td>
</tr>
<tr>
<td class="th">Email：</td>
<td>
   <VACTL:TextBox ID="txtEmail" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="200px"
            FieldName="Email"
            RequiredFieldType="Email"
            MaxLength="50" /> 
            
</td>
</tr>
<tr>
<td class="th">会员级别：</td>
<td>
    <VACTL:TextBox runat="server" ID="txtLevel" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_memberlevels.aspx',true,true,300,180);"
            Width="100px"
            CanBeNull="No"
            FieldName="会员级别"
            MaxLength="30" />
    <asp:HiddenField runat="server" id="txtLevel_hiddenValue" />    
</td>
</tr>
<%--<tr>
<td class="th">推荐人卡号：</td>
<td>
    <asp:TextBox runat="server" ID="txtIntroducer" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_members.aspx',true,false,300,180);"
            Width="100px"
            MaxLength="30" />
    <asp:HiddenField runat="server" id="txtIntroducer_hiddenValue" />
</td>
</tr>
<tr>
<td class="th">客户经理：</td>
<td>
    <asp:TextBox runat="server" ID="txtSalesman" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_employees.aspx',true,false,300,180);"
            Width="100px"
            MaxLength="20" />
    <asp:HiddenField runat="server" id="txtSalesman_hiddenValue" />
</td>
</tr>--%>
<tr>
<td class="th">推荐人：</td>
<td>
    <asp:TextBox runat="server" ID="txtIntroducerName" 
            CssClass="input" 
            Width="100px"
            ReadOnly="true"
            MaxLength="30" />
    <asp:HiddenField runat="server" id="hfIntroducerID" />
    <input type="button" id="btnBrowseIntroducers" class="simpleBtn" onclick="browseIntroducers('', '')" value="浏览" />    
</td>
</tr>
<tr>
<td class="th">客户经理：</td>
<td>
    <asp:TextBox runat="server" ID="txtSalesmanName" 
            CssClass="input" 
            Width="100px"
            ReadOnly="true"
            MaxLength="20" />
    <asp:HiddenField runat="server" id="hfSalesmanCode" />
    <input type="button" id="btnBrowseEmployees" class="simpleBtn" onclick="browseEmployees()" value="浏览" />    
</td>
</tr>
<tr>
<td class="th">身份证号：</td>
<td>
    <VACTL:TextBox ID="txtIDCardNo" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="200px"
            FieldName="身份证号"
            RequiredFieldType="IDCardNum"
            MaxLength="18"
            />
</td>
</tr>
<tr>
<td class="th">联系地址：</td>
<td>
    <VACTL:TextBox ID="txtAddress" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="300px"
            FieldName="地址"
            MaxLength="50" />
</td>
</tr>
<tr>
<td class="th">备注：</td>
<td>    
	<VACTL:TextBox ID="txtRemark" Runat="server"
		 EnableViewState="False"
		 CssClass="input"
         Width="300px"
         MaxLength="100"  />	
</td>
</tr>

<tr>
<td colspan="2" class="footer">

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="重置" />

    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

