﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="member_modify.aspx.cs" Inherits="VA.Modules.JDingCYT.member.member_modify" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>会员信息修改</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        var requestType = "POST";
        var url = pageName + "?act=update";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("修改成功！", true, doAfterAct);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAct);
            }
            else {
                showActResult("修改失败：" + data, false, doAfterAct);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAct(actResult) {
        if (actResult) {
            resetPage();
        }
    }

    function resetPage() {

        clearMemberInfo();

        //姓名
        $("#txtName").val("");

        //性别；

        //生日
        $("#txtBirthDate").val("");
        
        //手机
        $("#txtMobileNo").val("");

        //微信；
        $("#txtWeixinNo").val("");

        //电话
        $("#txtPhone").val("");

        //Email
        $("#txtEmail").val("");

        //会员卡号
        $("#txtCardNo").val("");

        //身份证号
        $("#txtIDCardNo").val("");

        //地址
        $("#txtAddress").val("");

        //备注
        $("#txtRemark").val("");

        //清除错误提示样式；
        clearInputValidatorError();

        $("#btnSubmit").attr("disabled", "disabled");
    }

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc(memberInfo) {
        
        //会员ID
        $("#hfKey").val(memberInfo.memberID);

        //姓名
        $("#txtName").val(memberInfo.membername);

        //性别；
        $("#ddlSex").val(memberInfo.sex);

        //生日
        $("#txtBirthDate").val(memberInfo.birthdate);
        if (memberInfo.birthdate == "1900-01-01") {
            $("#txtBirthDate").val("");
        }

        //手机
        $("#txtMobileNo").val(memberInfo.mobileno);

        //微信；
        $("#txtWeixinNo").val(memberInfo.weixinNo);

        //Email
        $("#txtEmail").val(memberInfo.email);
        
        //身份证号
        $("#txtIDCardNo").val(memberInfo.idcardno);

        //地址
        $("#txtAddress").val(memberInfo.contactaddress);

        //备注
        $("#txtRemark").val(memberInfo.remark);

        $("#btnSubmit").removeAttr("disabled");

        //姓名
        $("#txtName").select();
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {
        
    }

    $(function () {
        if ($("#hfMemberID").val() == "") {
            $("#btnSubmit").attr("disabled", "disabled");
        }

        //焦点控制
        $("input,select").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;
                switch (targetID) {
                    case "txtName":
                        if ($("#txtName").val() != "") {
                            $("#ddlSex").focus();
                        }
                        break;
                    case "ddlSex":
                        $("#txtBirthDate").select();
                        break;
                    case "txtBirthDate":
                        $("#txtMobileNo").select();
                        break;
                    case "txtMobileNo":
                        $("#txtWeixinNo").select();
                        break;
                    case "txtWeixinNo":
                        $("#txtEmail").select();
                        break;
                    case "txtEmail": ;
                        $("#txtIDCardNo").select();
                        break;
                    case "txtIDCardNo":
                        $("#txtAddress").select();
                        break;
                    case "txtAddress":
                        $("#txtRemark").select();
                        break;
                    case "txtRemark":
                        save();
                        break;
                    default:
                        break;
                }
            }
        });
    });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:700px;">

<div class="centerFormTitle">
   <h1>会员修改</h1>
</div>

<!--#include file="../include/memberinfo.aspx"-->     

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px">
<tr>
<td class="th" colspan="2" style="font-weight:bold;text-align:left;">会员信息</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)姓名：</td>
<td>              
    <VACTL:TextBox ID="txtName" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="姓名"
            MaxLength="10" />        
</td>
</tr>
<tr>
<td class="th">性别：</td>
<td>
    <asp:DropDownList ID="ddlSex" Runat="server" Width="104px" >
    <asp:ListItem Value="男">男</asp:ListItem>
    <asp:ListItem Value="女">女</asp:ListItem>    
    </asp:DropDownList>
</td>
</tr>
<tr>
<td class="th">出生日期：</td>
<td>
    <VACTL:TextBox ID="txtBirthDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            FieldName="出生日期"
            RequiredFieldType="Date"            
            onfocus="laydate()"
            MaxLength="20" /> <span class="note">格式：yyyy-MM-dd，如：1980-01-15</span>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)手机：</td>
<td>
    <VACTL:TextBox ID="txtMobileNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="手机"
            RequiredFieldType="Mobile"
            MaxLength="11" /> 
</td>
</tr>
<tr>
<td class="th">微信：</td>
<td>
    <VACTL:TextBox ID="txtWeixinNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="200px"            
            MaxLength="50" /> 
</td>
</tr>
<tr>
<td class="th">Email：</td>
<td>
   <VACTL:TextBox ID="txtEmail" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="200px"
            FieldName="Email"
            RequiredFieldType="Email"
            MaxLength="50" /> 
            
</td>
</tr>
<%--<tr>
<td class="th">推荐人卡号：</td>
<td>
    <asp:TextBox runat="server" ID="txtIntroducer" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_members.aspx',true,false,300,180);"
            Width="100px"
            MaxLength="30" />
    <asp:HiddenField runat="server" id="txtIntroducer_hiddenValue" />
</td>
</tr>
<tr>
<td class="th">客户经理：</td>
<td>
    <asp:TextBox runat="server" ID="txtSalesman" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_employees.aspx',true,false,300,150);"
            Width="100px"
            MaxLength="20" />
    <asp:HiddenField runat="server" id="txtSalesman_hiddenValue" />
</td>
</tr>--%>
<tr>
<td class="th">身份证号：</td>
<td>
    <VACTL:TextBox ID="txtIDCardNo" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="200px"
            FieldName="身份证号"
            RequiredFieldType="IDCardNum"
            MaxLength="18"
            />
</td>
</tr>
<tr>
<td class="th">联系地址：</td>
<td>
    <VACTL:TextBox ID="txtAddress" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="300px"
            FieldName="地址"
            MaxLength="50" />
</td>
</tr>
<tr>
<td class="th">备注：</td>
<td>    
	<VACTL:TextBox ID="txtRemark" Runat="server"
		 EnableViewState="False"
		 CssClass="input"
         Width="300px"
         MaxLength="100"  />	
</td>
</tr>

<tr>
<td colspan="2" class="footer">

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="重置" />

    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

