﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="member_freeze.aspx.cs" Inherits="VA.Modules.JDingCYT.member.member_freeze" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>会员挂失</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">
    function save() {
        JTongAlertConfirm("确定要进行挂失吗？", function () {

            var requestType = "POST";
            var url = pageName + "?act=save";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();
            var successFN = function (data, textStatus) {
                var logID = "";
                if (data.substring(0, 2) == "ok") {
                    logID = data.split("|")[1];
                    showActResult("挂失成功！", true, logID);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, logID);
                }
                else {
                    showActResult("挂失失败：" + data, false, logID);
                }
            };
            ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );         

        });
    }

    //显示操作结果；
    function showActResult(sMsg, actResult, logID) {
        if (actResult) {
            JTongAlert('操作结果', sMsg, 'info', function () {
                if ($("#ckbNotify")[0].checked == true) {
                    var memberID = $("#hfMemberID").val();
                    ajaxExecute("get", "../notification/biztransaction_notify.aspx", { "biztype": "membermanage", "bizno": logID, "act": "freeze" });
                }
                resetPage();
            });
        } else {
            JTongAlert('操作结果', sMsg, 'error');
        }
    }

    function resetPage() {

        clearMemberInfo();

        $("#btnSubmit").attr("disabled", "disabled");        
    }    

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc(memberInfo) {
        
        if (memberInfo.status == "2") {            
            JTongAlert('提示', '该会员已经处于挂失状态，不能重复挂失！', 'error');
            $("#btnSubmit").attr("disabled", "disabled");
        }
        else if (memberInfo.status == "1") {
            $("#btnSubmit").removeAttr("disabled");
        }
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {
        
    }
    
    $(function () {
        if ($("#hfMemberID").val() == "") {            
            $("#btnSubmit").attr("disabled", "disabled");
        }        
    });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:700px;">

<div class="centerFormTitle">
   <h1>会员卡挂失</h1>
</div>

<!--#include file="../include/memberinfo.aspx"-->     

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" colspan="2" style="font-weight:bold;text-align:left;">操作信息</td>
</tr>
<tr>
<td class="th">当前日期：</td>
<td>    
	<% = DateTime.Now %>
</td>
</tr>
<tr>
<td class="th">操作员：</td>
<td>    
	<% = base.EmployeeName %>
</td>
</tr>
 <tr>
<td class="th">当前操作：</td>
<td>    
	<b>会员挂失</b>
</td>
</tr>
<tr>
<td colspan="2" class="footer">
    <asp:CheckBox ID="ckbNotify" runat="server"
             Text="短信通知" />    
    <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="save()" value="挂失" />
    <input type="button" id="btnClear" class="btn" style="width:80px" onclick="resetPage()" value="重置" />
 
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

