﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="member_editlist.aspx.cs" Inherits="VA.Modules.JDingCYT.member.member_editlist" %>

<%@ Import Namespace="System.Data"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>会员列表</title>    
    <!--#include virtual="/modules/cyt/include/css/editlist.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/editlist.aspx"-->  
    <script type="text/javascript">

        //添加；
        function add() {
            openTopestWindow("会员登记", "/modules/cyt/member/member_register.aspx");
        }

        //单条修改；
        function smodify(keyValue,memberName) {
            var ids = keyValue;
            openTopestWindow("会员信息修改("+ memberName +")", "/modules/cyt/member/member_modify.aspx?memberid=" + ids);
            event.stopPropagation();  //阻止事件冒泡，避免行被选中；
        }

        //单条查看详细信息；
        function sviewDetail(keyValue, memberName) {
            var ids = keyValue;
            openTopestWindow("会员详情("+ memberName +")", "/modules/cyt/member/member_detail.aspx?memberid=" + ids + "&canedit=0");
            event.stopPropagation();  //阻止事件冒泡，避免行被选中；
        }

        //导入；
        function dataImport() {
            openListSingleEditWindow(false, "会员导入", "/modules/cyt/member/member_import.aspx");
        }

        //行双击事件；
        function JTongSmartListTable_trDblclick(trObj) {
            var memberID = trObj.cells[2].innerHTML;
            var memberName = trObj.cells[4].innerHTML;
     
            sviewDetail(memberID, memberName);
            event.stopPropagation();  //阻止事件冒泡，避免行被选中；
        }

        //显示汇总金额；
        function afterDataListLoaded() {
            $("#statBar").html($("#divStatInfo").html());
        }

        $(function () {
            //isAutoAdjustSearchBar = true;
            initListPage();

            //账户余额======================================
            var $ddlAccountBalanceOperator = $("#ddlAccountBalanceOperator");
            if ($ddlAccountBalanceOperator.val() == "") {
                $("#txtAccountBalance").attr("disabled", "disabled");
            }
            $ddlAccountBalanceOperator.change(function () {
                if ($ddlAccountBalanceOperator.val() == "") {
                    $("#txtAccountBalance").val("");
                    $("#txtAccountBalance").attr("disabled", "disabled");
                } else {
                    $("#txtAccountBalance").removeAttr("disabled");
                }
            });

            //剩余积分======================================
            var $ddlPointOperator = $("#ddlPointOperator");
            if ($ddlPointOperator.val() == "") {
                $("#txtPoints").attr("disabled", "disabled");
            }
            $ddlPointOperator.change(function () {
                if ($ddlPointOperator.val() == "") {
                    $("#txtPoints").val("");
                    $("#txtPoints").attr("disabled", "disabled");
                } else {
                    $("#txtPoints").removeAttr("disabled");
                }
            });
        });
    </script>

</head>
<body>
<!--说明：该页面是以 employee_editlist_nofresh_5.aspx 为原型封装的结果-->
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper">        
    
    <div id="toolBar">                          
        <a href="javascript:add()" class="jtongui-toolbarbutton" icon="icon-add">会员登记</a>
        <a href="javascript:dataImport()" class="jtongui-toolbarbutton" icon="icon-import">导入</a>                   
        <asp:LinkButton ID="lbnExportToExcel" runat="server" CssClass="jtongui-toolbarbutton" icon="icon-export" OnClick="lbnExportToExcel_Click">导出</asp:LinkButton>
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>                   
    </div><!--toolBar.END-->   

    <div id="noteBar">
        <p>说明：1）“累计充值”不包含充值时赠送的金额；<%--2）“累计消费”不包含计次卡划次消费和赠品划次消费；3）“累计受赠”不包含受赠的代金券金额；</p>--%>
    </div>
                     
    <div id="searchBar">
    
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>

        <asp:DropDownList ID="ddlMemberStatus" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlMemberStatus_SelectedIndexChanged">           
        </asp:DropDownList>                           
        <asp:DropDownList ID="ddlMemberLevel" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlMemberLevel_SelectedIndexChanged">           
        </asp:DropDownList>
            
        <asp:DropDownList ID="ddlSearchField" runat="server" EnableViewState="false">
        <asp:ListItem Value="">检索字段</asp:ListItem>
        <asp:ListItem Value="1">会员卡号</asp:ListItem>
        <asp:ListItem Value="2">手机号</asp:ListItem>
        <asp:ListItem Value="3">姓名</asp:ListItem>
        <asp:ListItem Value="4">会员ID</asp:ListItem>
        <asp:ListItem Value="5">会员生日</asp:ListItem>
        <asp:ListItem Value="6">办卡人</asp:ListItem>
        <asp:ListItem Value="7">推荐人ID</asp:ListItem>
        <asp:ListItem Value="8">客户经理</asp:ListItem>
 <%--       <asp:ListItem Value="9">办卡门店</asp:ListItem>        --%>    
        </asp:DropDownList>               
                 
        <%--<asp:DropDownList ID="ddlSearchType" runat="server" EnableViewState="false">
        <asp:ListItem Value="1">模糊匹配</asp:ListItem>
        <asp:ListItem Value="2">精确匹配</asp:ListItem>
        </asp:DropDownList>               --%>

        <asp:TextBox ID="txtKeyWords" runat="server"
            CssClass="input keywords"
            Width="100px" />
   
        <asp:DropDownList ID="ddlDateRule" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">办卡日期</asp:ListItem>
        <asp:ListItem Value="1">今天</asp:ListItem>
            <asp:ListItem Value="2">昨天</asp:ListItem>
            <asp:ListItem Value="3">前天</asp:ListItem>
            <asp:ListItem Value="4">近两天</asp:ListItem>
            <asp:ListItem Value="5">近三天</asp:ListItem>
            <asp:ListItem Value="6">近一周</asp:ListItem>
            <asp:ListItem Value="7">近一月</asp:ListItem>
            <asp:ListItem Value="8">上月</asp:ListItem>
            <asp:ListItem Value="9">本月</asp:ListItem>
            <asp:ListItem Value="10">自定义</asp:ListItem>
        </asp:DropDownList>    

        <VACTL:TextBox ID="txtBeginDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />  
        -      
        <VACTL:TextBox ID="txtEndDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />       

        <asp:DropDownList ID="ddlAccountBalanceOperator" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">账户余额</asp:ListItem>
        <asp:ListItem Value="<"><</asp:ListItem>
        <asp:ListItem Value="<="><=</asp:ListItem>
        <asp:ListItem Value="=">=</asp:ListItem>
        <asp:ListItem Value=">">></asp:ListItem>
        <asp:ListItem Value=">=">>=</asp:ListItem>
        </asp:DropDownList>  
        <VACTL:TextBox ID="txtAccountBalance" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="40px"            
            MaxLength="10"
            RequiredFieldType="Money" />  

        <asp:DropDownList ID="ddlPointOperator" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">剩余积分</asp:ListItem>
        <asp:ListItem Value="<"><</asp:ListItem>
        <asp:ListItem Value="<="><=</asp:ListItem>
        <asp:ListItem Value="=">=</asp:ListItem>
        <asp:ListItem Value=">">></asp:ListItem>
        <asp:ListItem Value=">=">>=</asp:ListItem>
        </asp:DropDownList>  
        <VACTL:TextBox ID="txtPoints" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="40px"            
            MaxLength="10"
            RequiredFieldType="Integer" /> 

        <asp:DropDownList ID="ddlOrderBy" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlOrderBy_SelectedIndexChanged">
        <asp:ListItem Value="">排序规则</asp:ListItem>
        <asp:ListItem Value="MemberID|ASC">按建卡顺序-正序</asp:ListItem>
        <asp:ListItem Value="MemberID|DESC">按建卡顺序-倒序</asp:ListItem>
        <asp:ListItem Value="Account_Balance|DESC">按账户余额-由多到少</asp:ListItem>
        <asp:ListItem Value="Account_Balance|ASC">按账户余额-由少到多</asp:ListItem>
        <asp:ListItem Value="Account_Points|DESC">按剩余积分-由多到少</asp:ListItem>
        <asp:ListItem Value="Account_Points|ASC">按剩余积分-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_Charge_Amount|DESC">按累计充值-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_Charge_Amount|ASC">按累计充值-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_Withdraw_Amount|DESC">按累计提现-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_Withdraw_Amount|ASC">按累计提现-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_Consume_Amount|DESC">按累计消费-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_Consume_Amount|ASC">按累计消费-由少到多</asp:ListItem>
        <%--<asp:ListItem Value="Total_PointCardCharge_Amount|DESC">按累计充次-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_PointCardCharge_Amount|ASC">按累计充次-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_PointCardConsume_Amount|DESC">按累计划次-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_PointCardConsume_Amount|ASC">按累计划次-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_BeDonated_Amount|DESC">按累计受赠-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_BeDonated_Amount|ASC">按累计受赠-由少到多</asp:ListItem>
        <asp:ListItem Value="Total_DonatedConsume_Amount|DESC">按赠品划次-由多到少</asp:ListItem>
        <asp:ListItem Value="Total_DonatedConsume_Amount|ASC">按赠品划次-由少到多</asp:ListItem>--%>
        </asp:DropDownList>             
         
        <asp:Button ID="btnSearch" runat="server" 
             CssClass="simpleBtn"
             Text="查询" 
             Onclick="btnSearch_Click" />
        
        </ContentTemplate>
        </asp:UpdatePanel>

    </div><!--searchBar.END-->    

    <div id="dataBar">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <td style="width:30px;text-align:center;">No.</td>
        <td style="width:30px;text-align:center;">详情</td>	    	 
        <td style="width:70px;text-align:center;">会员ID</td>
        <td style="width:70px;text-align:center;">卡号</td>
        <td style="width:70px;text-align:center;">姓名</td>        
        <td style="width:70px;text-align:center;">手机号</td>
        <td style="width:70px;text-align:center;">出生日期</td>
        <td style="width:60px;text-align:center;">账户余额</td>
        <td style="width:60px;text-align:center;">累计充值</td>
        <td style="width:60px;text-align:center;">累计提现</td>
        <td style="width:60px;text-align:center;">累计消费</td>
     <%--   <td style="width:60px;text-align:center;">累计充次</td>
        <td style="width:60px;text-align:center;">累计划次</td>
        <td style="width:60px;text-align:center;">累计受赠</td>
        <td style="width:60px;text-align:center;">赠品划次</td>--%>
        <td style="width:70px;text-align:center;">会员等级</td>	 	 
        <td style="width:70px;text-align:center;">当前积分</td>	 
        <td style="width:80px;text-align:center;">办卡时间</td>
        <td style="width:70px;text-align:center;">办卡人</td>
        <td style="width:100px;text-align:center;display:none;">办卡门店</td>
        <td style="width:70px;text-align:center;">推荐人ID</td>
        <td style="width:70px;text-align:center;">推荐人姓名</td>
	    <td style="width:70px;text-align:center;">客户经理</td>	       	    
	    <td style="width:70px;text-align:center;">会员状态</td>        
        <td style="width:30px;text-align:center;">修改</td>
        <td></td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>    
    <table cellpadding="3" cellspacing="0" class="tablebody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td align="center"><%# (base.currPage - 1)*base.PageSize + Container.ItemIndex + 1%></td>
        <td align="center">
            <a href="#" onclick="javascript:sviewDetail('<%# Eval("MemberID")%>','<%# Eval("Member_Name")%>');"><img src="/admin/icons/detail.png" alt="详情"/>  </a>
        </td>              	       	     
        <td align="center"><%# Eval("MemberID")%></td>
        <td align="center"><%# Eval("CardNo")%></td>
        <td align="left"><%# Eval("Member_Name")%></td>
        <td align="center"><%# Eval("MobileNo")%></td>   
        <td align="center"><%# VA.Utils.DateHelper.GetDateStringFormatNullDate(String.Format("{0:yyyy-MM-dd}", Eval("BirthDate")))%></td>             
        <td align="right"><%# Convert.ToDecimal(Eval("Account_Balance")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_Charge_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_Withdraw_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_Consume_Amount")).ToString("F2")%></td>
       <%-- <td align="right"><%# Convert.ToDecimal(Eval("Total_PointCardCharge_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_PointCardConsume_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_BeDonated_Amount")).ToString("F2")%></td>
        <td align="right"><%# Convert.ToDecimal(Eval("Total_DonatedConsume_Amount")).ToString("F2")%></td>--%>
        <td align="center"><%# Eval("Level_Name")%></td>
        <td align="center"><%# Eval("Account_Points")%></td>                
        <td align="center"><%# String.Format("{0:yyyy-MM-dd}",Eval("Create_Date"))%></td>
        <td align="left"><%# Eval("Operator_Name")%></td>
        <td align="left" style="display:none;"><%# Eval("Shop_Name")%></td>
	    <td align="center"><%# Eval("Introducer_ID")%></td>
        <td align="center"><%# Eval("Introducer_Name")%></td>
        <td align="left"><%# Eval("Salesman_Name")%></td>        
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.MemberStatusConverter.Convert_Value_ToText(Eval("Status").ToString(),true)%></td>                                
        <td align="center">
            <a href="#" onclick="javascript:smodify('<%# Eval("MemberID")%>','<%# Eval("Member_Name")%>');"><img src="/admin/icons/edit.png" alt="修改"/>  </a>
        </td>              	       	           
        <td></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <div id="divPagerInfo" style="display:none">
        <%=base.pageInfo%>
    </div>

    <div id="divStatInfo" style="display:none">
        共 <span style="font-weight:bold;"><%=base.RdCnt%></span> 个会员，账户余额合计：<span style="font-weight:bold;"><%= base.TotalAccountBalance.ToString("F2")%></span>&nbsp;&nbsp;
    </div>

    <input type="hidden" id="hidden_pageCnt" value="<% = base.PageCnt%>" />
    <input type="hidden" id="hidden_rdCnt" value="<% = base.RdCnt%>" />
    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

    <div id="statBar">
       
    </div><!--statBar.END-->

    <div id="pagerBar">
       ……
    </div><!--pageNavBar.END-->
    
    <asp:HiddenField runat="server" ID="hfCurrPage" EnableViewState="true" />
    
</div>

</form>
</body>
</html> 