﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="member_change_salesman.aspx.cs" Inherits="VA.Modules.JDingCYT.member.member_change_salesman" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>变更客户经理</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

    function save() {
        var requestType = "POST";
        var url = pageName + "?act=update";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("变更成功！", true, doAfterAct);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAct);
            }
            else {
                showActResult("变更失败：" + data, false, doAfterAct);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAct(actResult) {
        if (actResult) {
            resetPage();
        }
    }

    function resetPage() {

        clearMemberInfo();

        //会员ID
        $("#hfKey").val("");

        //原客户经理
        $("#lblOldSalesmanName").html("");
        $("#hfOldSalesmanCode").val("");

        //新客户经理
        $("#txtSalesmanCode").val("");
        $("#txtSalesmanName").val("");

        $("#btnSubmit").attr("disabled", "disabled");
        $("#btnBrowseEmployees").attr("disabled", "disabled");      
    }

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc(memberInfo) {
        
        //会员ID
        $("#hfKey").val(memberInfo.memberID);

        //原客户经理
        $("#lblOldSalesmanName").html(memberInfo.salesmanname);
        $("#hfOldSalesmanCode").val(memberInfo.salesmancode);
        
        $("#btnSubmit").removeAttr("disabled");
        $("#btnBrowseEmployees").removeAttr("disabled");
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {
        
    }

    //浏览新客户经理列表；
    function browseEmployees(keywords) {
        var shopCode = $("#hfShopCode").val();
        openFrameWindow("员工列表", 730, 419, "../datasrc/get_employee_list.aspx?shopcode=" + shopCode);
    }

    //从弹窗窗口中获取新客户经理信息
    function takeEmployeeInfo(trObj) {
        closeFrameWindow();

        var employeeCode = $(trObj).find("td.employeeCode").eq(0).html();
        var employeeName = $(trObj).find("td.employeeName").eq(0).html();
        
        $("#hfSalesmanCode").val(employeeCode);
        $("#txtSalesmanName").val(employeeName);
    }

    $(function () {
        if ($("#hfMemberID").val() == "") {
            $("#btnSubmit").attr("disabled", "disabled");
            $("#btnBrowseEmployees").attr("disabled", "disabled");
        }
    });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:700px;">

<div class="centerFormTitle">
   <h1>变更客户经理</h1>
</div>

<!--#include file="../include/memberinfo.aspx"-->     

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px">
<tr>
<td class="th" colspan="2" style="font-weight:bold;text-align:left;">客户经理信息</td>
</tr>
<tr>
<td class="th">原客户经理：</td>
<td>   
    <asp:Label ID="lblOldSalesmanName" runat="server"></asp:Label>
    <asp:HiddenField runat="server" id="hfOldSalesmanCode" />
</td>
</tr>
<tr>
<td class="th">新客户经理：</td>
<td>
    <asp:TextBox runat="server" ID="txtSalesmanName" 
            CssClass="input"             
            Width="100px"
            ReadOnly="true"
            MaxLength="30" />
    <asp:HiddenField runat="server" id="hfSalesmanCode" />
    <asp:HiddenField runat="server" id="hfShopCode" />
    <input type="button" id="btnBrowseEmployees" class="simpleBtn" onclick="browseEmployees()" value="浏览" />    
</td>
</tr>
<tr>
<td colspan="2" class="footer">

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnReset" class="btn" style="width:80px" onclick="resetPage()" value="重置" />

    <asp:HiddenField ID="hfKey" runat="server" />   
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

