﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="member_change_introducer.aspx.cs" Inherits="VA.Modules.JDingCYT.member.member_change_introducer" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>变更推荐人</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

    function save() {
        var requestType = "POST";
        var url = pageName + "?act=update";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("变更成功！", true, doAfterAct);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAct);
            }
            else {
                showActResult("变更失败：" + data, false, doAfterAct);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAct(actResult) {
        if (actResult) {
            resetPage();
        }
    }

    function resetPage() {

        clearMemberInfo();

        //会员ID
        $("#hfKey").val("");

        //原推荐人
        $("#lblOldIntroducerID").html("");
        $("#hfOldIntroducerID").val("");
        $("#lblOldIntroducerName").html("");

        //新推荐人
        $("#txtIntroducerID").val("");
        $("#txtIntroducerName").val("");

        $("#btnSubmit").attr("disabled", "disabled");
        $("#btnBrowseIntroducers").attr("disabled", "disabled");        
    }

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc(memberInfo) {
        
        //会员ID
        $("#hfKey").val(memberInfo.memberID);

        //原推荐人
        $("#lblOldIntroducerID").html(memberInfo.introducerid);
        $("#hfOldIntroducerID").val(memberInfo.introducerid);
        $("#lblOldIntroducerName").html(memberInfo.introducername);
        
        $("#btnSubmit").removeAttr("disabled");
        $("#btnBrowseIntroducers").removeAttr("disabled");
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {

    }

    //浏览新推荐人列表；
    function browseIntroducers(keyType, keyValue) {
        if (keyType == "cardno") {
            keyType = "1";
        }
        else if (keyType == "mobileno") {
            keyType = "2";
        }
        openFrameWindow("会员列表", 730, 419, "../datasrc/get_memberlist.aspx?searchfield=" + keyType + "&keywords=" + keyValue + "&callback=takeIntroducerInfo");
    }

    //从弹窗窗口中获取新推荐人信息
    function takeIntroducerInfo(trObj) {        
        var memberID = $(trObj).find("td.memberid").eq(0).html();
        var memberName = $(trObj).find("td.membername").eq(0).html();
    
        if (memberID == $("#hfMemberID").val()) {
            JTongAlert("提示", "新推荐人不能是会员自己！", "warning");
        } else if (memberID == $("#hfOldIntroducerID").val()) {
            JTongAlert("提示", "新推荐人与原推荐人不能相同！", "warning");
        }
        else {
            $("#txtIntroducerID").val(memberID);
            $("#txtIntroducerName").val(memberName);
        }
        closeFrameWindow();
    }

    $(function () {
        if ($("#hfMemberID").val() == "") {
            $("#btnSubmit").attr("disabled", "disabled");
            $("#btnBrowseIntroducers").attr("disabled", "disabled");            
        }
    });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:700px;">

<div class="centerFormTitle">
   <h1>变更推荐人</h1>
</div>

<!--#include file="../include/memberinfo.aspx"-->     

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px">
<tr>
<td class="th" colspan="4" style="font-weight:bold;text-align:left;">推荐人信息</td>
</tr>
<tr>
<td class="th">原推荐人姓名：</td>
<td>   
    <asp:Label ID="lblOldIntroducerName" runat="server"></asp:Label>
</td>
<td class="th">原推荐人ID：</td>
<td style="width:228px;">   
    <asp:Label ID="lblOldIntroducerID" runat="server"></asp:Label>
    <asp:HiddenField runat="server" id="hfOldIntroducerID" />
</td>
</tr>
<tr>
<td class="th">新推荐人姓名：</td>
<td>   
    <asp:TextBox runat="server" ID="txtIntroducerName" 
            CssClass="input" 
            Width="100px"
            ReadOnly="true"
            MaxLength="30" />    
    <input type="button" id="btnBrowseIntroducers" class="simpleBtn" onclick="browseIntroducers('', '')" value="浏览" />    
</td>
<td class="th">新推荐人ID：</td>
<td>
    <asp:TextBox runat="server" ID="txtIntroducerID" 
            CssClass="input" 
            Width="100px"
            ReadOnly="true"
            MaxLength="30" />        
</td>
</tr>
<tr>
<td colspan="4" class="footer">

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnReset" class="btn" style="width:80px" onclick="resetPage()" value="重置" />

    <asp:HiddenField ID="hfKey" runat="server" />   
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

