﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using VA.Utils;
using VA.Modules.JDingCYT.Core.Business.Goods;
using VA.Modules.JDingCYT.Core.Config;
using VA.Modules.JDingCYT.Core.Model.Goods;
using VA.Modules.JDingCYT.WebBase;
using System.Data;

namespace VA.Modules.JDingCYT.mainbiz
{
    public partial class uc_foodmenu : System.Web.UI.UserControl
    {
        public string ShopCode
        {
            get;
            set;
        }

        public int MainHeight
        {
            get { return _MainHeight; }
            set { _MainHeight = value; }
        }
        int _MainHeight = 400;

        ChargeItemCategoryDict category = new ChargeItemCategoryDict();
        ChargeItemDict chargeItem = new ChargeItemDict();

        DataTable dtbCategoryAll;
        DataTable dtbChargeItemAll;

        DataTable dtbFoodCategory;
        DataTable dtbChargeItemCategory;
        DataTable dtbFood;
        DataTable dtbChargeItem;
        
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                this.dtbCategoryAll = category.GetDataList("Status='" + Core.Enums.ChargeItemCategoryStatus.Enabled.ToString("d") + "'", "Category_Code ASC");
                this.dtbChargeItemAll = chargeItem.GetDataList("Item_Code<>'" + Core.Enums.ConsumeCharge.SimpleConsumeCharge.ITEM_CODE + "' AND Item_Code<>'" + Core.Enums.ConsumeCharge.FreeDiscountItemInfo.ITEM_CODE + "' AND (Shop_Code='" + this.ShopCode + "' OR Shop_Code='" + Core.Enums.GlobalVariables.GLOBAL_SHOP_CODE + "')", "Item_Code ASC");

                if (this.dtbCategoryAll != null && this.dtbChargeItemAll != null)
                {
                    DataRow[] foodCategoryRows = this.dtbCategoryAll.Select("Item_Type='" + Core.Enums.ChargeItemType.Food.ToString("d") + "'", "Category_Code ASC");
                    DataRow[] foodRows = this.dtbChargeItemAll.Select("Item_Type='" + Core.Enums.ChargeItemType.Food.ToString("d") + "'", "Input_Code ASC");
                    DataRow[] chargeItemCategoryRows = this.dtbCategoryAll.Select("Item_Type='" + Core.Enums.ChargeItemType.Product.ToString("d") + "' OR Item_Type='" + Core.Enums.ChargeItemType.ServiceItem.ToString("d") + "'", "Category_Code ASC");
                    DataRow[] chargeItemRows = this.dtbChargeItemAll.Select("Item_Type='" + Core.Enums.ChargeItemType.Product.ToString("d") + "'", "Input_Code ASC");

                    if (foodCategoryRows != null && foodCategoryRows.Length > 0)
                    {
                        this.dtbFoodCategory = foodCategoryRows.CopyToDataTable();
                    }
                    if (chargeItemCategoryRows != null && chargeItemCategoryRows.Length > 0)
                    {
                        this.dtbChargeItemCategory = chargeItemCategoryRows.CopyToDataTable();
                    }
                    if (foodRows != null && foodRows.Length > 0)
                    {
                        this.dtbFood = foodRows.CopyToDataTable();
                    }
                    if (chargeItemRows != null && chargeItemRows.Length > 0)
                    {
                        this.dtbChargeItem = chargeItemRows.CopyToDataTable();
                    }

                    if (this.dtbFoodCategory != null)
                    {
                        this.rpFoodCategory.DataSource = this.dtbFoodCategory;
                        this.rpFoodCategory.DataBind();
                    }
                    if (this.dtbChargeItemCategory != null)
                    {
                        this.rpChargeItemCategory.DataSource = this.dtbChargeItemCategory;
                        this.rpChargeItemCategory.DataBind();
                    }
                }
            }
        }

        protected void rpFoodCategory_ItemDataBound(object sender, System.Web.UI.WebControls.RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                Repeater rpFoodDict = (Repeater)e.Item.FindControl("rpFoodDict");

                //找到分类Repeater关联的数据项 
                DataRowView rowv = (DataRowView)e.Item.DataItem;

                //提取分类ID 
                string parentCode = rowv["Category_Code"].ToString();

                //从用户的所有节点权限集中筛选出数据该模块（模块ID为 moduleID ）的节点权限；
                if (this.dtbFood != null)
                {
                    DataRow[] rows = this.dtbFood.Select("Category_Code='" + parentCode + "'");
                    if (rows != null && rows.Length > 0)
                    {
                        DataTable dtbData = rows.CopyToDataTable();

                        rpFoodDict.DataSource = dtbData;
                        rpFoodDict.DataBind();
                    }
                }
            }
        }

        protected void rpChargeItemCategory_ItemDataBound(object sender, System.Web.UI.WebControls.RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                Repeater rpChargeItemDict = (Repeater)e.Item.FindControl("rpChargeItemDict");

                //找到分类Repeater关联的数据项 
                DataRowView rowv = (DataRowView)e.Item.DataItem;

                //提取分类ID 
                string parentCode = rowv["Category_Code"].ToString();

                //从用户的所有节点权限集中筛选出数据该模块（模块ID为 moduleID ）的节点权限；
                if (this.dtbChargeItem != null)
                {
                    DataRow[] rows = this.dtbChargeItem.Select("Category_Code='" + parentCode + "'");
                    if (rows != null && rows.Length > 0)
                    {
                        DataTable dtbData = rows.CopyToDataTable();

                        rpChargeItemDict.DataSource = dtbData;
                        rpChargeItemDict.DataBind();
                    }
                }
            }
        }

        protected string ShowLetterIndex(string inputCode)
        {
            if (!String.IsNullOrEmpty(inputCode))
            {
                return inputCode.Substring(0, 1).ToUpper();
            }
            else
            {
                return "";
            }
        }
    }
}