﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="food_edit.aspx.cs" Inherits="VA.Modules.JDingCYT.mainbiz.food_edit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <link href="/uicontrols/jtongui/themes/<% = webSiteConfig.ThemeName %>/tabs.css" type="text/css" rel="Stylesheet" />
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript" src="/uicontrols/jtongui/plugins/jtong.tabs.js"></script>
    <script type="text/javascript">
    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        var commisionType = $("#ddlCommisionType").val();
        var commisionXS = $("#txtCommisionXS").val();
        var discount = $("#txtMemberDiscount").val();
        if (commisionType == "1") { //按比例计提

            if (parseInt(commisionXS) > 1) {
                JTongAlert("提示", "当提成类型为按比例计提时，提成系数不能大于1","info");
                return;
            }
        }
        if (discount != "") {
            if (parseFloat(discount) > 1) {
                JTongAlert("提示", "会员折扣不能大于1.", "info");
                return;
            }
        }

        var flag = "0";
        if ($("#hfKey").val() != "") {
            flag = "1";
        }

        if (flag == 0) {
            add();
        }
        else {
            update();
        }
    }

    function add() {
        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("添加成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("添加失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function update() {
        var requestType = "POST";
        var url = pageName + "?act=update";
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("修改成功！", true, doAfterUpdate);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterUpdate);
            }
            else {
                showActResult("修改失败：" + data, false, doAfterUpdate);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            try{
                if (window.parent != window.self) {
                    window.parent.completeReload();
                }
            }catch(e){}
            resetPage();
        }
    }
    function doAfterUpdate(actResult) {
        if (actResult) {
            try{
                if (window.parent != window.self) {
                    window.parent.closeFrameWindow();
                    window.parent.completeReload();
                }
            }catch(e){}
        }
    }

    function resetPage() {

        var newItemCode = ajaxGetData("../goods/chargeitem_get_newitemcode.aspx", "html", null);
        $("#txtItemCode").val(newItemCode);
        $("#txtItemName").val("");
        $("#txtInputCode").val("");
        $("#txtUnit").val("");
        $("#txtUnit_hiddenValue").val("");
        $("#txtPrice").val("");
        $("#txtRemark").val("");
       
        clearInputValidatorError();

        $("#txtItemName").focus();
    }

    function JTongSmartDropDownList_AfterTakeValue(JTongSmartDropDownList_inputObjID, selectedRow) {
        if (selectedRow != null) {

            if (JTongSmartDropDownList_inputObjID == "txtUnit") {
                $("#txtPrice").focus();
            }
        }

        //返回true，继续取值；返回false，取消取值；
        return true;
    }

    function ddlCommisionTypeChange_Handler() {
        var commisionType = $("#ddlCommisionType").val();
        if (commisionType == "0") { //不计提
            $("#txtCommisionXS").val("0");
            $("#txtCommisionXS").attr("disabled", "disabled");
        } else {
            $("#txtCommisionXS").removeAttr("disabled");
            $("#txtCommisionXS").select();
        }
    }

    function uploadImage() {
        openFrameWindow("上传图片", 500, 220, "../goods/chargeitem_edit_uploadpic.aspx", false);
    }

    function takeImage(thumpicFileName) {
        $("#txtItemImage").val(thumpicFileName);
        closeFrameWindow();
    }

    function setLayout() {
        var windowHeight = $(window).outerHeight();
        var titleHeight = $(".centerFormTitle").outerHeight();
        var toolBarHeight = $("#tbToolBar").outerHeight();
        var mainHeight = windowHeight - titleHeight - toolBarHeight - 30;

        $("#divMainContainer").height(mainHeight);
    }

    $(function () {
        $("#ddlCategory").focus();
        $("#txtItemName").keyup(function (event) {
            var itemName = $(this).val();
            if ($.trim(itemName) == "") {
                return;
            }
            if (event.keyCode != 13) {
                var requestType = "GET";
                var url = "../smartdropdownlist_datasrc/get_inputcode.aspx";
                var dataType = "html";
                var data = { keywords: itemName };
                var successFN = function (data, textStatus) {
                    $("#txtInputCode").val(data);
                };
                ajaxRequest(requestType,
                    url,
                    dataType,
                    data,
                    successFN,
                    errorFN
                    );
            }
        });

        $("#ddlCommisionType").change(function () {
            ddlCommisionTypeChange_Handler();
        });
        ddlCommisionTypeChange_Handler();

        setLayout();
        JTongTabs_init();

        //焦点控制
        //$("input:not(#txtUnit),select").keydown(function (event) {
        $("input,select").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;
                switch (targetID) {
                    case "ddlCategory":
                        $("#txtItemName").focus();
                        break;
                    case "txtItemCode":
                        $("#txtItemName").focus();
                        break;
                    case "txtItemName":
                        if ($("#txtItemName").val() != "") {
                            $("#txtPrice").focus();
                        }
                        break;
                    //case "txtUnit":
                    //    if ($("#txtUnit").val() != "") {
                    //        $("#txtPrice").select();
                    //    }
                    //    break;
                    case "txtPrice":
                        if ($("#txtPrice").val() != "") {
                            $("#ddlCommisionType").focus();
                        }                        
                        break;
                    case "ddlCommisionType":
                        var commisionType = $("#ddlCommisionType").val();
                        if (commisionType == "0") { //不计提
                            $("#txtMemberDiscount").select();
                        } else {
                            $("#txtCommisionXS").select();
                        }                        
                        break;
                    case "txtCommisionXS":
                        $("#txtMemberDiscount").select();
                        break;
                    case "txtMemberDiscount":
                        $("#txtMemberPrice").select();
                        break;
                    case "txtMemberPrice":
                        $("#ddlIsBackProcess").focus();
                        break;
                    case "ddlIsBackProcess":
                        $("#ddlStars").focus();
                        break;
                    case "ddlStars":
                        save();
                        break;
                    default:
                        break;
                }
            }
        });
    });

    </script>

    <script type="text/javascript">

        function addSubItems() {
            openFrameWindow("选择项目", 660, 419, "food_edit_getchargeitems.aspx?callback=takeChargeItems");
        }

        function takeChargeItems(rowArray) {
            for (var i = 0; i < rowArray.length; i++) {
                var $row = $(rowArray[i]);
                var itemType = $row.find("input[name=hfItemType]").eq(0).val();
                var itemCategory = $row.find("input[name=hfItemCategory]").eq(0).val();
                var itemCode = $row.find("td.itemCode").eq(0)[0].innerHTML;
                var itemName = $row.find("td.itemName").eq(0)[0].innerHTML;
                var unit = $row.find("td.unit").eq(0)[0].innerHTML;
                var purchasePrice = $row.find("td.purchasePrice").eq(0)[0].innerHTML;
                var quantity = "1.0";
          
                formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, purchasePrice, quantity);
            }
            closeFrameWindow();
        }

        var formEditListTable_RowCounter = 0;
        function formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity) {

            formEditListTable_RowCounter++;

            var $srcTable = $("#srcTable");
            var srcTableID = $srcTable.attr("id");

            //如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
            if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
                return;
            }

            var rowHtml = '';
            var $row = null;
            var rowCnt = $srcTable[0].rows.length;
            var rowID = formEditListTable_RowCounter;

            itemName = itemName.replace(/'/g, "‘");
            unit = unit.replace(/'/g, "‘");

            var amount = (price * quantity).toFixed(2).toString(); //优惠前金额

            rowHtml += '<tr id="tr_' + rowID + '">';
            rowHtml += '<td style="text-align:center;" class="tdRowNo"></td>';

            rowHtml += '<td style="text-align:left;padding-left:5px;">';
            rowHtml += '<span>' + itemName + '</span>';
            //rowHtml += '<span>' + price + '</span>';
            rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
            rowHtml += '<input type="hidden" name="hfItemCategory" value="' + itemCategory + '" />';
            rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
            rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" id="hfItemCode_' + rowID + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + unit + '</span>';
            rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span style="font-weight:bold;">' + price + '</span>';
            rowHtml += '<input type="hidden" name="hfPrice" value="' + price + '" id="hfPrice_' + rowID + '" />';
            rowHtml += '</td>';

            rowHtml += '<td><input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" /></td>';

            rowHtml += '<td style="text-align:right;padding-right:1px;">';
            rowHtml += '<span style="font-weight:bold;" id="spanAmount_' + rowID + '">' + amount + '</span>';
            rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;"><a href="javascript:formEditListTable_removeRow(' + rowID + ')">删除</a></td>';
            rowHtml += '<td style="text-align:center;"></td>';

            rowHtml += '</tr>';

            $row = $(rowHtml);
            $srcTable.append($row);

            formEditListTable_setRowNo();
            formEditListTable_setTotalAmount();
            formEditListTable_hideTbNoRecord();
        }

        function formEditListTable_setTotalAmount() {
            
        }

        function formEditListTable_caculateAmount(rowID) {
            var $txtQuantity = $("#txtQuantity_" + rowID);
            var $txtPrice = $("#hfPrice_" + rowID);
            var $spanDiscount = "";
            var sQuantity = $txtQuantity.val();
            var sPrice = $txtPrice.val();
            var amount = 0.00; //优惠前

            if (sQuantity == "") {
                sQuantity = "0";
            }
            if (sPrice == "") {
                sPrice = "0";
            }

            ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
            //clearNoNum($txtQuantity[0]);
            //clearNoNum($txtPrice[0]);

            if (isNaN(sQuantity)) {
                alert("数量为无效数字！");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
            if (isNaN(sPrice)) {
                alert("单价为无效数字.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }
            if (parseFloat(sQuantity) > 100000 || parseFloat(sQuantity) < 0) {  //限制数量不能超过100000
                alert("数量不能小于0或超过100000.");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
            if (parseFloat(sPrice) > 100000 || parseFloat(sPrice) < 0) {  //单价不能超过100000
                alert("单价不能小于0或超过100000.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }

            if ($txtQuantity.hasClass("error")) {
                $txtQuantity.removeClass("error");
            }
            if ($txtPrice.hasClass("error")) {
                $txtPrice.removeClass("error");
            }

            amount = parseFloat(sQuantity) * parseFloat(sPrice);

            $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());
            $("#spanAmount_" + rowID).html(amount.toFixed(2).toString());

            formEditListTable_setTotalAmount();
        }

        function formEditListTable_checkTableData() {

            var result = true;

            var dataRowCount = 0;
            var $srcTable = $("#srcTable");

            $srcTable.find("input[name=txtQuantity]").each(function () {
                dataRowCount++;
                var sQuantity = $(this).val();
                if ($.trim(sQuantity) == "" || $.trim(sQuantity) == "0") {
                    alert("数量不能为空或0！");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });
            $srcTable.find("input[name=txtPrice]").each(function () {
                var sPrice = $(this).val();
                if ($.trim(sPrice) == "") {
                    alert("单位成本不能为空！");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });

            return result;
        }

        function clearItems() {
            formEditListTable_clearRows();
        }

    </script>


    <style type="text/css">  
    .editTable .th{
        width:100px;
    }
    </style>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:650px;">

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">添加菜品</asp:Label></h1>
</div>

<div id="divMainContainer" style="margin-top:-1px;">
    <div class="jtongui-tabs" fill="true">
	    <ul class="header">
		    <li class="tabheader-item-selected"><a>基本信息</a></li>        
		    <li>菜品详情</li>		                
            <li>菜品配料</li>		                
	    </ul>
	    <div id="div_BasicInfo" class="tabcontent tabcontent-selected" style="padding:3px;">
	        <table cellspacing="0" cellpadding="3" class="editTable">
            <tr id="trEditResult" runat="server" visible="false">
            <td colspan="2" style="text-align:center;">
                <div class="editResult">
                <asp:Literal id="litEditResult" runat="server" />
                </div>
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)所属分类：</td>
            <td>
                <asp:DropDownList ID="ddlCategory" Runat="server" Width="104px" >    
                </asp:DropDownList>
                <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server"
                     ControlToValidate="ddlCategory"
                     ErrorMessage="[所属分类]必须选择一项！" />
            </td>
            </tr>
            <tr style="display:none;">
            <td class="th">(<span class="note mustfill">*</span>)菜品代码：</td>
            <td>              
                <VACTL:TextBox ID="txtItemCode" Runat="server"
                        EnableViewState="False"
                        CssClass="input"
                        Width="100px"
                        CanBeNull="No"
                        FieldName="菜品代码"            
                        ReadOnly="true"
                        MaxLength="10" />        
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)菜品名称：</td>
            <td>              
                <VACTL:TextBox ID="txtItemName" Runat="server"
                        EnableViewState="False"
                        CssClass="input"
                        Width="200px"
                        CanBeNull="No"
                        FieldName="菜品名称"
                        MaxLength="25" />        
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)输 入 码：</td>
            <td>              
                <VACTL:TextBox ID="txtInputCode" Runat="server"
                        EnableViewState="False"
                        CssClass="input"
                        Width="200px"
                        CanBeNull="No"
                        FieldName="输入码"
                        MaxLength="30" />        
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)单位：</td>
            <td>
                <VACTL:TextBox runat="server" ID="txtUnit" 
                        CssClass="input" 
                        onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_units.aspx',true,true,310,180,0,true,'2',true);"
                        Width="100px"
                        CanBeNull="No"
                        FieldName="单位"
                        MaxLength="10"
                        Text="份" />
                <asp:HiddenField runat="server" id="txtUnit_hiddenValue" />
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)单价：</td>
            <td>
                <VACTL:TextBox runat="server" ID="txtPrice" 
                        CssClass="input" 
                        Width="100px"
                        CanBeNull="No"
                        FieldName="单价"
                        RequiredFieldType="Money"
                        />
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)提成类型：</td>
            <td>
                <asp:DropDownList ID="ddlCommisionType" Runat="server" 
                     Width="104px" 
                     >    
                    <asp:ListItem Value="0" Selected="True">不计提</asp:ListItem>
                    <asp:ListItem Value="1">按比例计提</asp:ListItem>
                    <asp:ListItem Value="2">按固定金额计提</asp:ListItem>
                </asp:DropDownList>
                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server"
                     ControlToValidate="ddlCommisionType"
                     ErrorMessage="[提成类型]必须选择一项！" />
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)提成系数：</td>
            <td>
                 <VACTL:TextBox runat="server" ID="txtCommisionXS" 
                        CssClass="input" 
                        Width="100px"
                        CanBeNull="No"
                        FieldName="提成系数"
                        RequiredFieldType="Money"
                        /> <span class="note">（填写小数，如：0.1表示按10%计提）</span>
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)会员折扣：</td>
            <td>
                 <VACTL:TextBox runat="server" ID="txtMemberDiscount" 
                        CssClass="input" 
                        Width="100px"
                        CanBeNull="No"
                        FieldName="会员折扣"
                        RequiredFieldType="Money"
                        MaximumValue="1"
                        /> （填写小数，如：0.8表示8折）
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)会员价格：</td>
            <td>
                 <VACTL:TextBox runat="server" ID="txtMemberPrice" 
                        CssClass="input" 
                        Width="100px"
                        CanBeNull="No"
                        FieldName="会员价格"
                        RequiredFieldType="Money"
                        Text="0"
                        /> <span class="note">（如果设置了会员价格，则会员折扣无效，0表示使用会员折扣）</span>
            </td>
            </tr>
            <tr id="Tr1" runat="server" visible="false">
            <td class="th">(<span class="note mustfill">*</span>)营销支持：</td>
            <td>
                <asp:DropDownList ID="ddlIsSupportSaleStrategy" Runat="server" Width="104px" >    
                    <asp:ListItem Value="1" Selected="True">支持</asp:ListItem>
                    <asp:ListItem Value="0">不支持</asp:ListItem>
                </asp:DropDownList>
                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server"
                     ControlToValidate="ddlIsSupportSaleStrategy"
                     ErrorMessage="[营销支持]必须选择一项！" />
            </td>
            </tr>
            <tr>
            <td class="th">(<span class="note mustfill">*</span>)后厨加工：</td>
            <td>
                <asp:DropDownList ID="ddlIsBackProcess" Runat="server" 
                     Width="104px" 
                     >    
                    <asp:ListItem Value="0">否</asp:ListItem>
                    <asp:ListItem Value="1"  Selected="True">是</asp:ListItem>
                </asp:DropDownList>
                <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server"
                     ControlToValidate="ddlCommisionType"
                     ErrorMessage="[后厨加工]必须选择一项！" />
            </td>
            </tr>
            <tr>
            <td class="th">图片：</td>
            <td>    
	            <VACTL:TextBox ID="txtItemImage" Runat="server"
		             EnableViewState="False"
		             CssClass="input"
                     Width="200px"
                     MaxLength="100"  />	
                <input type="button" id="Button1" class="simpleBtn" onclick="uploadImage()" value="上传图片" />
            </td>
            </tr>
            <tr>
            <td class="th">推荐星级：</td>
            <td>    
	            <asp:DropDownList ID="ddlStars" Runat="server" 
                     Width="104px">    
                    <asp:ListItem Value="5" Selected="True">★★★★★</asp:ListItem>
                    <asp:ListItem Value="4">★★★★☆</asp:ListItem>
                    <asp:ListItem Value="3">★★★☆☆</asp:ListItem>
                    <asp:ListItem Value="2">★★☆☆☆</asp:ListItem>
                    <asp:ListItem Value="1">★☆☆☆☆</asp:ListItem>                                
                </asp:DropDownList>
            </td>
            </tr>
            <tr runat="server" visible="false">
            <td class="th">备注：</td>
            <td>    
	            <VACTL:TextBox ID="txtRemark" Runat="server"
		             EnableViewState="False"
		             CssClass="input"
                     Width="200px"
                     MaxLength="100"  />	
            </td>
            </tr>            
            </table>
	    </div>
	    <div id="div_Desc" class="tabcontent" style="padding:3px;">

            <p style="margin-top:3px;margin-bottom:3px;font-size:14px;">在此填写菜品的详细介绍(手机点餐平台可以看到此信息，限500个汉字)：</p>
	        <VACTL:TextBox ID="txtItemDesc" Runat="server"
		             EnableViewState="False"
		             CssClass="input"
                     Width="640px"
                     MaxLength="500" 
                     TextMode="MultiLine"
                     Height="200px" />	
	    </div>
        <div id="div_SubItems" class="tabcontent" style="padding:3px;">

            <div style="overflow:hidden;margin-top:3px;margin-bottom:5px;font-size:14px;">
                <div style="float:left;margin-top:3px;">指每份菜所消耗的油盐酱醋等原料，系统后台自动完成配料消耗统计：</div>
                <div style="float:right;">
                    <input type="button" id="btnAddSubItems" class="simpleBtn" onclick="addSubItems()" value="添加" />
                    <input type="button" id="btnClearSubItems" class="simpleBtn" onclick="clearItems()" value="清除" />
                </div>
            </div>

	        <div class="formEditListTableWrapper" style="min-height:100px;">
            <table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:-1px;">
            <thead>
            <tr>
            <td style="width:30px;text-align:center;">No.</td>
            <td style="width:70px;text-align:center;display:none;">项目代码</td>
            <td style="width:190px;text-align:center;">品名</td>
            <td style="width:40px;text-align:center;">单位</td>
            <td style="width:60px;text-align:center;">单位成本</td>    
            <td style="width:40px;text-align:center;">数量</td>
            <td style="width:60px;text-align:center;">成本</td>
            <td style="width:60px;text-align:center;">操作</td>
            <td></td>
            </tr>    
            </thead>    

            <tbody>
            </tbody>
            </table>

            <table id="tbNoRecord" cellspacing="0" cellpadding="3" style="margin-top:-1px;width:100%;">
            <tr>
            <td style="text-align:center;height:100px;font-size:14px;">
                暂无数据
            </td>
            </tr>
            </table>
            </div>
	    </div>   
    </div>    
</div><!--divMainContainer.END-->   

<table id="tbToolBar" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td colspan="2" class="footer">
    <% if (base.flag == 0) { %>
    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="重置" />
    <% } else { %>
    <input type="button" id="Button2" class="btn" style="width:100px" onclick="save()" value="保存" />
    <% } %>    
    
    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfShopCode" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

<% if (base.chargeItemInfo != null) { %>
<%
    
    Response.Write("<script type=\"text/javascript\">");       
    Response.Write("var itemList = [");       
       
    var i = 0;       
    foreach (VA.Modules.JDingCYT.Core.Model.Goods.ChargeItemSubItemInfo item in base.chargeItemInfo.SubItems)
    {
        string RID = item.RID.ToString();
        string itemType = item.Item_Type;
        string itemCategory = item.Item_Category;
        string itemCode = item.Item_Code;
        string itemName = item.Item_Name;
        string unit = item.Unit;
        string price = item.Purchase_Price.ToString("F2");        
        string quantity = item.Quantity.ToString();
        
        Response.Write("{");
        Response.Write("\"itemType\":\"" + itemType + "\",\"itemCategory\":\"" + itemCategory + "\",\"itemName\":\"" + itemName + "\",\"itemCode\":\"" + itemCode + "\",\"unit\":\"" + unit + "\",\"price\":\"" + price + "\",\"quantity\":\"" + quantity + "\"");

        if (i == base.chargeItemInfo.SubItems.Count - 1)
            Response.Write("}");
        else
            Response.Write("},");
        
        i++;
    }

    Response.Write("];");      
    Response.Write("</script>");        
%>

<script type="text/javascript">
    for (var i = 0; i < itemList.length; i++) {
        formEditListTable_addRow(
        itemList[i].itemType,
        itemList[i].itemCategory,
        itemList[i].itemCode,
        itemList[i].itemName,
        itemList[i].unit,
        itemList[i].price,
        itemList[i].quantity);
    }
</script>

<% } %>

</form>
</body>
</html>

