﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="appointment_register.aspx.cs" Inherits="VA.Modules.JDingCYT.order.appointment_register" %>

<%@ Register src="uc_foodmenu.ascx" tagname="uc_foodmenu" tagprefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>订台登记</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <link href="/uicontrols/jtongui/themes/<% = webSiteConfig.ThemeName %>/tabs.css" type="text/css" rel="Stylesheet" />
    <link href="/uicontrols/jtongui/themes/<% = webSiteConfig.ThemeName %>/accordion.css" type="text/css" rel="Stylesheet" />
    <link href="../app_themes/<% = webSiteConfig.ThemeName %>/css/pages/appointment.css" type="text/css" rel="Stylesheet" />
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->          
    <script type="text/javascript" src="/uicontrols/jtongui/plugins/jtong.tabs.js"></script>
    <script type="text/javascript" src="/uicontrols/jtongui/plugins/jtong.accordion.js"></script>
    <script type="text/javascript">

    function cancel() {
        closeActivatedTopestWindow();
    }

    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("登记成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("登记失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {

            resetPage();
            cancelSave();
        }
    }

    function resetPage() {

        $("#txtMobileNo").val("");
        $("#txtCustomerName").val("");
        $("#txtRemark").val("");
        
        formEditListTable_clearRows();
        clearInputValidatorError();
    }

    function queryTables(date, timespanValue, timespanText) {        
        $("#ifTableList")[0].src = "appointment_register_gettablelist.aspx?date=" + date + "&timespan=" + timespanValue;

        $("#txtAppointmentDate").val(date + " " + timespanText);
        $("#hfAppointmentDate").val(date);
        $("#hfAppointmentTimespan").val(timespanValue);

        $("#txtTableNos").val("");
        $("#hfTableNos").val("");
    }

    function queryTablesByCustomerDateTime() {
        var date = $("#txtCustomerDate").val().trim();
        var timespanValue = $("#ddlTimespan").val();
        var timespanText = $("#ddlTimespan").find("option:selected").text();
        if (date == "") {
            JTongAlert('提示', "请指定日期！", 'warning');
            return;
        }
        queryTables(date, timespanValue, timespanText);
    }

    function takeTableInfo(tableNos) {
        $("#txtTableNos").val(tableNos);
        $("#hfTableNos").val(tableNos);
    }

    //尝试在后台加载顾客信息
    function loadCustomerInfo() {

        var mobileNo = $("#txtMobileNo").val();

        var requestType = "GET";
        var url = "get_regularcustomerinfo_json.aspx";
        var dataType = "html";
        var data = { "mobileno": mobileNo };
        var successFN = function (data, textStatus) {
            if (data != "error") {
                if (data == "") {
                    //do nothing                 
                } else {
                    var customerInfo = JSON.parse(data);
                    $("#txtCustomerName").val(customerInfo.Customer_Name);
                }
            }
            else {
                //do nothing
            }
        };
        var errorFN = function (textStatus, callback) {
            //do nothing
        }

        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    $(function () {
        
        $("#txtMobileNo").focus();
        $("#txtMobileNo").blur(function () {
            loadCustomerInfo();
        });

        //焦点控制
        $("input").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;
                switch (targetID) {
                    case "txtMobileNo":
                        $("#txtCustomerName").select();
                        break;
                    default:
                        break;
                }
            }
        });
    });

    </script>

    <style type="text/css">
        .editTable td.th {
            width:110px;
        }
    </style>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">
<div class="editPageWrapper" style="width:700px;float:left;">

<div class="centerFormTitle">
   <h1>订台登记</h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">手机号：</td>
<td>
    <VACTL:TextBox ID="txtMobileNo" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="220px"
            CanBeNull="No"
            FieldName="手机号"
            RequiredFieldType="Mobile"
            MaxLength="11"            
            Font-Size="16px"
            Font-Bold="true" /> 
</td>
<td class="th">姓名：</td>
<td>
    <VACTL:TextBox ID="txtCustomerName" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="220px"
            FieldName="姓名"
            MaxLength="10"
            Font-Size="16px"
            Font-Bold="true"
            />    
</td>
</tr>
<tr>
<td class="th">预订日期：</td>
<td>
    <VACTL:TextBox ID="txtAppointmentDate" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="220px"
            FieldName="预订日期"
            MaxLength="50"            
            Font-Size="16px"
            Font-Bold="true"
            Enabled="false" /> 
    <asp:HiddenField ID="hfAppointmentDate" runat="server" />
    <asp:HiddenField ID="hfAppointmentTimespan" runat="server" />
</td>
<td class="th">预订台号：</td>
<td>
    <VACTL:TextBox ID="txtTableNos" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="220px"
            FieldName="预订台号"
            MaxLength="50"            
            Font-Size="16px"
            Font-Bold="true"
            Enabled="false" /> 
    <asp:HiddenField ID="hfTableNos" runat="server" />
</td>
</tr>
</table>

<div id="dateNav">

    <asp:Repeater ID="rpDateNav" Runat="server" EnableViewState="False">
    <HeaderTemplate>   
    <table cellspacing="0" class="listTable" style="margin-top:-1px;">
    <thead>
    <tr>
    <td style="width:70px;text-align:center;">日期</td>
    <td style="text-align:center;">时间</td>    
    </tr>               
    </thead>    
    <tbody>
    </HeaderTemplate>
    <ItemTemplate>   
    <tr onclick="queryTables('<%# Eval("Date")%>','<%# Eval("TimespanValue")%>','<%# Eval("TimespanText")%>');">
    <td align="center"><%# Eval("Date")%></td>                
    <td align="left"><%# Eval("TimespanText")%></td>                                   
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </tbody>
    </table>   
    </FooterTemplate>
    </asp:Repeater>
    
    <div id="customDate" >
        <p>自定义：</p>
        <p>
        <VACTL:TextBox ID="txtCustomerDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="105px"
            RequiredFieldType="Date"
            onclick="laydate()"
            MaxLength="20" />
        </p>            
        <p style="margin-top:2px;">
        <asp:DropDownList ID="ddlTimespan" runat="server" Width="65px"></asp:DropDownList><input type="button" id="btnQuery" class="simpleBtn" style="width:40px;margin-left:4px;" onclick="queryTablesByCustomerDateTime()" value="确定" />
        </p>
    </div>

</div>

<div id="tableRegion">
    <iframe id="ifTableList" src="appointment_register_gettablelist.aspx?date=<% = DateTime.Now.ToString("yyyy-MM-dd", System.Globalization.CultureInfo.InvariantCulture) %>&timespan=<% =  VA.Modules.JDingCYT.Core.Utils.GetTimespanValue(DateTime.Now, base.SystemConfig) %>" style="width:100%;height:100%;border:0px;margin:0px;padding:0px;"  ></iframe>                
</div>

<div id="submitRegion">

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
    <tr>
    <td style="display:none;" class="th">服务员：</td>
    <td style="display:none;">
        <VACTL:TextBox ID="txtWaiter" Runat="server"
                    EnableViewState="False"
                    CssClass="input"
                    onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_employees.aspx',true,true,300,180);"
                    Width="100px"
                    />
        <asp:HiddenField runat="server" id="txtWaiter_hiddenValue" />  
        <input type="button" id="btnClearWaiters" class="simpleBtn" onclick="clearWaiters()" value="清除" />    
    </td>
    <td class="th">备注：</td>
    <td>
        <VACTL:TextBox ID="txtRemark" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="455"
            MaxLength="100"
            />        
    </td>
    </tr>
    </table>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
    <tr>
    <td class="footer">

        <input type="button" id="btnNext" class="btn" style="width:80px" onclick="save()" value="保存" />
        <input type="button" id="btnResetPage" class="btn" style="width:80px" onclick="cancel()" value="取消" />
        <asp:HiddenField ID="hfKey" runat="server" />
    
        <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
        <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
                DisplayMode="List"
                EnableClientScript="true" />
    
        <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
        <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
    </td>
    </tr>
    </table>
</div>

</div><!--editPageWrapper.END-->
</div><!--"wrapper.END"-->

</form>
</body>
</html>

