﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="appointment_editlist.aspx.cs" Inherits="VA.Modules.JDingCYT.mainbiz.appointment_editlist" %>

<%@ Import Namespace="System.Data"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>订台记录</title>    
    <!--#include virtual="/modules/cyt/include/css/editlist.aspx"-->
    <link href="/admin/app_themes/<% = webSiteConfig.ThemeName %>/css/edit.css" type="text/css" rel="Stylesheet" />
    <!--#include virtual="/modules/cyt/include/js/editlist.aspx"-->  
    <script type="text/javascript"> 

        //设置日期检索条件控件的行为；
        function setAppointmentDateControlBehavior() {

            var $ddlDate = $("#ddlAppointmentDateRule");
            if ($ddlDate.length == 0) {
                return;
            }

            if ($ddlDate.val() != "4") {
                $("#txtAppointmentBeginDate").attr("disabled", "disabled");
                $("#txtAppointmentEndDate").attr("disabled", "disabled");
            }
            $ddlDate.change(function () {
                var $txtBeginDate = $("#txtAppointmentBeginDate");
                var $txtEndDate = $("#txtAppointmentEndDate");
                var beginDate = null;
                var endDate = null;
                var sBeginDate = null;
                var sEndDate = null;

                var myDate = new Date();

                var dateRule = $ddlDate.val();
                if (dateRule == "1") { //今天                    
                    beginDate = myDate;
                    endDate = myDate;
                }
                else if (dateRule == "2") { //明天
                    beginDate = myDate.dateAdd("d", 1);
                    endDate = beginDate;
                }
                else if (dateRule == "3") { //后天
                    beginDate = myDate.dateAdd("d", 2);
                    endDate = beginDate;
                }                
                else if (dateRule == "4") { //自定义
                    beginDate = myDate;
                    endDate = myDate;
                    $("#txtAppointmentBeginDate").removeAttr("disabled");
                    $("#txtAppointmentEndDate").removeAttr("disabled");
                }

                sBeginDate = beginDate.format("yyyy-MM-dd");
                sEndDate = endDate.format("yyyy-MM-dd");

                $txtBeginDate.val(sBeginDate);
                $txtEndDate.val(sEndDate);

                if (dateRule == "4") { //自定义
                    //$("#txtBeginDate").val("");
                    $("#txtAppointmentEndDate").val("");
                }

                $("#btnSearch").click();
            });
        }

        //单条撤销；
        function scx(key) {

            $('#winCX').css("display", "block");
            $('#winCX').window({
                width: 350,
                height: 210,
                modal: true,
                minimizable: false,
                collapsible: false,
                title: '撤销确认'
            });

            $("#hf_BCXKey").val(key);
            $("#hf_BCXBizNo").val(key);
        }

        //撤销执行；
        function CXSave() {
            var keyValue = $("#hf_BCXKey").val();
            //singleActWrapper("CX", keyValue, "确定要撤单吗？", "");            
            var customArg = $("#ddlCXReason").find("option:selected").text();
            if (customArg == "其它原因") {
                customArg = $.trim($("#txtCustomReason").val());
                if (customArg == "") {
                    JTongAlert("提示", "请填写撤销原因！", "warning", function () {
                        $("#txtCustomReason").focus();
                    });
                    return;
                }
            }

            singleActWrapper("CX", keyValue, "", customArg);
        }

        //当服务端执行成功时，在弹出操作成功提示后，会执行该方法。
        function doWhenServerActSuc(currActName, customArg) {
            if (currActName == "CX") {
                closeWindow();
                window.location.reload(); //重新刷新页面。
            }
        }

        //关闭窗口；
        function closeWindow() {
            $('#winCX').window("close");
        }

        //单条删除；
        function sdel(keyValue) {
            singleActWrapper("Del", keyValue, "确定要取消该预订吗？", "");
        }

        //显示汇总金额；
        function afterDataListLoaded() {
            $("#statBar").html($("#divStatInfo").html());
        }

        $(function () {
            initListPage();
            setAppointmentDateControlBehavior();

            $("#txtCustomReason").hide();
            $("#ddlCXReason").change(function () {
                var reasonText = $("#ddlCXReason").val();
                if (reasonText == "其它原因") {
                    $("#txtCustomReason").show();
                    $("#txtCustomReason").focus();
                } else {
                    $("#txtCustomReason").hide();
                }
            });
        });
    </script>
</head>
<body>
<!--说明：该页面是以 employee_editlist_nofresh_5.aspx 为原型封装的结果-->
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper">        
    
    <div id="toolBar">    
      <%--  <a href="javascript:add()" class="jtongui-toolbarbutton" icon="icon-add">消费收银</a> --%>                     
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>            
        <asp:LinkButton ID="lbnExportToExcel" runat="server" CssClass="jtongui-toolbarbutton" icon="icon-export" OnClick="lbnExportToExcel_Click">导出</asp:LinkButton>

    </div><!--toolBar.END-->   
                     
    <div id="searchBar">
    
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>

        <asp:DropDownList ID="ddlStatus" runat="server"
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlStatus_SelectedIndexChanged">
        </asp:DropDownList>                

        <asp:DropDownList ID="ddlAppointmentDateRule" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">预订日期</asp:ListItem>
        <asp:ListItem Value="1">今天</asp:ListItem>
        <asp:ListItem Value="2">明天</asp:ListItem>
        <asp:ListItem Value="3">后天</asp:ListItem>        
        <asp:ListItem Value="4">自定义</asp:ListItem>
        </asp:DropDownList>  

        <VACTL:TextBox ID="txtAppointmentBeginDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />  
        -      
        <VACTL:TextBox ID="txtAppointmentEndDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />      
        
        <asp:DropDownList ID="ddlTimespan" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlTimespan_SelectedIndexChanged"
             ></asp:DropDownList>    
                
        <asp:DropDownList ID="ddlSearchField" runat="server">
        <asp:ListItem Value=""  Selected="True">检索字段</asp:ListItem>
        <asp:ListItem Value="1">手机号</asp:ListItem>
        <asp:ListItem Value="2">顾客姓名</asp:ListItem>
        <asp:ListItem Value="3">台号</asp:ListItem>
        </asp:DropDownList>               
                 
       <%-- <asp:DropDownList ID="ddlSearchType" runat="server">
        <asp:ListItem Value="1">模糊匹配</asp:ListItem>
        <asp:ListItem Value="2">精确匹配</asp:ListItem>
        </asp:DropDownList>     --%>          

        <asp:TextBox ID="txtKeyWords" runat="server"
            CssClass="input keywords"
            Width="100px" />              

        <asp:DropDownList ID="ddlDateRule" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">登记日期</asp:ListItem>
        <asp:ListItem Value="1">今天</asp:ListItem>
            <asp:ListItem Value="2">昨天</asp:ListItem>
            <asp:ListItem Value="3">前天</asp:ListItem>
            <asp:ListItem Value="4">近两天</asp:ListItem>
            <asp:ListItem Value="5">近三天</asp:ListItem>
            <asp:ListItem Value="6">近一周</asp:ListItem>
            <asp:ListItem Value="7">近一月</asp:ListItem>
            <asp:ListItem Value="8">上月</asp:ListItem>
            <asp:ListItem Value="9">本月</asp:ListItem>
            <asp:ListItem Value="10">自定义</asp:ListItem>
        </asp:DropDownList>  

        <VACTL:TextBox ID="txtBeginDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />  
        -      
        <VACTL:TextBox ID="txtEndDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />                     

        <asp:Button ID="btnSearch" runat="server" 
             CssClass="simpleBtn"
             Text="查询" 
             Onclick="btnSearch_Click" />
        
        </ContentTemplate>
        </asp:UpdatePanel>

    </div><!--searchBar.END-->    

    <div id="dataBar">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <%--<td style="width:30px;text-align:center;"><input type="checkbox" id="ckb_selectAll"/></td>--%>
        <td style="width:30px;text-align:center;">No.</td>            
        <td style="width:100px;text-align:center;">登记时间</td>	         
        <td style="width:70px;text-align:center;">登记人</td>         
        <td style="width:70px;text-align:center;">顾客姓名</td>                        
        <td style="width:70px;text-align:center;">手机号</td>  
        <td style="width:70px;text-align:center;">预订台号</td>                          
        <td style="width:100px;text-align:center;">预订时间</td>	         
        <td style="width:190px;text-align:center;">备注</td>  
        <td style="width:70px;text-align:center;">状态</td>           
        <td style="width:100px;text-align:center;">撤单时间</td>	         
        <td style="width:100px;text-align:center;">撤单原因</td>             
        <td style="width:70px;text-align:center;">撤单人</td>          
        <td style="width:100px;text-align:center;display:none;">门店</td>
        <td style="width:30px;text-align:center;">撤销</td>
        <td></td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <table cellpadding="3" cellspacing="0" class="tablebody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <%-- <td style="text-align:center;"><input type="checkbox" name="ckb_dataItem" value="<%# Eval("RID")%>" /></td>--%>
        <td align="center"><%# (base.currPage - 1)*base.PageSize + Container.ItemIndex + 1%>
            <input type="hidden" name="hfKey" value="<%# Eval("RID")%>" />
        </td>        
        <td align="center"><%# String.Format("{0:yyyy-MM-dd HH:mm}", Eval("Order_Date"))%>
        <td align="center"><%# Eval("OrderMan_Name")%></td> 
        <td align="center"><%# Eval("Customer_Name")%></td>         
        <td align="right"><%# Eval("MobileNo")%></td>        
        <td align="center"><%# Eval("Table_No")%></td>        
        <td align="center"><%# String.Format("{0:yyyy-MM-dd}", Eval("Appointment_Date"))%>
            <%# VA.Modules.JDingCYT.Core.Enums.AppointmentConverter.TimespanConverter.Convert_Value_ToText(Eval("Appointment_Timespan").ToString())%>
        </td>                
        <td align="left"><%# Eval("Remark")%></td>          
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.AppointmentConverter.StatusConverter.Convert_Value_ToText(Eval("Status").ToString(), true)%></td> 
        <td align="center"><%# String.Format("{0:yyyy-MM-dd HH:mm}", Eval("Cx_Date"))%></td>        
        <td align="left"><%# Eval("Cx_Reason")%></td>  
        <td align="center"><%# Eval("Cx_Operator_Name")%></td>  
        <td align="center" style="display:none;"><%# Eval("Shop_Name")%></td> 
        <td align="center">
            <%# base.ShowCXIcon(Eval("RID").ToString(), Eval("Status").ToString())%>            
        </td> 
        <td></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <div id="divPagerInfo" style="display:none">
        <%=base.pageInfo%>
    </div>

    <input type="hidden" id="hidden_pageCnt" value="<% = base.PageCnt%>" />
    <input type="hidden" id="hidden_rdCnt" value="<% = base.RdCnt%>" />
    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

    <div id="pagerBar">
       ……
    </div><!--pageNavBar.END-->
    
    <asp:HiddenField runat="server" ID="hfCurrPage" EnableViewState="true" />
    
</div>

<!--撤单详情窗口-->
<div id="winCX" style="display:none;">

    <div style="width:300px;padding:10px;margin:auto;">

    <div class="centerFormTitle">
        <h1>撤销确认</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;">    
    <tr>
    <td class="th">撤销原因：</td>
    <td>
        <input type="hidden" id="hf_BCXKey" name="hf_BCXKey" />
        <input type="hidden" id="hf_BCXBizNo" name="hf_BCXBizNo" />
            
        <asp:DropDownList ID="ddlCXReason" runat="server" EnableViewState="false">
        <asp:ListItem Value="顾客要求" Selected="True">顾客要求</asp:ListItem>
        <asp:ListItem Value="其它原因">其它原因</asp:ListItem>
        </asp:DropDownList>          
        <input type="text" class="input" style="width:90px;" id="txtCustomReason" name="txtCustomReason" maxlength="20" />
    </td>
    </tr>
    <tr>
    <td colspan="2" class="footer">
        <input type="button" id="btnCXBill" class="btn" style="width:80px" onclick="CXSave()" value="撤单" />
        <input type="button" id="btnClose" class="btn" style="width:80px" onclick="closeWindow()" value="关闭" />
    </td>
    </tr>
    </table>

    </div>
</div> 

</form>
</body>
</html> 
